/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.actions.style;

import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.openl.rules.lang.xls.types.meta.MetaInfoWriter;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.IWritableGrid;
import org.openl.rules.table.actions.AUndoableCellAction;
import org.openl.rules.table.ui.ICellStyle;

public class SetAlignmentAction
extends AUndoableCellAction {
    private HorizontalAlignment prevAlignment;
    private final HorizontalAlignment newAlignment;

    public SetAlignmentAction(int col, int row, HorizontalAlignment alignment, MetaInfoWriter metaInfoWriter) {
        super(col, row, metaInfoWriter);
        this.newAlignment = alignment;
    }

    @Override
    public void doAction(IGridTable table) {
        IWritableGrid grid = (IWritableGrid)table.getGrid();
        ICellStyle style = grid.getCell(this.getCol(), this.getRow()).getStyle();
        this.prevAlignment = style != null ? style.getHorizontalAlignment() : HorizontalAlignment.GENERAL;
        grid.setCellAlignment(this.getCol(), this.getRow(), this.newAlignment);
    }

    @Override
    public void undoAction(IGridTable table) {
        IWritableGrid grid = (IWritableGrid)table.getGrid();
        grid.setCellAlignment(this.getCol(), this.getRow(), this.prevAlignment);
    }
}

