/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.tbasic;

import org.openl.rules.tbasic.AlgorithmSubroutineMethod;
import org.openl.types.IMemberMetaInfo;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.vm.IRuntimeEnv;

public class NoParamMethodField
implements IOpenField {
    private final String fieldName;
    private final AlgorithmSubroutineMethod methodToInvoke;

    public NoParamMethodField(String theFieldName, AlgorithmSubroutineMethod theMethodToInvoke) {
        assert (theMethodToInvoke.getSignature().getParameterTypes().length == 0);
        this.fieldName = theFieldName;
        this.methodToInvoke = theMethodToInvoke;
    }

    public Object get(Object target, IRuntimeEnv env) {
        return this.methodToInvoke.invoke(target, new Object[0], env);
    }

    public IOpenClass getDeclaringClass() {
        return this.methodToInvoke.getDeclaringClass();
    }

    public String getDisplayName(int mode) {
        return this.methodToInvoke.getDisplayName(mode);
    }

    public IMemberMetaInfo getInfo() {
        return null;
    }

    public String getName() {
        return this.fieldName;
    }

    public IOpenClass getType() {
        return this.methodToInvoke.getType();
    }

    public boolean isConst() {
        return false;
    }

    public boolean isReadable() {
        return true;
    }

    public boolean isStatic() {
        return this.methodToInvoke.isStatic();
    }

    public boolean isWritable() {
        return false;
    }

    public void set(Object target, Object value, IRuntimeEnv env) {
        throw new UnsupportedOperationException(String.format("Set operation is not supported for method proxy field '%s'", this.fieldName));
    }
}

