/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.tbasic.compile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.impl.BindHelper;
import org.openl.binding.impl.component.ComponentBindingContext;
import org.openl.binding.impl.component.ComponentOpenClass;
import org.openl.engine.OpenLManager;
import org.openl.meta.StringValue;
import org.openl.rules.binding.RulesModuleBindingContextHelper;
import org.openl.rules.tbasic.Algorithm;
import org.openl.rules.tbasic.AlgorithmSubroutineMethod;
import org.openl.rules.tbasic.AlgorithmTreeNode;
import org.openl.rules.tbasic.NoParamMethodField;
import org.openl.rules.tbasic.TBasicSpecificationKey;
import org.openl.rules.tbasic.compile.AlgorithmCompilerTool;
import org.openl.rules.tbasic.compile.AlgorithmFunctionCompiler;
import org.openl.rules.tbasic.compile.AlgorithmOpenClass;
import org.openl.rules.tbasic.compile.CompileContext;
import org.openl.rules.tbasic.compile.ConversionRuleBean;
import org.openl.rules.tbasic.compile.ConversionRuleStep;
import org.openl.rules.tbasic.compile.ConversionRulesController;
import org.openl.rules.tbasic.compile.LabelManager;
import org.openl.rules.tbasic.compile.OperationType;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.types.IMethodCaller;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMethod;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.impl.DynamicObjectField;
import org.openl.types.impl.OpenMethodHeader;
import org.openl.types.java.JavaOpenClass;

public class AlgorithmCompiler {
    private final IBindingContext context;
    private final IOpenMethodHeader header;
    private final List<AlgorithmTreeNode> nodesToCompile;
    private CompileContext mainCompileContext;
    private final List<AlgorithmFunctionCompiler> functions = new ArrayList<AlgorithmFunctionCompiler>();
    private LabelManager labelManager;
    private AlgorithmOpenClass thisTargetClass;
    private IBindingContext thisContext;
    private final Map<String, OperationPreprocessor> operationPreprocessors = new HashMap<String, OperationPreprocessor>();
    private final Stack<Collection<IOpenField>> variablesStack = new Stack();

    public AlgorithmCompiler(IBindingContext context, IOpenMethodHeader header, List<AlgorithmTreeNode> nodesToCompile) {
        this.operationPreprocessors.put(OperationType.COMPILE.toString(), new CompilePreprocessor());
        this.operationPreprocessors.put(OperationType.DECLARE.toString(), new DeclarePreprocessor());
        this.operationPreprocessors.put(OperationType.DECLARE_ARRAY_ELEMENT.toString(), new DeclareArrayElementPreprocessor());
        this.operationPreprocessors.put(OperationType.SUBROUTINE.toString(), new DeclareSubroutinePreprocessor());
        this.operationPreprocessors.put(OperationType.FUNCTION.toString(), new DeclareFunctionPreprocessor());
        this.context = context;
        this.header = header;
        this.nodesToCompile = nodesToCompile;
    }

    public void compile(Algorithm algorithm, IBindingContext bindingContext) {
        this.initialization(algorithm, bindingContext);
        this.precompileNestedNodes(this.nodesToCompile, bindingContext);
        this.compile(bindingContext);
        this.postprocess(algorithm);
    }

    private void compile(IBindingContext bindingContext) {
        this.getThisTargetClass().allFieldsToVisible();
        for (AlgorithmFunctionCompiler functionCompiler : this.functions) {
            functionCompiler.compile(bindingContext);
        }
    }

    private void createAlgorithmInternalMethod(List<AlgorithmTreeNode> nodesToCompile, IOpenClass returnType, CompileContext methodContext, IBindingContext bindingContext) {
        for (StringValue label : nodesToCompile.get(0).getLabels()) {
            String methodName = label.getValue();
            OpenMethodHeader methodHeader = new OpenMethodHeader(methodName, returnType, IMethodSignature.VOID, (IOpenClass)this.thisTargetClass);
            AlgorithmSubroutineMethod method = new AlgorithmSubroutineMethod((IOpenMethodHeader)methodHeader);
            this.thisTargetClass.addMethod((IOpenMethod)method);
            NoParamMethodField methodAlternative = new NoParamMethodField(methodName, method);
            this.thisTargetClass.addField(methodAlternative);
            this.functions.add(new AlgorithmFunctionCompiler(nodesToCompile, methodContext, method, this));
        }
        Map<String, AlgorithmTreeNode> internalLablesOfMethod = AlgorithmCompilerTool.getAllDeclaredLables(nodesToCompile);
        methodContext.registerGroupOfLabels(internalLablesOfMethod, bindingContext);
    }

    private IBindingContext getAlgorithmBindingContext() {
        if (this.thisContext == null) {
            this.thisContext = new ComponentBindingContext(this.context, (ComponentOpenClass)this.thisTargetClass);
        }
        return this.thisContext;
    }

    private void declareFunction(List<AlgorithmTreeNode> nodesToCompile, ConversionRuleStep convertionStep, IBindingContext bindingContext) {
        String returnValueInstruction = convertionStep.getOperationParam1();
        IOpenClass returnType = AlgorithmCompilerTool.isOperationFieldInstruction(returnValueInstruction) ? this.getTypeOfField(AlgorithmCompilerTool.getCellContent(nodesToCompile, returnValueInstruction, bindingContext), bindingContext) : this.discoverFunctionType(nodesToCompile.get(0).getChildren(), bindingContext);
        this.createAlgorithmInternalMethod(nodesToCompile, returnType, new CompileContext(), bindingContext);
    }

    private void declareSubroutine(List<AlgorithmTreeNode> nodesToCompile, IBindingContext bindingContext) {
        CompileContext subroutineContext = new CompileContext();
        subroutineContext.registerGroupOfLabels(this.mainCompileContext.getExistingLables(), bindingContext);
        this.createAlgorithmInternalMethod(nodesToCompile, (IOpenClass)JavaOpenClass.VOID, subroutineContext, bindingContext);
    }

    private void declareVariable(List<AlgorithmTreeNode> nodesToCompile, ConversionRuleStep conversionStep, IBindingContext bindingContext) {
        String variableNameParameter = conversionStep.getOperationParam1();
        String variableAssignmentParameter = conversionStep.getOperationParam2();
        StringValue variableName = AlgorithmCompilerTool.getCellContent(nodesToCompile, variableNameParameter, bindingContext);
        IOpenClass variableType = this.getTypeOfField(AlgorithmCompilerTool.getCellContent(nodesToCompile, variableAssignmentParameter, bindingContext), bindingContext);
        this.initNewInternalVariable(variableName.getValue(), variableType);
    }

    private void declareArrayElement(List<AlgorithmTreeNode> nodesToCompile, ConversionRuleStep conversionStep, IBindingContext bindingContext) {
        String elementNameParameter = conversionStep.getOperationParam1();
        String iterableArrayParameter = conversionStep.getOperationParam2();
        StringValue elementName = AlgorithmCompilerTool.getCellContent(nodesToCompile, elementNameParameter, bindingContext);
        IOpenClass iterableArrayType = this.getTypeOfField(AlgorithmCompilerTool.getCellContent(nodesToCompile, iterableArrayParameter, bindingContext), bindingContext);
        if (!iterableArrayType.isArray()) {
            IOpenSourceCodeModule errorSource = nodesToCompile.get(0).getAlgorithmRow().getAction().asSourceCodeModule();
            BindHelper.processError((String)"Compilation failure. The cell should be of the array type", (IOpenSourceCodeModule)errorSource, (IBindingContext)bindingContext);
        }
        IOpenClass elementType = iterableArrayType.getComponentClass();
        this.initNewInternalVariable(elementName.getValue(), elementType);
    }

    private IOpenClass discoverFunctionType(List<AlgorithmTreeNode> children, IBindingContext bindingContext) {
        List<AlgorithmTreeNode> returnNodes = AlgorithmCompiler.findFirstReturn(children);
        if (returnNodes == null || returnNodes.isEmpty()) {
            StringValue lastAction = AlgorithmCompilerTool.getLastExecutableOperation(children).getAlgorithmRow().getAction();
            return this.getTypeOfField(lastAction, bindingContext);
        }
        String fieldWithOpenLStatement = "RETURN.condition";
        return this.getTypeOfField(AlgorithmCompilerTool.getCellContent(returnNodes, fieldWithOpenLStatement, bindingContext), bindingContext);
    }

    private static List<AlgorithmTreeNode> findFirstReturn(List<AlgorithmTreeNode> nodes) {
        List<AlgorithmTreeNode> returnNodeSubList = null;
        for (int i = 0; i < nodes.size() && returnNodeSubList == null; ++i) {
            if (TBasicSpecificationKey.RETURN.toString().equals(nodes.get(i).getSpecificationKeyword())) {
                returnNodeSubList = nodes.subList(i, i + 1);
                continue;
            }
            if (nodes.get(i).getChildren() == null) continue;
            returnNodeSubList = AlgorithmCompiler.findFirstReturn(nodes.get(i).getChildren());
        }
        return returnNodeSubList;
    }

    private String generateOpenClassName() {
        return this.header.getName();
    }

    public LabelManager getLabelManager() {
        return this.labelManager;
    }

    private List<AlgorithmTreeNode> getMainFunctionBody() {
        int currentOperationIndex;
        for (currentOperationIndex = 0; currentOperationIndex < this.nodesToCompile.size() && !TBasicSpecificationKey.FUNCTION.toString().equals(this.nodesToCompile.get(currentOperationIndex).getSpecificationKeyword()) && !TBasicSpecificationKey.SUB.toString().equals(this.nodesToCompile.get(currentOperationIndex).getSpecificationKeyword()); ++currentOperationIndex) {
        }
        return this.nodesToCompile.subList(0, currentOperationIndex);
    }

    public AlgorithmOpenClass getThisTargetClass() {
        return this.thisTargetClass;
    }

    public IOpenClass getTypeOfField(StringValue fieldContent, IBindingContext bindingContext) {
        IOpenSourceCodeModule src = fieldContent.asSourceCodeModule();
        OpenL openl = this.context.getOpenL();
        IMethodSignature signature = this.header.getSignature();
        return OpenLManager.makeMethodWithUnknownType((OpenL)openl, (IOpenSourceCodeModule)src, (String)("cell_" + fieldContent.getValue()), (IMethodSignature)signature, (IOpenClass)this.thisTargetClass, (IBindingContext)this.getAlgorithmBindingContext()).getMethod().getType();
    }

    private void initialization(Algorithm algorithm, IBindingContext bindingContext) {
        this.labelManager = new LabelManager();
        this.thisTargetClass = new AlgorithmOpenClass(this.generateOpenClassName(), this.context.getOpenL());
        this.variablesStack.push(new ArrayList());
        this.initNewInternalVariable("ERROR", (IOpenClass)JavaOpenClass.getOpenClass(RuntimeException.class));
        this.initNewInternalVariable("Error Message", (IOpenClass)JavaOpenClass.STRING);
        this.mainCompileContext = new CompileContext();
        List<AlgorithmTreeNode> mainFunction = this.getMainFunctionBody();
        this.mainCompileContext.registerGroupOfLabels(AlgorithmCompilerTool.getAllDeclaredLables(mainFunction), bindingContext);
        this.functions.add(new AlgorithmFunctionCompiler(mainFunction, this.mainCompileContext, algorithm, this));
    }

    private void initNewInternalVariable(String variableName, IOpenClass variableType) {
        DynamicObjectField field = new DynamicObjectField((IOpenClass)this.thisTargetClass, variableName, variableType);
        this.getThisTargetClass().addField((IOpenField)field);
        this.variablesStack.peek().add((IOpenField)field);
    }

    public IMethodCaller makeMethod(IOpenSourceCodeModule src, String methodName) {
        OpenL openl = this.context.getOpenL();
        IMethodSignature signature = this.header.getSignature();
        IBindingContext cxt = this.getAlgorithmBindingContext();
        return OpenLManager.makeMethodWithUnknownType((OpenL)openl, (IOpenSourceCodeModule)src, (String)methodName, (IMethodSignature)signature, (IOpenClass)this.thisTargetClass, (IBindingContext)cxt);
    }

    public IMethodCaller makeMethodWithCast(IOpenSourceCodeModule src, String methodName, IOpenClass returnType) {
        OpenL openl = this.context.getOpenL();
        IMethodSignature signature = this.header.getSignature();
        OpenMethodHeader header = new OpenMethodHeader(methodName, returnType, signature, (IOpenClass)this.thisTargetClass);
        IBindingContext cxt = this.getAlgorithmBindingContext();
        RulesModuleBindingContextHelper.compileAllTypesInSignature(header.getSignature(), this.context);
        return OpenLManager.makeMethod((OpenL)openl, (IOpenSourceCodeModule)src, (IOpenMethodHeader)header, (IBindingContext)cxt);
    }

    private void postprocess(Algorithm algorithm) {
        for (AlgorithmFunctionCompiler functionCompiler : this.functions) {
            functionCompiler.postprocess();
        }
        algorithm.setThisClass((IOpenClass)this.getThisTargetClass());
    }

    private void precompileLinkedNodesGroup(List<AlgorithmTreeNode> nodesToCompile, IBindingContext bindingContext) {
        assert (!nodesToCompile.isEmpty());
        ConversionRuleBean conversionRule = ConversionRulesController.getInstance().getConvertionRule(nodesToCompile, bindingContext);
        if (conversionRule == null) {
            return;
        }
        for (ConversionRuleStep convertionStep : conversionRule.getConvertionSteps()) {
            this.preprocessConversionStep(nodesToCompile, convertionStep, bindingContext);
        }
    }

    private void precompileNestedNodes(List<AlgorithmTreeNode> nodesToProcess, IBindingContext bindingContext) {
        int linkedNodesGroupSize;
        for (int i = 0; i < nodesToProcess.size(); i += linkedNodesGroupSize) {
            linkedNodesGroupSize = AlgorithmCompilerTool.getLinkedNodesGroupSize(nodesToProcess, i);
            List<AlgorithmTreeNode> nodesToCompile = nodesToProcess.subList(i, i + linkedNodesGroupSize);
            this.precompileLinkedNodesGroup(nodesToCompile, bindingContext);
        }
    }

    private void preprocessConversionStep(List<AlgorithmTreeNode> nodesToCompile, ConversionRuleStep conversionStep, IBindingContext bindingContext) {
        assert (!nodesToCompile.isEmpty());
        assert (conversionStep != null);
        String operationType = conversionStep.getOperationType();
        if (operationType.startsWith("!") && !operationType.equals(OperationType.CHECK_LABEL.toString())) {
            OperationPreprocessor preprocessor = this.operationPreprocessors.get(operationType);
            if (preprocessor == null) {
                IOpenSourceCodeModule errorSource = nodesToCompile.get(0).getAlgorithmRow().getOperation().asSourceCodeModule();
                BindHelper.processError((String)String.format("Unknown compilation instruction %s", operationType), (IOpenSourceCodeModule)errorSource, (IBindingContext)bindingContext);
            } else {
                preprocessor.preprocess(nodesToCompile, conversionStep, bindingContext);
            }
        }
    }

    private void updateVariablesVisibitily(Collection<IOpenField> fields) {
        for (IOpenField field : fields) {
            this.thisTargetClass.setFieldToInvisibleState(field.getName());
        }
    }

    private final class DeclareFunctionPreprocessor
    implements OperationPreprocessor {
        private DeclareFunctionPreprocessor() {
        }

        @Override
        public void preprocess(List<AlgorithmTreeNode> nodesToCompile, ConversionRuleStep conversionStep, IBindingContext bindingContext) {
            AlgorithmCompiler.this.declareFunction(nodesToCompile, conversionStep, bindingContext);
        }
    }

    private final class DeclareSubroutinePreprocessor
    implements OperationPreprocessor {
        private DeclareSubroutinePreprocessor() {
        }

        @Override
        public void preprocess(List<AlgorithmTreeNode> nodesToCompile, ConversionRuleStep conversionStep, IBindingContext bindingContext) {
            AlgorithmCompiler.this.declareSubroutine(nodesToCompile, bindingContext);
        }
    }

    private final class DeclareArrayElementPreprocessor
    implements OperationPreprocessor {
        private DeclareArrayElementPreprocessor() {
        }

        @Override
        public void preprocess(List<AlgorithmTreeNode> nodesToCompile, ConversionRuleStep conversionStep, IBindingContext bindingContext) {
            AlgorithmCompiler.this.declareArrayElement(nodesToCompile, conversionStep, bindingContext);
        }
    }

    private final class DeclarePreprocessor
    implements OperationPreprocessor {
        private DeclarePreprocessor() {
        }

        @Override
        public void preprocess(List<AlgorithmTreeNode> nodesToCompile, ConversionRuleStep conversionStep, IBindingContext bindingContext) {
            AlgorithmCompiler.this.declareVariable(nodesToCompile, conversionStep, bindingContext);
        }
    }

    private final class CompilePreprocessor
    implements OperationPreprocessor {
        private CompilePreprocessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void preprocess(List<AlgorithmTreeNode> nodesToCompile, ConversionRuleStep conversionStep, IBindingContext bindingContext) {
            List<AlgorithmTreeNode> nodesToProcess = AlgorithmCompilerTool.getNestedInstructionsBlock(nodesToCompile, conversionStep.getOperationParam1(), bindingContext);
            try {
                AlgorithmCompiler.this.variablesStack.push(new ArrayList());
                AlgorithmCompiler.this.precompileNestedNodes(nodesToProcess, bindingContext);
            }
            finally {
                AlgorithmCompiler.this.updateVariablesVisibitily(AlgorithmCompiler.this.variablesStack.pop());
            }
        }
    }

    public static interface OperationPreprocessor {
        public void preprocess(List<AlgorithmTreeNode> var1, ConversionRuleStep var2, IBindingContext var3);
    }
}

