/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.validation;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.openl.domain.IDomain;
import org.openl.exception.OpenLCompilationException;
import org.openl.message.OpenLMessage;
import org.openl.message.OpenLMessagesUtils;
import org.openl.rules.dt.IBaseCondition;
import org.openl.rules.dt.IDecisionTable;
import org.openl.rules.dt.type.domains.DomainAdaptorFactory;
import org.openl.rules.dt.type.domains.IDomainAdaptor;
import org.openl.rules.dt.validator.DecisionTableAnalyzer;
import org.openl.rules.dt.validator.DecisionTableValidationResult;
import org.openl.rules.dt.validator.DecisionTableValidator;
import org.openl.rules.enumeration.ValidateDTEnum;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.method.ExecutableRulesMethod;
import org.openl.rules.validation.OpenMethodDispatcherHelper;
import org.openl.rules.validation.TablesValidator;
import org.openl.rules.validation.ValidationUtils;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.types.IParameterDeclaration;
import org.openl.validation.ValidationResult;

public class GapOverlapValidator
extends TablesValidator {
    private static final String VALIDATION_FAILED = "Validation failed for node : ";

    @Override
    public ValidationResult validateTables(TableSyntaxNode[] tableSyntaxNodes, IOpenClass openClass) {
        List<IOpenMethod> allModuleMethods = OpenMethodDispatcherHelper.extractMethods(openClass);
        LinkedHashSet<OpenLMessage> messages = new LinkedHashSet<OpenLMessage>();
        for (IOpenMethod method : allModuleMethods) {
            IDecisionTable decisionTable;
            DecisionTableValidationResult dtValidResult;
            ExecutableRulesMethod executableMethod;
            if (!(method instanceof ExecutableRulesMethod) || !GapOverlapValidator.isValidatableMethod(executableMethod = (ExecutableRulesMethod)method) || (dtValidResult = this.validate(messages, openClass, decisionTable = (IDecisionTable)((Object)executableMethod))) == null || !dtValidResult.hasProblems()) continue;
            decisionTable.getSyntaxNode().setValidationResult(dtValidResult);
            if (dtValidResult.hasErrors()) {
                this.addError(messages, decisionTable.getSyntaxNode(), dtValidResult.toString());
                continue;
            }
            messages.add(OpenLMessagesUtils.newWarnMessage((String)dtValidResult.toString(), (ISyntaxNode)decisionTable.getSyntaxNode()));
        }
        return ValidationUtils.withMessages(messages);
    }

    private void addError(Collection<OpenLMessage> messages, TableSyntaxNode tableSyntaxNode, String message) {
        SyntaxNodeException sne = SyntaxNodeExceptionUtils.createError((String)message, (ISyntaxNode)tableSyntaxNode);
        messages.add(OpenLMessagesUtils.newErrorMessage((OpenLCompilationException)((Object)sne)));
    }

    private DecisionTableValidationResult validate(Collection<OpenLMessage> messages, IOpenClass openClass, IDecisionTable decisionTable) {
        DecisionTableValidationResult dtValidResult = null;
        try {
            Map<String, IDomainAdaptor> domains = this.gatherDomains(decisionTable);
            dtValidResult = DecisionTableValidator.validateTable(decisionTable, domains, openClass);
        }
        catch (Exception t) {
            String errorMessage = String.format("%s%s.Reason : %s", VALIDATION_FAILED, decisionTable.getSyntaxNode().getDisplayName(), t.getMessage());
            this.addError(messages, decisionTable.getSyntaxNode(), errorMessage);
        }
        return dtValidResult;
    }

    private Map<String, IDomainAdaptor> gatherDomains(IDecisionTable dt) throws Exception {
        HashMap<String, IDomainAdaptor> domainsMap = new HashMap<String, IDomainAdaptor>();
        DecisionTableAnalyzer analyzer = new DecisionTableAnalyzer(dt);
        for (IBaseCondition condition : dt.getConditionRows()) {
            IParameterDeclaration[] pd;
            for (IParameterDeclaration iParameterDeclaration : pd = analyzer.referencedSignatureParams(condition)) {
                IDomain<?> domain = iParameterDeclaration.getType().getDomain();
                if (domain != null) continue;
                domain = condition.getConditionEvaluator().getRuleParameterDomain(condition);
                IDomainAdaptor adaptor = DomainAdaptorFactory.getAdaptor(domain);
                domainsMap.put(iParameterDeclaration.getName(), adaptor);
            }
            IParameterDeclaration[] cparams = condition.getParams();
            for (int i = 0; i < cparams.length; ++i) {
                IDomain<?> domain = cparams[i].getType().getDomain();
                if (domain != null || (domain = condition.getConditionEvaluator().getConditionParameterDomain(i, condition)) == null) continue;
                IDomainAdaptor adaptor = DomainAdaptorFactory.getAdaptor(domain);
                domainsMap.put(DecisionTableValidator.getUniqueConditionParamName(condition, cparams[i].getName()), adaptor);
            }
        }
        return domainsMap;
    }

    private static boolean isValidatableMethod(ExecutableRulesMethod executableMethod) {
        return executableMethod.getMethodProperties() != null && ValidateDTEnum.ON.equals((Object)executableMethod.getMethodProperties().getValidateDT());
    }
}

