/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.convertor;

import java.text.DecimalFormat;
import org.openl.rules.convertor.String2NumberConverter;

class String2FloatConvertor
extends String2NumberConverter<Float> {
    String2FloatConvertor() {
    }

    @Override
    Float convert(Number number, String data) {
        float value = number.floatValue();
        double dValue = number.doubleValue();
        if (!Double.isInfinite(dValue) && Float.isInfinite(value)) {
            throw new NumberFormatException(String.format("A number '%s' is out of range.", data));
        }
        return Float.valueOf(value);
    }

    @Override
    DecimalFormat getFormatter(String format) {
        DecimalFormat formatter = super.getFormatter(format);
        formatter.setMinimumFractionDigits(1);
        return formatter;
    }
}

