/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.algorithm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Objects;
import org.openl.binding.BindingDependencies;
import org.openl.binding.IBindingContext;
import org.openl.binding.impl.BindHelper;
import org.openl.domain.IIntIterator;
import org.openl.domain.IIntSelector;
import org.openl.rules.binding.RulesBindingDependencies;
import org.openl.rules.dt.DecisionTable;
import org.openl.rules.dt.DecisionTableRuleNode;
import org.openl.rules.dt.algorithm.IDecisionTableAlgorithm;
import org.openl.rules.dt.algorithm.IndexInfo;
import org.openl.rules.dt.algorithm.evaluator.CombinedRangeIndexEvaluator;
import org.openl.rules.dt.algorithm.evaluator.ContainsInArrayIndexedEvaluator;
import org.openl.rules.dt.algorithm.evaluator.ContainsInArrayIndexedEvaluatorV2;
import org.openl.rules.dt.algorithm.evaluator.ContainsInOrNotInArrayIndexedEvaluator;
import org.openl.rules.dt.algorithm.evaluator.DefaultConditionEvaluator;
import org.openl.rules.dt.algorithm.evaluator.EqualsIndexedEvaluator;
import org.openl.rules.dt.algorithm.evaluator.EqualsIndexedEvaluatorV2;
import org.openl.rules.dt.algorithm.evaluator.IConditionEvaluator;
import org.openl.rules.dt.data.ConditionOrActionDirectParameterField;
import org.openl.rules.dt.data.ConditionOrActionParameterField;
import org.openl.rules.dt.element.ConditionCasts;
import org.openl.rules.dt.element.ConditionHelper;
import org.openl.rules.dt.element.ICondition;
import org.openl.rules.dt.index.IRuleIndex;
import org.openl.rules.dt.type.BooleanAdaptorFactory;
import org.openl.rules.dt.type.BooleanTypeAdaptor;
import org.openl.rules.dt.type.CharRangeAdaptor;
import org.openl.rules.dt.type.DateRangeAdaptor;
import org.openl.rules.dt.type.DoubleRangeAdaptor;
import org.openl.rules.dt.type.DoubleRangeForIntRangeAdaptor;
import org.openl.rules.dt.type.IRangeAdaptor;
import org.openl.rules.dt.type.IntRangeAdaptor;
import org.openl.rules.dt.type.StringRangeAdaptor;
import org.openl.rules.helpers.CharRange;
import org.openl.rules.helpers.DateRange;
import org.openl.rules.helpers.DoubleRange;
import org.openl.rules.helpers.IntRange;
import org.openl.rules.helpers.NumberUtils;
import org.openl.rules.helpers.StringRange;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.types.IAggregateInfo;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IParameterDeclaration;
import org.openl.types.NullParameterDeclaration;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.ClassUtils;
import org.openl.vm.IRuntimeEnv;
import org.openl.vm.Tracer;

public class DecisionTableOptimizedAlgorithm
implements IDecisionTableAlgorithm {
    private final ConditionToEvaluatorHolder[] evaluators;
    private final IRuleIndex indexRoot;
    private final IndexInfo info;
    private BindingDependencies dependencies;

    DecisionTableOptimizedAlgorithm(IConditionEvaluator[] evaluators, DecisionTable table, IndexInfo info) {
        this.evaluators = this.initEvaluators(evaluators, table, info);
        this.info = info;
        this.indexRoot = this.buildIndex(info);
        this.dependencies = new RulesBindingDependencies();
        table.updateDependency(this.dependencies);
    }

    static IRangeAdaptor<? extends Object, ? extends Comparable<?>> getRangeAdaptor(IOpenClass methodType, IOpenClass paramType) {
        if (NumberUtils.isNonFloatPointType(methodType.getInstanceClass()) && DecisionTableOptimizedAlgorithm.isIntRangeType(paramType)) {
            return IntRangeAdaptor.getInstance();
        }
        if (NumberUtils.isFloatPointType(methodType.getInstanceClass()) && DecisionTableOptimizedAlgorithm.isIntRangeType(paramType)) {
            return DoubleRangeForIntRangeAdaptor.getInstance();
        }
        if (NumberUtils.isNumberType(methodType.getInstanceClass()) && DecisionTableOptimizedAlgorithm.isDoubleRangeType(paramType)) {
            return DoubleRangeAdaptor.getInstance();
        }
        if (DecisionTableOptimizedAlgorithm.isCharType(methodType) && DecisionTableOptimizedAlgorithm.isCharRangeType(paramType)) {
            return CharRangeAdaptor.getInstance();
        }
        if (DecisionTableOptimizedAlgorithm.isDateType(methodType) && DecisionTableOptimizedAlgorithm.isDateRangeType(paramType)) {
            return DateRangeAdaptor.getInstance();
        }
        if (DecisionTableOptimizedAlgorithm.isStringType(methodType) && DecisionTableOptimizedAlgorithm.isStringRangeType(paramType)) {
            return StringRangeAdaptor.getInstance();
        }
        return null;
    }

    private static boolean isDoubleRangeType(IOpenClass type) {
        return DoubleRange.class == type.getInstanceClass();
    }

    private static boolean isIntRangeType(IOpenClass type) {
        return IntRange.class == type.getInstanceClass();
    }

    private static boolean isCharRangeType(IOpenClass type) {
        return CharRange.class == type.getInstanceClass();
    }

    private static boolean isStringRangeType(IOpenClass type) {
        return StringRange.class == type.getInstanceClass();
    }

    private static boolean isDateRangeType(IOpenClass type) {
        return DateRange.class == type.getInstanceClass();
    }

    private static boolean isCharType(IOpenClass type) {
        return ClassUtils.isAssignable((Class)type.getInstanceClass(), Character.class);
    }

    private static boolean isStringType(IOpenClass type) {
        return ClassUtils.isAssignable((Class)type.getInstanceClass(), CharSequence.class);
    }

    private static boolean isDateType(IOpenClass type) {
        return ClassUtils.isAssignable((Class)type.getInstanceClass(), Date.class);
    }

    public static IConditionEvaluator makeEvaluator(ICondition condition, IOpenClass conditionMethodType, IBindingContext bindingContext) {
        IParameterDeclaration[] params = condition.getParams();
        if (NullParameterDeclaration.isAnyNull((IParameterDeclaration[])params)) {
            return DefaultConditionEvaluator.INSTANCE;
        }
        if (params.length == 1) {
            ConditionCasts aggregateConditionCasts;
            IOpenClass conditionParamType = params[0].getType();
            ConditionCasts conditionCasts = ConditionHelper.findConditionCasts(conditionParamType, conditionMethodType, bindingContext);
            if (conditionCasts.isCastToInputTypeExists()) {
                return condition.getNumberOfEmptyRules(0) > 1 ? new EqualsIndexedEvaluatorV2(conditionCasts) : new EqualsIndexedEvaluator(conditionCasts);
            }
            IAggregateInfo aggregateInfo = conditionParamType.getAggregateInfo();
            if (aggregateInfo.isAggregate(conditionParamType) && ((aggregateConditionCasts = ConditionHelper.findConditionCasts(aggregateInfo.getComponentType(conditionParamType), conditionMethodType, bindingContext)).isCastToConditionTypeExists() || aggregateConditionCasts.isCastToInputTypeExists() && !conditionMethodType.isArray())) {
                return condition.getNumberOfEmptyRules(0) > 1 ? new ContainsInArrayIndexedEvaluatorV2(aggregateConditionCasts) : new ContainsInArrayIndexedEvaluator(aggregateConditionCasts);
            }
            IRangeAdaptor<? extends Object, ? extends Comparable<?>> rangeAdaptor = DecisionTableOptimizedAlgorithm.getRangeAdaptor(conditionMethodType, conditionParamType);
            if (rangeAdaptor != null) {
                return new CombinedRangeIndexEvaluator(rangeAdaptor, 1, ConditionHelper.getConditionCastsWithNoCasts());
            }
            if (conditionCasts.isCastToConditionTypeExists()) {
                return condition.getNumberOfEmptyRules(0) > 1 ? new EqualsIndexedEvaluatorV2(conditionCasts) : new EqualsIndexedEvaluator(conditionCasts);
            }
        } else if (params.length == 2) {
            BooleanTypeAdaptor booleanTypeAdaptor;
            Class clazz;
            IOpenClass conditionParamType0 = params[0].getType();
            IParameterDeclaration[] conditionParamType1 = params[1].getType();
            ConditionCasts conditionCasts = ConditionHelper.findConditionCasts(conditionParamType0, conditionMethodType, bindingContext);
            if (conditionCasts.atLeastOneExists() && Objects.equals(conditionParamType0, conditionParamType1) && ((clazz = conditionMethodType.getInstanceClass()) == Byte.TYPE || clazz == Short.TYPE || clazz == Integer.TYPE || clazz == Long.TYPE || clazz == Float.TYPE || clazz == Double.TYPE || ClassUtils.isAssignable((Class)clazz, Comparable.class))) {
                return new CombinedRangeIndexEvaluator(null, 2, conditionCasts);
            }
            IAggregateInfo aggregateInfo = conditionParamType1.getAggregateInfo();
            if (aggregateInfo.isAggregate((IOpenClass)conditionParamType1) && aggregateInfo.getComponentType((IOpenClass)conditionParamType1) == conditionMethodType && (booleanTypeAdaptor = BooleanAdaptorFactory.getAdaptor(conditionParamType0)) != null) {
                return new ContainsInOrNotInArrayIndexedEvaluator(booleanTypeAdaptor);
            }
        }
        if (JavaOpenClass.BOOLEAN.equals((Object)conditionMethodType) || JavaOpenClass.getOpenClass(Boolean.class).equals((Object)conditionMethodType)) {
            return DefaultConditionEvaluator.INSTANCE;
        }
        ArrayList<String> names = new ArrayList<String>();
        for (IParameterDeclaration parameterDeclaration : params) {
            String name = parameterDeclaration.getType().getName();
            names.add(name);
        }
        String message = String.format("Cannot build an evaluator for condition '%s' with parameters '%s' and method parameter '%s'.", condition.getName(), String.join((CharSequence)", ", names), conditionMethodType.getName());
        BindHelper.processError((String)message, (IOpenSourceCodeModule)condition.getUserDefinedExpressionSource(), (IBindingContext)bindingContext);
        return DefaultConditionEvaluator.INSTANCE;
    }

    private ConditionToEvaluatorHolder[] initEvaluators(IConditionEvaluator[] evaluators, DecisionTable table, IndexInfo info) {
        if (table.getNumberOfConditions() <= info.fromCondition || info.fromCondition > info.toCondition) {
            return ConditionToEvaluatorHolder.EMPTY_ARRAY;
        }
        ArrayList<ConditionToEvaluatorHolder> evalToConds = new ArrayList<ConditionToEvaluatorHolder>(evaluators.length);
        for (int j = info.fromCondition; j <= info.toCondition; ++j) {
            ContainsInArrayIndexedEvaluatorV2 containsInArrayIndexedEvaluatorV2;
            int maxArrayLength;
            IConditionEvaluator eval = evaluators[j];
            ICondition condition = table.getCondition(j);
            if (eval instanceof ContainsInArrayIndexedEvaluatorV2 && (maxArrayLength = (containsInArrayIndexedEvaluatorV2 = (ContainsInArrayIndexedEvaluatorV2)eval).getMaxArrayLength(condition, info.makeRuleIterator())) > 1) {
                eval = containsInArrayIndexedEvaluatorV2.toV1();
            }
            ConditionToEvaluatorHolder pair = new ConditionToEvaluatorHolder(condition, eval, info);
            evalToConds.add(pair);
        }
        Collections.sort(evalToConds);
        return evalToConds.toArray(ConditionToEvaluatorHolder.EMPTY_ARRAY);
    }

    private IRuleIndex buildIndex(IndexInfo info) {
        if (this.evaluators.length == 0) {
            return null;
        }
        ConditionToEvaluatorHolder firstPair = this.evaluators[0];
        if (!firstPair.isIndexed()) {
            return null;
        }
        IRuleIndex indexRoot = firstPair.makeIndex(info.makeRuleIterator());
        this.indexNodes(indexRoot, 1, info);
        return indexRoot;
    }

    private void indexNodes(IRuleIndex index, int condN, IndexInfo info) {
        if (index == null || condN >= this.evaluators.length) {
            return;
        }
        ConditionToEvaluatorHolder pair = this.evaluators[condN];
        if (!pair.isIndexed()) {
            return;
        }
        for (DecisionTableRuleNode decisionTableRuleNode : index.nodes()) {
            this.indexNode(decisionTableRuleNode, condN, info);
        }
        this.indexNode(index.getEmptyOrFormulaNodes(), condN, info);
    }

    private void indexNode(DecisionTableRuleNode node, int condN, IndexInfo info) {
        ConditionToEvaluatorHolder pair = this.evaluators[condN];
        IRuleIndex nodeIndex = pair.makeIndex(node.getRulesIterator());
        node.setNextIndex(nodeIndex);
        this.indexNodes(nodeIndex, condN + 1, info);
    }

    private Object evaluateTestValue(ICondition condition, Object target, Object[] dtparams, IRuntimeEnv env) {
        return condition.getEvaluator().invoke(target, dtparams, env);
    }

    @Override
    public void cleanParamValuesForIndexedConditions() {
        if (this.dependencies != null) {
            for (ConditionToEvaluatorHolder eval : this.evaluators) {
                if (!eval.isIndexed() || this.isDependencyOnConditionExists(eval.getCondition())) continue;
                eval.getCondition().clearParamValues();
            }
            this.dependencies = null;
        }
    }

    private boolean isDependencyOnConditionExists(ICondition condition) {
        for (IOpenField field : this.dependencies.getFieldsMap().values()) {
            if (field instanceof ConditionOrActionParameterField && ((ConditionOrActionParameterField)field).getConditionOrAction() == condition) {
                return true;
            }
            if (!(field instanceof ConditionOrActionDirectParameterField) || ((ConditionOrActionDirectParameterField)field).getConditionOrAction() != condition) continue;
            return true;
        }
        return false;
    }

    @Override
    public IIntIterator checkedRules(Object target, Object[] params, IRuntimeEnv env) {
        int conditionNumber;
        IIntIterator iterator = null;
        if (this.indexRoot == null) {
            iterator = this.info.makeRuleIterator();
        } else {
            IRuleIndex index = this.indexRoot;
            DecisionTableRuleNode node = null;
            for (conditionNumber = 0; conditionNumber < this.evaluators.length; ++conditionNumber) {
                ICondition condition = this.evaluators[conditionNumber].getCondition();
                index = (IRuleIndex)Tracer.wrap((Object)this, (Object)index, (Object)condition);
                Object testValue = this.evaluateTestValue(condition, target, params, env);
                node = index.findNode(testValue, node);
                Tracer.put((Object)this, (String)"index", (Object)condition, (Object)node, (boolean)true);
                if (!node.hasIndex()) {
                    iterator = node.getRulesIterator();
                    ++conditionNumber;
                    break;
                }
                index = node.getNextIndex();
            }
        }
        while (conditionNumber < this.evaluators.length) {
            ConditionToEvaluatorHolder pair = this.evaluators[conditionNumber];
            ICondition condition = pair.getCondition();
            IConditionEvaluator evaluator = pair.getEvaluator();
            IIntSelector sel = evaluator.getSelector(condition, target, params, env);
            sel = (IIntSelector)Tracer.wrap((Object)this, (Object)sel, (Object)condition);
            iterator = iterator.select(sel);
            ++conditionNumber;
        }
        return iterator;
    }

    private static class ConditionToEvaluatorHolder
    implements Comparable<ConditionToEvaluatorHolder> {
        static final ConditionToEvaluatorHolder[] EMPTY_ARRAY = new ConditionToEvaluatorHolder[0];
        private final IndexInfo localInfo;
        private int uniqueKeysSize = -1;
        private final ICondition condition;
        private IConditionEvaluator evaluator;

        ConditionToEvaluatorHolder(ICondition condition, IConditionEvaluator evaluator, IndexInfo localInfo) {
            this.condition = condition;
            this.evaluator = evaluator;
            this.localInfo = localInfo;
        }

        public ICondition getCondition() {
            return this.condition;
        }

        public IConditionEvaluator getEvaluator() {
            return this.evaluator;
        }

        public void setEvaluator(IConditionEvaluator evaluator) {
            this.evaluator = evaluator;
        }

        public boolean isIndexed() {
            return this.evaluator.isIndexed() && !this.condition.hasFormulas();
        }

        public IRuleIndex makeIndex(IIntIterator it) {
            return this.evaluator.makeIndex(this.condition, it);
        }

        @Override
        public int compareTo(ConditionToEvaluatorHolder o) {
            if (!this.isIndexed() && !o.isIndexed()) {
                return 0;
            }
            if (this.isIndexed() && !o.isIndexed()) {
                return -1;
            }
            if (!this.isIndexed() && o.isIndexed()) {
                return 1;
            }
            if (this.isEqualsIndex() && o.isEqualsIndex()) {
                return Integer.compare(this.getUniqueKeysSize(), o.getUniqueKeysSize());
            }
            return Integer.compare(this.evaluator.getPriority(), o.evaluator.getPriority());
        }

        private boolean isEqualsIndex() {
            return this.evaluator instanceof EqualsIndexedEvaluator || this.evaluator instanceof ContainsInArrayIndexedEvaluator;
        }

        private int getUniqueKeysSize() {
            if (this.uniqueKeysSize < 0) {
                this.uniqueKeysSize = this.evaluator.countUniqueKeys(this.condition, this.localInfo.makeRuleIterator());
            }
            return this.uniqueKeysSize;
        }
    }
}

