/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.index;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.openl.rules.dt.DecisionTableRuleNode;
import org.openl.rules.dt.DecisionTableRuleNodeBuilder;
import org.openl.rules.dt.IDecisionTableRuleNodeV2;
import org.openl.rules.dt.RangeIndexDecisionTableRuleNode;
import org.openl.rules.dt.algorithm.evaluator.ARangeIndexEvaluator;
import org.openl.rules.dt.index.IRuleIndex;
import org.openl.rules.dt.type.IRangeAdaptor;

public class RangeAscIndex
implements IRuleIndex {
    protected final List<ARangeIndexEvaluator.IndexNode> index;
    private final DecisionTableRuleNode emptyNodeStub = new DecisionTableRuleNodeBuilder().makeNode();
    private final DecisionTableRuleNode nextNode;
    private final IRangeAdaptor<ARangeIndexEvaluator.IndexNode, ?> adaptor;
    private final int[] emptyRules;
    private final int rulesTotalSize;

    public RangeAscIndex(DecisionTableRuleNode nextNode, List<ARangeIndexEvaluator.IndexNode> index, IRangeAdaptor<ARangeIndexEvaluator.IndexNode, ?> adaptor, int[] emptyRules) {
        this.index = Collections.unmodifiableList(index);
        this.adaptor = adaptor;
        this.nextNode = nextNode;
        this.emptyRules = emptyRules;
        this.rulesTotalSize = nextNode.getRules().length;
    }

    private Pair<Integer, Integer> findIndexRange(Object value) {
        if (value == null || this.index.isEmpty()) {
            return null;
        }
        value = this.adaptor.adaptValueType(value);
        int idx = Collections.binarySearch(this.index, (ARangeIndexEvaluator.IndexNode)value);
        return this.retrieveIndexRange(idx);
    }

    protected Pair<Integer, Integer> retrieveIndexRange(int idx) {
        if (idx >= 0) {
            return Pair.of((Object)0, (Object)(idx + 1));
        }
        int insertionPoint = -(idx + 1);
        if (insertionPoint <= this.index.size() && insertionPoint > 0) {
            return Pair.of((Object)0, (Object)insertionPoint);
        }
        return null;
    }

    @Override
    public DecisionTableRuleNode findNode(Object value, DecisionTableRuleNode prevResult) {
        return new RangeIndexDecisionTableRuleNode(this.findRules(value, prevResult), this.nextNode.getNextIndex());
    }

    BitSet findRules(Object value, DecisionTableRuleNode prevResult) {
        if (!(prevResult instanceof IDecisionTableRuleNodeV2)) {
            Pair<Integer, Integer> range = this.findIndexRange(value);
            return this.collectAllRules(range);
        }
        return this.getResultAndIntersect(value, (IDecisionTableRuleNodeV2)((Object)prevResult));
    }

    private BitSet collectAllRules(Pair<Integer, Integer> range) {
        BitSet bits = new BitSet();
        for (int ruleN : this.emptyRules) {
            bits.set(ruleN);
        }
        if (range != null) {
            for (int i = ((Integer)range.getLeft()).intValue(); i < (Integer)range.getRight(); ++i) {
                for (int ruleN : this.index.get(i).getRules()) {
                    bits.set(ruleN);
                }
            }
        }
        return bits;
    }

    private BitSet getResultAndIntersect(Object value, IDecisionTableRuleNodeV2 prevResult) {
        BitSet prevRes = prevResult.getRuleSet();
        if (prevRes.isEmpty()) {
            return prevRes;
        }
        Pair<Integer, Integer> range = this.findIndexRange(value);
        BitSet result = new BitSet();
        for (int ruleN : this.emptyRules) {
            if (!prevRes.get(ruleN)) continue;
            result.set(ruleN);
        }
        if (range != null) {
            for (int i = ((Integer)range.getLeft()).intValue(); i < (Integer)range.getRight(); ++i) {
                for (int ruleN : this.index.get(i).getRules()) {
                    if (!prevRes.get(ruleN)) continue;
                    result.set(ruleN);
                }
            }
        }
        return result;
    }

    @Override
    public Iterable<? extends DecisionTableRuleNode> nodes() {
        return Collections.singletonList(this.nextNode);
    }

    @Override
    public DecisionTableRuleNode getEmptyOrFormulaNodes() {
        return this.emptyNodeStub;
    }

    @Override
    public int[] collectRules() {
        int[] result = new int[this.rulesTotalSize];
        int k = 0;
        for (ARangeIndexEvaluator.IndexNode indexNode : this.index) {
            for (int ruleN : indexNode.getRules()) {
                result[k++] = ruleN;
            }
        }
        for (Object ruleN : (Object)this.emptyRules) {
            result[k++] = (int)ruleN;
        }
        Arrays.sort(result);
        return result;
    }
}

