/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.storage;

import org.openl.binding.IBoundNode;
import org.openl.rules.dt.Expr;
import org.openl.rules.dt.storage.IStorage;
import org.openl.rules.dt.storage.StorageInfo;
import org.openl.rules.dt.storage.StorageUtils;
import org.openl.types.impl.CompositeMethod;

public class ObjectStorage
implements IStorage<Object> {
    private final Object[] values;
    private final Expr[] exprValues;
    private StorageInfo info;

    ObjectStorage(int size) {
        this.values = new Object[size];
        this.exprValues = new Expr[size];
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    public Object getValue(int index) {
        return this.values[index];
    }

    @Override
    public boolean isSpace(int index) {
        return this.values[index] == null || this.values[index] == IStorage.StorageType.SPACE;
    }

    @Override
    public boolean isFormula(int index) {
        return StorageUtils.isFormula(this.values[index]);
    }

    @Override
    public boolean isElse(int index) {
        return this.values[index] == IStorage.StorageType.ELSE;
    }

    @Override
    public void setValue(int index, Object o) {
        this.values[index] = o;
    }

    @Override
    public void setSpace(int index) {
        this.values[index] = null;
    }

    @Override
    public void setElse(int index) {
        this.values[index] = IStorage.StorageType.ELSE;
    }

    @Override
    public void setFormula(int index, Object formula) {
        this.values[index] = formula;
        if (formula instanceof CompositeMethod) {
            this.exprValues[index] = new Expr((IBoundNode)((CompositeMethod)formula).getMethodBodyBoundNode());
        }
    }

    @Override
    public Expr getExprValue(int index) {
        return this.exprValues[index];
    }

    @Override
    public StorageInfo getInfo() {
        return this.info;
    }

    public void setInfo(StorageInfo info) {
        this.info = info;
    }

    public Object[] getValues() {
        return this.values;
    }
}

