/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.helpers;

import java.beans.Transient;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import org.openl.rules.helpers.ARangeParser;
import org.openl.rules.range.Range;
import org.openl.rules.range.RangeParser;

public class DateRange
extends Range<Date> {
    private static final int TO_DATE_RANGE_CAST_DISTANCE = 38;
    private static final DateTimeFormatter dateTimeParser = DateTimeFormatter.ofPattern("M/d/yyyy[ H:m:s]");
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("MM/dd/yyyy[ HH:mm:ss]");
    private final long lowerBound;
    private final long upperBound;
    private final Range.Type type;

    public DateRange(Date bound) {
        this.lowerBound = bound.getTime();
        this.upperBound = bound.getTime();
        this.type = Range.Type.DEGENERATE;
    }

    public DateRange(Date lowerBound, Date upperBound) {
        this.lowerBound = lowerBound.getTime();
        this.upperBound = upperBound.getTime();
        this.type = Range.Type.CLOSED;
        this.validate();
    }

    DateRange(Date lowerBound, Date upperBound, ARangeParser.ParseStruct.BoundType lowerBoundType, ARangeParser.ParseStruct.BoundType upperBoundType) {
        assert (lowerBound != null);
        assert (upperBound != null);
        long localLowerBound = lowerBound.getTime();
        long localUpperBound = upperBound.getTime();
        this.type = Long.MAX_VALUE == localUpperBound ? (lowerBoundType == ARangeParser.ParseStruct.BoundType.EXCLUDING ? Range.Type.LEFT_OPEN : Range.Type.LEFT_CLOSED) : (Long.MIN_VALUE == localLowerBound ? (upperBoundType == ARangeParser.ParseStruct.BoundType.EXCLUDING ? Range.Type.RIGHT_OPEN : Range.Type.RIGHT_CLOSED) : (upperBoundType == ARangeParser.ParseStruct.BoundType.EXCLUDING ? (lowerBoundType == ARangeParser.ParseStruct.BoundType.EXCLUDING ? Range.Type.OPEN : Range.Type.CLOSED_OPEN) : (lowerBoundType == ARangeParser.ParseStruct.BoundType.EXCLUDING ? Range.Type.OPEN_CLOSED : Range.Type.CLOSED)));
        this.lowerBound = localLowerBound;
        this.upperBound = localUpperBound;
        this.validate();
    }

    public DateRange(String source) {
        RangeParser parser = this.parse(source);
        if (parser == null) {
            this.type = Range.Type.DEGENERATE;
            this.upperBound = this.lowerBound = DateRange.convertToTime(source.trim());
        } else {
            this.type = parser.getType();
            String left = parser.getLeft();
            String right = parser.getRight();
            this.lowerBound = left == null ? Long.MIN_VALUE : DateRange.convertToTime(left);
            this.upperBound = right == null ? Long.MAX_VALUE : DateRange.convertToTime(right);
            this.validate();
        }
    }

    public Long getLowerBound() {
        return this.lowerBound;
    }

    public Long getUpperBound() {
        return this.upperBound;
    }

    @Override
    public boolean contains(Date value) {
        return super.contains(value);
    }

    @Override
    @Transient
    public Range.Type getType() {
        return this.type;
    }

    @Override
    protected Date getLeft() {
        return new Date(this.lowerBound);
    }

    @Override
    protected Date getRight() {
        return new Date(this.upperBound);
    }

    @Override
    protected int compare(Date left, Date right) {
        return Long.compare(left.getTime(), right.getTime());
    }

    @Override
    protected void format(StringBuilder sb, Date value) {
        LocalDateTime time = Instant.ofEpochMilli(value.getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime();
        sb.append(dateTimeFormatter.format(time));
    }

    public static DateRange autocast(Date x, DateRange y) {
        return new DateRange(x);
    }

    public static int distance(Date x, DateRange y) {
        return 38;
    }

    public static DateRange autocast(Calendar x, DateRange y) {
        return new DateRange(x.getTime());
    }

    public static int distance(Calendar x, DateRange y) {
        return 38;
    }

    public static DateRange autocast(long x, DateRange y) {
        return new DateRange(new Date(x));
    }

    public static int distance(long x, DateRange y) {
        return 38;
    }

    private static long convertToTime(String text) {
        TemporalAccessor res = dateTimeParser.parseBest(text, LocalDateTime::from, LocalDate::from);
        LocalDateTime localDateTime = res instanceof LocalDate ? ((LocalDate)res).atStartOfDay() : (LocalDateTime)res;
        return localDateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }
}

