/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.openl.ICompileContext;
import org.openl.IOpenBinder;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.IBoundCode;
import org.openl.binding.IBoundNode;
import org.openl.binding.ICastFactory;
import org.openl.binding.IMemberBoundNode;
import org.openl.binding.INameSpacedMethodFactory;
import org.openl.binding.INameSpacedTypeFactory;
import org.openl.binding.INameSpacedVarFactory;
import org.openl.binding.INodeBinderFactory;
import org.openl.binding.MethodUtil;
import org.openl.binding.impl.BindingContext;
import org.openl.binding.impl.BindingContextDelegator;
import org.openl.binding.impl.BoundCode;
import org.openl.binding.impl.ErrorBoundNode;
import org.openl.binding.impl.module.ModuleNode;
import org.openl.binding.impl.module.ModuleOpenClass;
import org.openl.conf.IOpenLBuilder;
import org.openl.conf.IUserContext;
import org.openl.conf.OpenLConfigurationException;
import org.openl.dependency.CompiledDependency;
import org.openl.engine.OpenLManager;
import org.openl.engine.OpenLSystemProperties;
import org.openl.exception.OpenlNotCheckedException;
import org.openl.rules.binding.RecursiveOpenMethodPreBinder;
import org.openl.rules.binding.RulesModuleBindingContext;
import org.openl.rules.calc.CustomSpreadsheetResultOpenClass;
import org.openl.rules.calc.SpreadsheetNodeBinder;
import org.openl.rules.calc.SpreadsheetResult;
import org.openl.rules.cmatch.ColumnMatchNodeBinder;
import org.openl.rules.constants.ConstantsTableBinder;
import org.openl.rules.data.DataBase;
import org.openl.rules.data.DataNodeBinder;
import org.openl.rules.data.IDataBase;
import org.openl.rules.datatype.binding.DatatypeNodeBinder;
import org.openl.rules.datatype.binding.DatatypeTableBoundNode;
import org.openl.rules.dt.ActionsTableBinder;
import org.openl.rules.dt.ConditionsTableBinder;
import org.openl.rules.dt.DecisionTableNodeBinder;
import org.openl.rules.dt.ReturnsTableBinder;
import org.openl.rules.fuzzy.OpenLFuzzyUtils;
import org.openl.rules.lang.xls.OpenLBuilderImpl;
import org.openl.rules.lang.xls.XlsHelper;
import org.openl.rules.lang.xls.XlsModuleOpenClassHolder;
import org.openl.rules.lang.xls.XlsNodeTypes;
import org.openl.rules.lang.xls.binding.AExecutableNodeBinder;
import org.openl.rules.lang.xls.binding.AXlsTableBinder;
import org.openl.rules.lang.xls.binding.XlsMetaInfo;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.lang.xls.syntax.OpenlSyntaxNode;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.syntax.XlsModuleSyntaxNode;
import org.openl.rules.method.table.MethodTableNodeBinder;
import org.openl.rules.property.PropertyTableBinder;
import org.openl.rules.table.properties.PropertiesLoader;
import org.openl.rules.tbasic.AlgorithmNodeBinder;
import org.openl.rules.testmethod.TestMethodNodeBinder;
import org.openl.rules.validation.properties.dimentional.DispatcherTablesBuilder;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.code.IParsedCode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.types.IMemberMetaInfo;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMember;
import org.openl.types.IOpenMethod;
import org.openl.types.impl.OpenMethodHeader;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.RuntimeExceptionWrapper;
import org.openl.util.StringUtils;
import org.openl.validation.ValidationManager;
import org.openl.vm.IRuntimeEnv;

public class XlsBinder
implements IOpenBinder {
    private final IUserContext userContext;
    private final ICompileContext compileContext;

    public Map<String, AXlsTableBinder> getBinderFactories() {
        return BinderFactoryHolder.INSTANCE;
    }

    public XlsBinder(ICompileContext compileContext, IUserContext userContext) {
        this.userContext = userContext;
        this.compileContext = compileContext;
    }

    public ICastFactory getCastFactory() {
        return null;
    }

    public INameSpacedMethodFactory getMethodFactory() {
        return null;
    }

    public INodeBinderFactory getNodeBinderFactory() {
        return null;
    }

    public INameSpacedTypeFactory getTypeFactory() {
        return null;
    }

    public INameSpacedVarFactory getVarFactory() {
        return null;
    }

    public IBindingContext makeBindingContext() {
        return new BindingContext(null, (IOpenClass)JavaOpenClass.VOID, null);
    }

    public IBoundCode bind(IParsedCode parsedCode) {
        return this.bind(parsedCode, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBoundCode bind(IParsedCode parsedCode, IBindingContext bindingContext) {
        Set compiledDependencies;
        OpenL openl;
        XlsModuleSyntaxNode moduleNode = (XlsModuleSyntaxNode)parsedCode.getTopNode();
        ArrayList<SyntaxNodeException> exceptions = new ArrayList<SyntaxNodeException>();
        try {
            openl = this.makeOpenL(moduleNode, exceptions);
        }
        catch (OpenLConfigurationException ex) {
            OpenlSyntaxNode syntaxNode = moduleNode.getOpenlNode();
            SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((String)"Error Creating OpenL", (Throwable)ex, (ISyntaxNode)syntaxNode);
            ErrorBoundNode boundNode = new ErrorBoundNode((ISyntaxNode)syntaxNode);
            return new BoundCode(parsedCode, (IBoundNode)boundNode, new SyntaxNodeException[]{error}, null);
        }
        if (bindingContext == null) {
            IOpenBinder openlBinder = openl.getBinder();
            bindingContext = openlBinder.makeBindingContext();
        } else {
            BindingContext bc;
            IBindingContext bc1 = bindingContext;
            while (bc1 instanceof BindingContextDelegator) {
                bc1 = ((BindingContextDelegator)bc1).getDelegate();
            }
            if (bc1 instanceof BindingContext && ((bc = (BindingContext)bc1).getOpenL() == null || bc.getBinder() == null)) {
                bc.setOpenl(openl);
                bc.setBinder(openl.getBinder());
            }
        }
        exceptions.forEach(arg_0 -> ((IBindingContext)bindingContext).addError(arg_0));
        if (parsedCode.getExternalParams() != null) {
            bindingContext.setExternalParams(parsedCode.getExternalParams());
        }
        compiledDependencies = (compiledDependencies = parsedCode.getCompiledDependencies()).isEmpty() ? null : compiledDependencies;
        XlsModuleOpenClass moduleOpenClass = this.createModuleOpenClass(moduleNode, openl, this.getModuleDatabase(), compiledDependencies, this.selectNodes(moduleNode, this.getSelector(XlsNodeTypes.XLS_DATATYPE)).length > 0, bindingContext);
        XlsModuleOpenClass oldXlsModuleOpenClass = XlsModuleOpenClassHolder.getInstance().getXlsModuleOpenClass();
        try {
            XlsModuleOpenClassHolder.getInstance().setXlsModuleOpenClass(moduleOpenClass);
            RulesModuleBindingContext rulesModuleBindingContext = moduleOpenClass.getRulesModuleBindingContext();
            IBoundNode topNode = this.processBinding(moduleNode, openl, rulesModuleBindingContext, moduleOpenClass);
            ValidationManager.validate((ICompileContext)this.compileContext, (IOpenClass)topNode.getType(), (IBindingContext)bindingContext);
            BoundCode boundCode = new BoundCode(parsedCode, topNode, bindingContext.getErrors(), bindingContext.getMessages());
            return boundCode;
        }
        finally {
            XlsModuleOpenClassHolder.getInstance().setXlsModuleOpenClass(oldXlsModuleOpenClass);
            if (ValidationManager.isValidationEnabled() && bindingContext.isExecutionMode()) {
                moduleOpenClass.clearForExecutionMode();
            }
        }
    }

    protected IDataBase getModuleDatabase() {
        return new DataBase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IBoundNode processBinding(XlsModuleSyntaxNode moduleNode, OpenL openl, RulesModuleBindingContext rulesModuleBindingContext, XlsModuleOpenClass moduleOpenClass) {
        try {
            Predicate<ISyntaxNode> propertiesSelector = this.getSelector(XlsNodeTypes.XLS_PROPERTIES);
            Predicate<ISyntaxNode> constantsSelector = this.getSelector(XlsNodeTypes.XLS_CONSTANTS);
            Predicate<ISyntaxNode> dataTypeSelector = this.getSelector(XlsNodeTypes.XLS_DATATYPE);
            Predicate<ISyntaxNode> conditionsSelector = this.getSelector(XlsNodeTypes.XLS_CONDITIONS);
            Predicate<ISyntaxNode> actionsSelector = this.getSelector(XlsNodeTypes.XLS_ACTIONS);
            Predicate<ISyntaxNode> returnsSelector = this.getSelector(XlsNodeTypes.XLS_RETURNS);
            Predicate<ISyntaxNode> dtDefinitionSelector = conditionsSelector.or(actionsSelector).or(returnsSelector);
            Predicate<ISyntaxNode> notPropertiesAndNotDatatypeAndNotConstantsSelector = propertiesSelector.negate().and(dataTypeSelector.negate()).and(constantsSelector.negate());
            Predicate<ISyntaxNode> spreadsheetSelector = this.getSelector(XlsNodeTypes.XLS_SPREADSHEET);
            Predicate<ISyntaxNode> dtSelector = this.getSelector(XlsNodeTypes.XLS_DT);
            Predicate<ISyntaxNode> testMethodSelector = this.getSelector(XlsNodeTypes.XLS_TEST_METHOD);
            Predicate<ISyntaxNode> runMethodSelector = this.getSelector(XlsNodeTypes.XLS_RUN_METHOD);
            Predicate<ISyntaxNode> commonTablesSelector = notPropertiesAndNotDatatypeAndNotConstantsSelector.and(spreadsheetSelector.negate().and(testMethodSelector.negate().and(runMethodSelector.negate().and(dtSelector.negate().and(dtDefinitionSelector.negate())))));
            TableSyntaxNode[] propertiesNodes = this.selectNodes(moduleNode, propertiesSelector);
            this.bindInternal(moduleNode, moduleOpenClass, propertiesNodes, Collections.emptyMap(), openl, rulesModuleBindingContext);
            this.bindPropertiesForAllTables(moduleNode, moduleOpenClass, openl, rulesModuleBindingContext);
            TableSyntaxNode[] constantNodes = this.selectNodes(moduleNode, constantsSelector);
            TableSyntaxNode[] datatypeNodes = this.selectNodes(moduleNode, dataTypeSelector);
            TableSyntaxNode[] dtHeaderDefinitionsNodes = this.selectNodes(moduleNode, dtDefinitionSelector);
            TableSyntaxNode[] commonTables = this.selectNodes(moduleNode, commonTablesSelector);
            TableSyntaxNode[] spreadsheets = this.selectNodes(moduleNode, spreadsheetSelector);
            TableSyntaxNode[] dts = this.selectNodes(moduleNode, dtSelector);
            TableSyntaxNode[] commonAndSpreadsheetTables = (TableSyntaxNode[])ArrayUtils.addAll((Object[])((TableSyntaxNode[])ArrayUtils.addAll((Object[])((TableSyntaxNode[])ArrayUtils.addAll((Object[])dtHeaderDefinitionsNodes, (Object[])dts)), (Object[])spreadsheets)), (Object[])commonTables);
            Map<TableSyntaxNode, CustomSpreadsheetResultOpenClass> customSpreadsheetResultOpenClassMap = this.registerNewCustomSpreadsheetResultTypes(commonAndSpreadsheetTables, rulesModuleBindingContext);
            this.bindInternal(moduleNode, moduleOpenClass, constantNodes, customSpreadsheetResultOpenClassMap, openl, rulesModuleBindingContext);
            this.bindInternal(moduleNode, moduleOpenClass, datatypeNodes, customSpreadsheetResultOpenClassMap, openl, rulesModuleBindingContext);
            this.bindInternal(moduleNode, moduleOpenClass, commonAndSpreadsheetTables, customSpreadsheetResultOpenClassMap, openl, rulesModuleBindingContext);
            TableSyntaxNode[] runTables = this.selectNodes(moduleNode, runMethodSelector);
            this.bindInternal(moduleNode, moduleOpenClass, runTables, customSpreadsheetResultOpenClassMap, openl, rulesModuleBindingContext);
            TableSyntaxNode[] testTables = this.selectNodes(moduleNode, testMethodSelector);
            IBoundNode topNode = this.bindInternal(moduleNode, moduleOpenClass, testTables, customSpreadsheetResultOpenClassMap, openl, rulesModuleBindingContext);
            if (OpenLSystemProperties.isCustomSpreadsheetTypesSupported(rulesModuleBindingContext.getExternalParams())) {
                for (IOpenClass type : moduleOpenClass.getTypes()) {
                    if (!(type instanceof CustomSpreadsheetResultOpenClass)) continue;
                    type.getFields().forEach(IOpenMember::getType);
                }
                moduleOpenClass.getSpreadsheetResultOpenClassWithResolvedFieldTypes().toCustomSpreadsheetResultOpenClass().getFields().forEach(IOpenMember::getType);
                int combinedSpreadsheetResultOpenClassesSize = 0;
                while (combinedSpreadsheetResultOpenClassesSize != moduleOpenClass.getCombinedSpreadsheetResultOpenClasses().size()) {
                    combinedSpreadsheetResultOpenClassesSize = moduleOpenClass.getCombinedSpreadsheetResultOpenClasses().size();
                    moduleOpenClass.getCombinedSpreadsheetResultOpenClasses().forEach(e -> e.getFields().forEach(IOpenMember::getType));
                }
            }
            if (moduleOpenClass.isUseDecisionTableDispatcher()) {
                DispatcherTablesBuilder dispatcherTablesBuilder = new DispatcherTablesBuilder((XlsModuleOpenClass)topNode.getType());
                dispatcherTablesBuilder.build();
            }
            ((XlsModuleOpenClass)topNode.getType()).completeOpenClassBuilding();
            IBoundNode iBoundNode = topNode;
            return iBoundNode;
        }
        finally {
            OpenLFuzzyUtils.clearCaches();
        }
    }

    private Predicate<ISyntaxNode> getSelector(XlsNodeTypes selectorValue) {
        return syntaxNode -> selectorValue.toString().equals(syntaxNode.getType());
    }

    protected XlsModuleOpenClass createModuleOpenClass(XlsModuleSyntaxNode moduleNode, OpenL openl, IDataBase dbase, Set<CompiledDependency> moduleDependencies, boolean appliedChangesToClasspath, IBindingContext bindingContext) {
        return new XlsModuleOpenClass(XlsHelper.getModuleName(moduleNode), new XlsMetaInfo(moduleNode), openl, dbase, moduleDependencies, Thread.currentThread().getContextClassLoader(), appliedChangesToClasspath, bindingContext);
    }

    private void bindPropertiesForAllTables(XlsModuleSyntaxNode moduleNode, XlsModuleOpenClass module, OpenL openl, RulesModuleBindingContext bindingContext) {
        Predicate<ISyntaxNode> propertiesSelector = this.getSelector(XlsNodeTypes.XLS_PROPERTIES);
        Predicate<ISyntaxNode> otherNodesSelector = this.getSelector(XlsNodeTypes.XLS_OTHER);
        Predicate<ISyntaxNode> notPropertiesAndNotOtherSelector = propertiesSelector.negate().and(otherNodesSelector.negate());
        TableSyntaxNode[] tableSyntaxNodes = this.selectNodes(moduleNode, notPropertiesAndNotOtherSelector);
        PropertiesLoader propLoader = new PropertiesLoader(openl, bindingContext, module);
        for (TableSyntaxNode tsn : tableSyntaxNodes) {
            try {
                propLoader.loadProperties(tsn);
            }
            catch (SyntaxNodeException error) {
                this.processError(error, bindingContext);
            }
            catch (Exception | LinkageError t) {
                SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((Throwable)t, (ISyntaxNode)tsn);
                this.processError(error, bindingContext);
            }
        }
    }

    private void addImports(XlsModuleSyntaxNode moduleNode, OpenLBuilderImpl builder, Collection<String> imports, List<SyntaxNodeException> exceptions) {
        LinkedHashSet<String> packageNames = new LinkedHashSet<String>();
        LinkedHashSet<String> classNames = new LinkedHashSet<String>();
        LinkedHashSet<String> libraries = new LinkedHashSet<String>();
        for (String singleImport : imports) {
            if (singleImport.endsWith(".*")) {
                String libraryClassName = singleImport.substring(0, singleImport.length() - 2);
                try {
                    URL resource = this.userContext.getUserClassLoader().getResource(libraryClassName.replaceAll("\\.", "/") + ".groovy");
                    if (resource == null) {
                        this.userContext.getUserClassLoader().loadClass(libraryClassName);
                    }
                    libraries.add(libraryClassName);
                }
                catch (Exception e) {
                    packageNames.add(libraryClassName);
                }
                catch (LinkageError e) {
                    exceptions.add(SyntaxNodeExceptionUtils.createError((Throwable)e, (ISyntaxNode)moduleNode.getOpenlNode()));
                }
                continue;
            }
            try {
                this.userContext.getUserClassLoader().loadClass(singleImport);
                classNames.add(singleImport);
            }
            catch (Exception e) {
                packageNames.add(singleImport);
            }
            catch (LinkageError e) {
                exceptions.add(SyntaxNodeExceptionUtils.createError((Throwable)e, (ISyntaxNode)moduleNode.getOpenlNode()));
            }
        }
        builder.setPackageImports(packageNames.toArray(StringUtils.EMPTY_STRING_ARRAY));
        builder.setClassImports(classNames.toArray(StringUtils.EMPTY_STRING_ARRAY));
        builder.setLibraries(libraries.toArray(StringUtils.EMPTY_STRING_ARRAY));
    }

    private OpenL makeOpenL(XlsModuleSyntaxNode moduleNode, List<SyntaxNodeException> exceptions) {
        String openlName = this.getOpenLName(moduleNode.getOpenlNode());
        Collection<String> imports = moduleNode.getImports();
        if (imports == null) {
            return OpenL.getInstance((String)openlName, (IUserContext)this.userContext);
        }
        OpenLBuilderImpl builder = new OpenLBuilderImpl();
        builder.setExtendsCategory(openlName);
        String category = openlName + "::" + moduleNode.getModule().getUri();
        builder.setCategory(category);
        this.addImports(moduleNode, builder, imports, exceptions);
        builder.setContexts(null, this.userContext);
        return OpenL.getInstance((String)category, (IUserContext)this.userContext, (IOpenLBuilder)builder);
    }

    private IMemberBoundNode preBindXlsNode(ISyntaxNode syntaxNode, OpenL openl, RulesModuleBindingContext bindingContext, XlsModuleOpenClass module) throws Exception {
        String tableSyntaxNodeType = syntaxNode.getType();
        AXlsTableBinder binder = this.findBinder(tableSyntaxNodeType);
        if (binder == null) {
            return null;
        }
        TableSyntaxNode tableSyntaxNode = (TableSyntaxNode)syntaxNode;
        return binder.preBind(tableSyntaxNode, openl, bindingContext, module);
    }

    protected AXlsTableBinder findBinder(String tableSyntaxNodeType) {
        return this.getBinderFactories().get(tableSyntaxNodeType);
    }

    protected String getDefaultOpenLName() {
        return "org.openl.rules.java";
    }

    private String getOpenLName(OpenlSyntaxNode osn) {
        return osn == null ? this.getDefaultOpenLName() : osn.getOpenlName();
    }

    private TableSyntaxNode[] selectNodes(XlsModuleSyntaxNode moduleSyntaxNode, Predicate<ISyntaxNode> childSelector) {
        TableSyntaxNode[] xlsTableSyntaxNodes = moduleSyntaxNode.getXlsTableSyntaxNodes();
        return Arrays.stream(xlsTableSyntaxNodes).filter(childSelector).collect(Collectors.toList()).toArray(TableSyntaxNode.EMPTY_ARRAY);
    }

    private boolean isExecutableTableSyntaxNode(TableSyntaxNode tableSyntaxNode) {
        return XlsNodeTypes.XLS_DT.equals((Object)tableSyntaxNode.getNodeType()) || XlsNodeTypes.XLS_TBASIC.equals((Object)tableSyntaxNode.getNodeType()) || XlsNodeTypes.XLS_METHOD.equals((Object)tableSyntaxNode.getNodeType()) || XlsNodeTypes.XLS_COLUMN_MATCH.equals((Object)tableSyntaxNode.getNodeType()) || XlsNodeTypes.XLS_SPREADSHEET.equals((Object)tableSyntaxNode.getNodeType());
    }

    private static String getSprResTypeNameIfCustomSpreadsheetResultTableSyntaxNode(TableSyntaxNode tableSyntaxNode) {
        if (XlsNodeTypes.XLS_SPREADSHEET.equals((Object)tableSyntaxNode.getNodeType()) || XlsNodeTypes.XLS_DT.equals((Object)tableSyntaxNode.getNodeType())) {
            String code = tableSyntaxNode.getHeader().getHeaderToken().getModule().getCode();
            int x = (code = code.replaceAll("\\s+", " ")).indexOf("(");
            if (x < 1) {
                return null;
            }
            String x1 = code.substring(0, x).trim();
            int y = x1.lastIndexOf(" ");
            if (y < 0 || y == x1.length() - 1) {
                return null;
            }
            String tableName = x1.substring(y + 1).trim();
            if (x1.contains("`")) {
                return null;
            }
            x1 = x1.substring(0, y).trim();
            if (XlsNodeTypes.XLS_SPREADSHEET.equals((Object)tableSyntaxNode.getNodeType()) && (x1.endsWith("[") || x1.endsWith("]"))) {
                return null;
            }
            while (x1.length() > 0 && x1.charAt(x1.length() - 1) == ' ' || x1.charAt(x1.length() - 1) == '[' || x1.charAt(x1.length() - 1) == ']') {
                x1 = x1.substring(0, x1.length() - 1);
            }
            int z = x1.lastIndexOf(" ");
            if (z < 0 || z == x1.length() - 1) {
                return null;
            }
            String tableType = x1.substring(z + 1);
            if (SpreadsheetResult.class.getSimpleName().equals(tableType) || SpreadsheetResult.class.getName().equals(tableType)) {
                return "SpreadsheetResult" + tableName;
            }
        }
        return null;
    }

    private Map<TableSyntaxNode, CustomSpreadsheetResultOpenClass> registerNewCustomSpreadsheetResultTypes(TableSyntaxNode[] tableSyntaxNodes, RulesModuleBindingContext rulesModuleBindingContext) {
        if (OpenLSystemProperties.isCustomSpreadsheetTypesSupported(rulesModuleBindingContext.getExternalParams())) {
            HashMap<TableSyntaxNode, CustomSpreadsheetResultOpenClass> customSpreadsheetResultOpenClassTableSyntaxNodes = new HashMap<TableSyntaxNode, CustomSpreadsheetResultOpenClass>();
            for (TableSyntaxNode tableSyntaxNode : tableSyntaxNodes) {
                String sprResTypeName = XlsBinder.getSprResTypeNameIfCustomSpreadsheetResultTableSyntaxNode(tableSyntaxNode);
                if (sprResTypeName == null) continue;
                CustomSpreadsheetResultOpenClass t = (CustomSpreadsheetResultOpenClass)rulesModuleBindingContext.getModule().findType(sprResTypeName);
                if (t == null) {
                    CustomSpreadsheetResultOpenClass customSpreadsheetResultOpenClass = new CustomSpreadsheetResultOpenClass(sprResTypeName, rulesModuleBindingContext.getModule(), rulesModuleBindingContext.isExecutionMode() ? null : tableSyntaxNode.getTableBody(), true, XlsNodeTypes.XLS_SPREADSHEET.equals((Object)tableSyntaxNode.getNodeType()));
                    rulesModuleBindingContext.getModule().addType((IOpenClass)customSpreadsheetResultOpenClass);
                    t = customSpreadsheetResultOpenClass;
                }
                customSpreadsheetResultOpenClassTableSyntaxNodes.put(tableSyntaxNode, t);
            }
            return Collections.unmodifiableMap(customSpreadsheetResultOpenClassTableSyntaxNodes);
        }
        return Collections.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IBoundNode bindInternal(XlsModuleSyntaxNode moduleSyntaxNode, XlsModuleOpenClass module, TableSyntaxNode[] tableSyntaxNodes, Map<TableSyntaxNode, CustomSpreadsheetResultOpenClass> customSpreadsheetResultOpenClassMap, OpenL openl, RulesModuleBindingContext rulesModuleBindingContext) {
        IMemberBoundNode child;
        int i;
        IMemberBoundNode[] childrens = new IMemberBoundNode[tableSyntaxNodes.length];
        OpenMethodHeader[] openMethodHeaders = new OpenMethodHeader[tableSyntaxNodes.length];
        SyntaxNodeExceptionHolder syntaxNodeExceptionHolder = new SyntaxNodeExceptionHolder();
        try {
            rulesModuleBindingContext.setIgnoreCustomSpreadsheetResultCompilation(true);
            for (i = 0; i < tableSyntaxNodes.length; ++i) {
                if (!this.isExecutableTableSyntaxNode(tableSyntaxNodes[i])) continue;
                openMethodHeaders[i] = this.addMethodHeaderToContext(module, tableSyntaxNodes[i], customSpreadsheetResultOpenClassMap.get((Object)tableSyntaxNodes[i]), openl, rulesModuleBindingContext, syntaxNodeExceptionHolder, childrens, i);
            }
        }
        finally {
            rulesModuleBindingContext.setIgnoreCustomSpreadsheetResultCompilation(false);
        }
        for (i = 0; i < tableSyntaxNodes.length; ++i) {
            if (this.isExecutableTableSyntaxNode(tableSyntaxNodes[i])) continue;
            childrens[i] = child = this.beginBind(tableSyntaxNodes[i], module, openl, rulesModuleBindingContext);
        }
        for (i = 0; i < tableSyntaxNodes.length; ++i) {
            if (this.isExecutableTableSyntaxNode(tableSyntaxNodes[i]) || (child = childrens[i]) == null) continue;
            try {
                child.addTo((ModuleOpenClass)module);
                continue;
            }
            catch (OpenlNotCheckedException e) {
                SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((Throwable)e, (ISyntaxNode)tableSyntaxNodes[i]);
                this.processError(error, rulesModuleBindingContext);
            }
        }
        this.generateByteCode(childrens, tableSyntaxNodes, rulesModuleBindingContext);
        for (i = 0; i < childrens.length; ++i) {
            if (!this.isExecutableTableSyntaxNode(tableSyntaxNodes[i])) continue;
            rulesModuleBindingContext.preBindMethod(openMethodHeaders[i]);
        }
        for (i = 0; i < childrens.length; ++i) {
            if (childrens[i] == null) continue;
            this.finalizeBind(childrens[i], tableSyntaxNodes[i], rulesModuleBindingContext);
        }
        syntaxNodeExceptionHolder.processBindingContextErrors((IBindingContext)rulesModuleBindingContext);
        if (rulesModuleBindingContext.isExecutionMode()) {
            this.removeDebugInformation(childrens, tableSyntaxNodes, rulesModuleBindingContext);
        }
        return new ModuleNode((ISyntaxNode)moduleSyntaxNode, (IOpenClass)rulesModuleBindingContext.getModule());
    }

    private String getParentClassName(DatatypeTableBoundNode datatypeTableBoundNode, RulesModuleBindingContext rulesModuleBindingContext) {
        IOpenClass parentClass;
        if (datatypeTableBoundNode.getParentClassName() != null && (parentClass = rulesModuleBindingContext.findType("org.openl.this", datatypeTableBoundNode.getParentClassName())) != null) {
            return parentClass.getJavaName();
        }
        return null;
    }

    private void generateByteCode(IMemberBoundNode[] childrens, TableSyntaxNode[] tableSyntaxNodes, RulesModuleBindingContext rulesModuleBindingContext) {
        Collection datatypeTableBoundNodes = null;
        for (IMemberBoundNode children : childrens) {
            if (!(children instanceof DatatypeTableBoundNode)) continue;
            DatatypeTableBoundNode datatypeTableBoundNode = (DatatypeTableBoundNode)children;
            if (datatypeTableBoundNodes == null) {
                datatypeTableBoundNodes = Arrays.stream(childrens).filter(e -> e instanceof DatatypeTableBoundNode).map(DatatypeTableBoundNode.class::cast).collect(Collectors.toList());
            }
            DatatypeTableBoundNode parentDatatypeTableBoundNode = datatypeTableBoundNodes.stream().filter(d -> Objects.equals(d.getDataType().getJavaName(), this.getParentClassName(datatypeTableBoundNode, rulesModuleBindingContext))).findFirst().orElse(null);
            datatypeTableBoundNode.setParentDatatypeTableBoundNode(parentDatatypeTableBoundNode);
        }
        for (int i = 0; i < childrens.length; ++i) {
            if (!(childrens[i] instanceof DatatypeTableBoundNode)) continue;
            DatatypeTableBoundNode datatypeTableBoundNode = (DatatypeTableBoundNode)childrens[i];
            try {
                datatypeTableBoundNode.generateByteCode((IBindingContext)rulesModuleBindingContext);
                continue;
            }
            catch (SyntaxNodeException error) {
                this.processError(error, rulesModuleBindingContext);
                continue;
            }
            catch (Exception | LinkageError t) {
                SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((Throwable)t, (ISyntaxNode)tableSyntaxNodes[i]);
                this.processError(error, rulesModuleBindingContext);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private OpenMethodHeader addMethodHeaderToContext(XlsModuleOpenClass module, TableSyntaxNode tableSyntaxNode, CustomSpreadsheetResultOpenClass customSpreadsheetResultOpenClass, OpenL openl, RulesModuleBindingContext rulesModuleBindingContext, SyntaxNodeExceptionHolder syntaxNodeExceptionHolder, IMemberBoundNode[] children, int index) {
        OpenMethodHeader openMethodHeader = null;
        SyntaxNodeException[] errors = SyntaxNodeException.EMPTY_ARRAY;
        Collection<Object> messages = Collections.emptyList();
        try {
            AExecutableNodeBinder aExecutableNodeBinder = (AExecutableNodeBinder)this.getBinderFactories().get(tableSyntaxNode.getType());
            IOpenSourceCodeModule source = aExecutableNodeBinder.createHeaderSource(tableSyntaxNode, (IBindingContext)rulesModuleBindingContext);
            try {
                rulesModuleBindingContext.pushErrors();
                rulesModuleBindingContext.pushMessages();
                openMethodHeader = (OpenMethodHeader)OpenLManager.makeMethodHeader((OpenL)openl, (IOpenSourceCodeModule)source, (IBindingContext)rulesModuleBindingContext);
                if (openMethodHeader == null) return null;
                XlsBinderExecutableMethodBind xlsBinderExecutableMethodBind = new XlsBinderExecutableMethodBind(module, openl, tableSyntaxNode, children, index, openMethodHeader, customSpreadsheetResultOpenClass, rulesModuleBindingContext, syntaxNodeExceptionHolder);
                rulesModuleBindingContext.addBinderMethod(openMethodHeader, xlsBinderExecutableMethodBind);
                OpenMethodHeader openMethodHeader2 = openMethodHeader;
                return openMethodHeader2;
            }
            finally {
                errors = rulesModuleBindingContext.getErrors();
                messages = rulesModuleBindingContext.getMessages();
                rulesModuleBindingContext.popErrors();
                rulesModuleBindingContext.popMessages();
                if (openMethodHeader == null) {
                    rulesModuleBindingContext.addMessages(messages);
                    Arrays.stream(errors).forEach(arg_0 -> ((RulesModuleBindingContext)rulesModuleBindingContext).addError(arg_0));
                }
            }
        }
        catch (Exception | LinkageError e) {
            SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((Throwable)e, (ISyntaxNode)tableSyntaxNode);
            this.processError(error, rulesModuleBindingContext);
            rulesModuleBindingContext.addMessages(messages);
            Arrays.stream(errors).forEach(arg_0 -> ((RulesModuleBindingContext)rulesModuleBindingContext).addError(arg_0));
        }
        return null;
    }

    protected void finalizeBind(IMemberBoundNode memberBoundNode, TableSyntaxNode tableSyntaxNode, RulesModuleBindingContext rulesModuleBindingContext) {
        try {
            memberBoundNode.finalizeBind((IBindingContext)rulesModuleBindingContext);
        }
        catch (SyntaxNodeException error) {
            this.processError(error, rulesModuleBindingContext);
        }
        catch (Exception | LinkageError t) {
            SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((Throwable)t, (ISyntaxNode)tableSyntaxNode);
            this.processError(error, rulesModuleBindingContext);
        }
    }

    protected void removeDebugInformation(IMemberBoundNode[] boundNodes, TableSyntaxNode[] tableSyntaxNodes, RulesModuleBindingContext ruleModuleBindingContext) {
        for (int i = 0; i < boundNodes.length; ++i) {
            if (boundNodes[i] == null) continue;
            try {
                boundNodes[i].removeDebugInformation((IBindingContext)ruleModuleBindingContext);
                continue;
            }
            catch (SyntaxNodeException error) {
                this.processError(error, ruleModuleBindingContext);
                continue;
            }
            catch (Exception | LinkageError t) {
                SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((Throwable)t, (ISyntaxNode)tableSyntaxNodes[i]);
                this.processError(error, ruleModuleBindingContext);
            }
        }
    }

    private IMemberBoundNode beginBind(TableSyntaxNode tableSyntaxNode, XlsModuleOpenClass module, OpenL openl, RulesModuleBindingContext rulesModuleBindingContext) {
        try {
            return this.preBindXlsNode((ISyntaxNode)tableSyntaxNode, openl, rulesModuleBindingContext, module);
        }
        catch (SyntaxNodeException error) {
            this.processError(error, rulesModuleBindingContext);
        }
        catch (Exception | LinkageError t) {
            SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((Throwable)t, (ISyntaxNode)tableSyntaxNode);
            this.processError(error, rulesModuleBindingContext);
        }
        return null;
    }

    protected void processError(SyntaxNodeException error, RulesModuleBindingContext rulesModuleBindingContext) {
        rulesModuleBindingContext.addError(error);
    }

    private static class SyntaxNodeExceptionHolder {
        private final List<SyntaxNodeException> syntaxNodeExceptions = new ArrayList<SyntaxNodeException>();

        private SyntaxNodeExceptionHolder() {
        }

        private void addBindingContextError(SyntaxNodeException e) {
            this.syntaxNodeExceptions.add(e);
        }

        private void processBindingContextErrors(IBindingContext bindingContext) {
            for (SyntaxNodeException e : this.syntaxNodeExceptions) {
                bindingContext.addError(e);
            }
            this.syntaxNodeExceptions.clear();
        }
    }

    class XlsBinderExecutableMethodBind
    implements RecursiveOpenMethodPreBinder {
        final TableSyntaxNode tableSyntaxNode;
        final RulesModuleBindingContext rulesModuleBindingContext;
        final OpenL openl;
        final XlsModuleOpenClass module;
        final IMemberBoundNode[] childrens;
        final int index;
        final OpenMethodHeader openMethodHeader;
        boolean preBinding = false;
        final SyntaxNodeExceptionHolder syntaxNodeExceptionHolder;
        boolean completed = false;
        final CustomSpreadsheetResultOpenClass customSpreadsheetResultOpenClass;

        XlsBinderExecutableMethodBind(XlsModuleOpenClass module, OpenL openl, TableSyntaxNode tableSyntaxNode, IMemberBoundNode[] childrens, int index, OpenMethodHeader openMethodHeader, CustomSpreadsheetResultOpenClass customSpreadsheetResultOpenClass, RulesModuleBindingContext rulesModuleBindingContext, SyntaxNodeExceptionHolder syntaxNodeExceptionHolder) {
            this.tableSyntaxNode = tableSyntaxNode;
            this.rulesModuleBindingContext = rulesModuleBindingContext;
            this.module = module;
            this.openl = openl;
            this.childrens = childrens;
            this.index = index;
            this.openMethodHeader = openMethodHeader;
            this.syntaxNodeExceptionHolder = syntaxNodeExceptionHolder;
            this.customSpreadsheetResultOpenClass = customSpreadsheetResultOpenClass;
        }

        @Override
        public TableSyntaxNode getTableSyntaxNode() {
            return this.tableSyntaxNode;
        }

        @Override
        public boolean isSpreadsheetWithCustomSpreadsheetResult() {
            return this.customSpreadsheetResultOpenClass != null;
        }

        @Override
        public CustomSpreadsheetResultOpenClass getCustomSpreadsheetResultOpenClass() {
            return this.customSpreadsheetResultOpenClass;
        }

        @Override
        public OpenMethodHeader getHeader() {
            return this.openMethodHeader;
        }

        public String getDisplayName(int mode) {
            return this.openMethodHeader.getDisplayName(mode);
        }

        public IOpenClass getType() {
            return this.openMethodHeader.getType();
        }

        public IOpenMethod getMethod() {
            return this;
        }

        public IMethodSignature getSignature() {
            return this.openMethodHeader.getSignature();
        }

        public String getName() {
            return this.openMethodHeader.getName();
        }

        public Object invoke(Object target, Object[] params, IRuntimeEnv env) {
            throw new UnsupportedOperationException();
        }

        public IMemberMetaInfo getInfo() {
            return this.openMethodHeader.getInfo();
        }

        public boolean isStatic() {
            return this.openMethodHeader.isStatic();
        }

        public boolean isConstructor() {
            return false;
        }

        public IOpenClass getDeclaringClass() {
            return this.module;
        }

        @Override
        public void startPreBind() {
            if (this.completed) {
                throw new IllegalStateException(String.format("Method '%s' is already pre-compiled.", MethodUtil.printMethod((String)this.getHeader().getName(), (IOpenClass[])this.getHeader().getSignature().getParameterTypes())));
            }
            this.preBinding = true;
        }

        @Override
        public void finishPreBind() {
            if (!this.completed && this.preBinding) {
                throw new IllegalStateException(String.format("Method '%s' is not pre-compiled.", MethodUtil.printMethod((String)this.getHeader().getName(), (IOpenClass[])this.getHeader().getSignature().getParameterTypes())));
            }
            if (!this.preBinding) {
                throw new IllegalStateException(String.format("Pre-compilation is not started for method '%s'.", MethodUtil.printMethod((String)this.getHeader().getName(), (IOpenClass[])this.getHeader().getSignature().getParameterTypes())));
            }
            this.preBinding = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void preBind() {
            block8: {
                try {
                    block9: {
                        if (this.completed) break block8;
                        if (!this.preBinding) {
                            throw new IllegalStateException(String.format("Pre-compilation is not started for method '%s'.", MethodUtil.printMethod((String)this.getHeader().getName(), (IOpenClass[])this.getHeader().getSignature().getParameterTypes())));
                        }
                        try {
                            IMemberBoundNode memberBoundNode;
                            this.rulesModuleBindingContext.pushErrors();
                            this.childrens[this.index] = memberBoundNode = XlsBinder.this.beginBind(this.tableSyntaxNode, this.module, this.openl, this.rulesModuleBindingContext);
                            if (memberBoundNode == null) break block9;
                            try {
                                memberBoundNode.addTo((ModuleOpenClass)this.module);
                            }
                            catch (Exception | LinkageError e) {
                                SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((Throwable)e, (ISyntaxNode)this.tableSyntaxNode);
                                XlsBinder.this.processError(error, this.rulesModuleBindingContext);
                            }
                        }
                        catch (Throwable throwable) {
                            this.rulesModuleBindingContext.popErrors().forEach(x$0 -> this.syntaxNodeExceptionHolder.addBindingContextError((SyntaxNodeException)x$0));
                            throw throwable;
                        }
                    }
                    this.rulesModuleBindingContext.popErrors().forEach(x$0 -> this.syntaxNodeExceptionHolder.addBindingContextError((SyntaxNodeException)x$0));
                }
                finally {
                    this.completed = true;
                }
            }
        }

        @Override
        public boolean isPreBindStarted() {
            return this.preBinding;
        }

        @Override
        public boolean isCompleted() {
            return this.completed;
        }
    }

    private static class BinderFactoryHolder {
        private static final Map<String, AXlsTableBinder> INSTANCE;
        private static final String[][] BINDERS;

        private BinderFactoryHolder() {
        }

        static {
            BINDERS = new String[][]{{XlsNodeTypes.XLS_DATA.toString(), DataNodeBinder.class.getName()}, {XlsNodeTypes.XLS_DATATYPE.toString(), DatatypeNodeBinder.class.getName()}, {XlsNodeTypes.XLS_DT.toString(), DecisionTableNodeBinder.class.getName()}, {XlsNodeTypes.XLS_SPREADSHEET.toString(), SpreadsheetNodeBinder.class.getName()}, {XlsNodeTypes.XLS_METHOD.toString(), MethodTableNodeBinder.class.getName()}, {XlsNodeTypes.XLS_TEST_METHOD.toString(), TestMethodNodeBinder.class.getName()}, {XlsNodeTypes.XLS_RUN_METHOD.toString(), TestMethodNodeBinder.class.getName()}, {XlsNodeTypes.XLS_TBASIC.toString(), AlgorithmNodeBinder.class.getName()}, {XlsNodeTypes.XLS_COLUMN_MATCH.toString(), ColumnMatchNodeBinder.class.getName()}, {XlsNodeTypes.XLS_PROPERTIES.toString(), PropertyTableBinder.class.getName()}, {XlsNodeTypes.XLS_CONDITIONS.toString(), ConditionsTableBinder.class.getName()}, {XlsNodeTypes.XLS_ACTIONS.toString(), ActionsTableBinder.class.getName()}, {XlsNodeTypes.XLS_RETURNS.toString(), ReturnsTableBinder.class.getName()}, {XlsNodeTypes.XLS_CONSTANTS.toString(), ConstantsTableBinder.class.getName()}};
            HashMap<String, AXlsTableBinder> binderFactory = new HashMap<String, AXlsTableBinder>();
            for (String[] binder : BINDERS) {
                try {
                    binderFactory.put(binder[0], (AXlsTableBinder)((Object)Class.forName(binder[1]).newInstance()));
                }
                catch (Exception ex) {
                    throw RuntimeExceptionWrapper.wrap((Throwable)ex);
                }
            }
            INSTANCE = Collections.unmodifiableMap(binderFactory);
        }
    }
}

