/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.binding;

import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.IMemberBoundNode;
import org.openl.binding.impl.module.ModuleOpenClass;
import org.openl.rules.lang.xls.binding.ATableBoundNode;
import org.openl.rules.lang.xls.binding.wrapper.AliasWrapperLogic;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.method.ExecutableRulesMethod;
import org.openl.rules.table.ICell;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.SubTextSourceCodeModule;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMember;
import org.openl.types.IOpenMethod;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.NullOpenClass;
import org.openl.types.impl.OpenMethodHeader;
import org.openl.util.MessageUtils;
import org.openl.util.OpenClassUtils;
import org.openl.util.StringUtils;
import org.openl.util.text.ILocation;
import org.openl.util.text.TextInfo;
import org.openl.vm.IRuntimeEnv;

public abstract class AMethodBasedNode
extends ATableBoundNode
implements IMemberBoundNode {
    private final OpenL openl;
    private final IOpenMethodHeader header;
    private ExecutableRulesMethod method;
    private final ModuleOpenClass module;

    public AMethodBasedNode(TableSyntaxNode methodNode, OpenL openl, IOpenMethodHeader header, ModuleOpenClass module) {
        super(methodNode);
        this.header = header;
        this.openl = openl;
        this.module = module;
    }

    public OpenL getOpenl() {
        return this.openl;
    }

    public IOpenMethodHeader getHeader() {
        return this.header;
    }

    public ExecutableRulesMethod getMethod() {
        return this.method;
    }

    public ModuleOpenClass getModule() {
        return this.module;
    }

    protected Object evaluateRuntime(IRuntimeEnv env) {
        throw new UnsupportedOperationException("Should not be called");
    }

    public IOpenClass getType() {
        return this.header.getType();
    }

    public void addTo(ModuleOpenClass openClass) {
        this.method = this.createMethodShell();
        this.method.setModuleName(this.module.getModuleName());
        openClass.addMethod((IOpenMethod)this.method);
        this.getTableSyntaxNode().setMember((IOpenMember)this.method);
        if (this.hasAliasName()) {
            openClass.addMethod(this.getAliasMethod(this.method));
        }
    }

    protected boolean hasAliasName() {
        return StringUtils.isNotBlank((CharSequence)this.getTableSyntaxNode().getTableProperties().getId());
    }

    protected IOpenMethod getAliasMethod(ExecutableRulesMethod originalMethod) {
        String aliasMethodName = this.getTableSyntaxNode().getTableProperties().getId();
        return AliasWrapperLogic.wrapOpenMethod((IOpenMethod)originalMethod, aliasMethodName);
    }

    protected abstract ExecutableRulesMethod createMethodShell();

    public void removeDebugInformation(IBindingContext cxt) throws Exception {
        if (cxt.isExecutionMode() && this.header instanceof OpenMethodHeader) {
            OpenMethodHeader tableHeader = (OpenMethodHeader)this.header;
            tableHeader.setTypeLocation(null);
            tableHeader.setParamTypeLocations(null);
        }
    }

    public void finalizeBind(IBindingContext bindingContext) throws Exception {
        if (this.header instanceof OpenMethodHeader) {
            OpenMethodHeader tableHeader = (OpenMethodHeader)this.header;
            IOpenSourceCodeModule headerSyntaxNode = null;
            IOpenClass type = OpenClassUtils.getRootComponentClass((IOpenClass)tableHeader.getType());
            if (!NullOpenClass.isAnyNull((IOpenClass[])new IOpenClass[]{type}) && type.getInstanceClass() == null) {
                headerSyntaxNode = this.getHeaderSyntaxNode(bindingContext);
                this.addTypeError(bindingContext, type, tableHeader.getTypeLocation(), headerSyntaxNode);
            }
            ILocation[] paramTypeLocations = tableHeader.getParamTypeLocations();
            for (int i = 0; i < this.header.getSignature().getNumberOfParameters(); ++i) {
                ILocation sourceLocation;
                IOpenClass parameterType = OpenClassUtils.getRootComponentClass((IOpenClass)this.header.getSignature().getParameterType(i));
                ILocation iLocation = sourceLocation = paramTypeLocations == null ? null : paramTypeLocations[i];
                if (NullOpenClass.isAnyNull((IOpenClass[])new IOpenClass[]{parameterType}) || parameterType.getInstanceClass() != null) continue;
                if (headerSyntaxNode == null) {
                    headerSyntaxNode = this.getHeaderSyntaxNode(bindingContext);
                }
                this.addTypeError(bindingContext, parameterType, sourceLocation, headerSyntaxNode);
            }
        }
    }

    private IOpenSourceCodeModule getHeaderSyntaxNode(IBindingContext bindingContext) {
        GridCellSourceCodeModule src = new GridCellSourceCodeModule(this.getTableSyntaxNode().getGridTable(), bindingContext);
        int startPosition = this.getSignatureStartIndex();
        return new SubTextSourceCodeModule((IOpenSourceCodeModule)src, startPosition, src.getCode().length());
    }

    protected void addTypeError(IBindingContext bindingContext, IOpenClass type, ILocation location, IOpenSourceCodeModule syntaxNode) {
        String message = MessageUtils.getTypeDefinedErrorMessage((String)type.getName());
        SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((String)message, null, (ILocation)location, (IOpenSourceCodeModule)syntaxNode);
        bindingContext.addError(error);
    }

    public int getSignatureStartIndex() {
        ICell cell = this.getTableSyntaxNode().getGridTable().getCell(0, 0);
        TextInfo tableHeaderText = new TextInfo(cell.getStringValue());
        return this.getTableSyntaxNode().getHeader().getHeaderToken().getLocation().getEnd().getAbsolutePosition(tableHeaderText);
    }
}

