/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.range;

import org.openl.rules.range.Range;

enum Separator {
    DASH(Range.Type.CLOSED, "-"),
    SEMICOLON(Range.Type.CLOSED, ";"),
    ELLIPSIS(Range.Type.OPEN, "\u2026"),
    TRIPLE_DOT(Range.Type.OPEN, "..."),
    DOUBLE_DOT(Range.Type.CLOSED, "..");

    private final Range.Type type;
    private final char[] chars;

    private Separator(Range.Type type, String sep) {
        this.type = type;
        this.chars = sep.toCharArray();
    }

    int length() {
        return this.chars.length;
    }

    public Range.Type getType() {
        return this.type;
    }

    static Separator recognize(CharSequence text, int index) {
        for (Separator sep : Separator.values()) {
            if (!sep.matches(text, index)) continue;
            return sep;
        }
        throw new IllegalStateException("Unknown separator");
    }

    private boolean matches(CharSequence text, int index) {
        if (index + this.chars.length > text.length()) {
            return false;
        }
        for (int i = 0; i < this.chars.length; ++i) {
            if (text.charAt(index + i) == this.chars[i]) continue;
            return false;
        }
        return true;
    }
}

