/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.actions.style.font;

import org.openl.rules.lang.xls.types.meta.MetaInfoWriter;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.IWritableGrid;
import org.openl.rules.table.actions.AUndoableCellAction;
import org.openl.rules.table.ui.ICellFont;

public class SetColorAction
extends AUndoableCellAction {
    private short[] prevColor;
    private final short[] newColor;

    public SetColorAction(int col, int row, short[] color, MetaInfoWriter metaInfoWriter) {
        super(col, row, metaInfoWriter);
        this.newColor = color;
    }

    @Override
    public void doAction(IGridTable table) {
        IWritableGrid grid = (IWritableGrid)table.getGrid();
        ICellFont font = grid.getCell(this.getCol(), this.getRow()).getFont();
        this.prevColor = font != null ? font.getFontColor() : null;
        grid.setCellFontColor(this.getCol(), this.getRow(), this.newColor);
    }

    @Override
    public void undoAction(IGridTable table) {
        IWritableGrid grid = (IWritableGrid)table.getGrid();
        grid.setCellFontColor(this.getCol(), this.getRow(), this.prevColor);
    }
}

