/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.testmethod.result;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.openl.rules.helpers.NumberUtils;
import org.openl.rules.testmethod.result.ArrayComparator;
import org.openl.rules.testmethod.result.CollectionComparator;
import org.openl.rules.testmethod.result.ComparableComparator;
import org.openl.rules.testmethod.result.GenericComparator;
import org.openl.rules.testmethod.result.MapComparator;
import org.openl.rules.testmethod.result.NumberComparator;
import org.openl.rules.testmethod.result.ObjectComparator;
import org.openl.rules.testmethod.result.StringComparator;
import org.openl.rules.testmethod.result.TestResultComparator;
import org.openl.util.ClassUtils;

public class TestResultComparatorFactory {
    private TestResultComparatorFactory() {
    }

    public static TestResultComparator getComparator(Class<?> clazz, Double delta) {
        if (clazz == null) {
            GenericComparator.getInstance();
        } else {
            if (clazz.isArray()) {
                return new ArrayComparator(clazz.getComponentType(), delta);
            }
            if (String.class == clazz) {
                return StringComparator.getInstance();
            }
            if (NumberUtils.isNumberType(clazz)) {
                if (delta == null) {
                    if (NumberUtils.isNonFloatPointType(clazz)) {
                        return ComparableComparator.getInstance();
                    }
                    return NumberComparator.getInstance();
                }
                return new NumberComparator(delta);
            }
            if (ClassUtils.isAssignable(clazz, Comparable.class)) {
                return ComparableComparator.getInstance();
            }
            if (ClassUtils.isAssignable(clazz, Collection.class)) {
                return CollectionComparator.getInstance();
            }
            if (ClassUtils.isAssignable(clazz, Map.class)) {
                return MapComparator.getInstance();
            }
            if (Object.class == clazz || Serializable.class == clazz) {
                if (delta == null) {
                    return ObjectComparator.getInstance();
                }
                return new ObjectComparator(delta);
            }
        }
        return GenericComparator.getInstance();
    }
}

