/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.openl.exception.OpenLException;
import org.openl.message.OpenLErrorMessage;
import org.openl.message.OpenLMessage;
import org.openl.message.OpenLMessagesUtils;
import org.openl.message.OpenLWarnMessage;
import org.openl.message.Severity;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.method.ExecutableRulesMethod;
import org.openl.rules.table.properties.ITableProperties;
import org.openl.rules.table.properties.def.TablePropertyDefinition;
import org.openl.rules.table.properties.def.TablePropertyDefinitionUtils;
import org.openl.rules.validation.OpenMethodDispatcherHelper;
import org.openl.rules.validation.TablesValidator;
import org.openl.rules.validation.ValidationUtils;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.util.CollectionUtils;
import org.openl.validation.ValidationResult;

public class UniquePropertyValueValidator
extends TablesValidator {
    private final String propertyName;

    public UniquePropertyValueValidator(String propertyName) {
        this.propertyName = propertyName;
    }

    @Override
    public ValidationResult validateTables(TableSyntaxNode[] tableSyntaxNodes, IOpenClass openClass) {
        Collection<ExecutableRulesMethod> executableActiveMethods = this.selectActiveMethods(OpenMethodDispatcherHelper.extractMethods(openClass));
        HashMap values = new HashMap();
        ArrayList<OpenLMessage> messages = new ArrayList<OpenLMessage>();
        for (ExecutableRulesMethod executableRulesMethod : executableActiveMethods) {
            Object value;
            ITableProperties methodProperties;
            if (executableRulesMethod.isAlias() || (methodProperties = executableRulesMethod.getMethodProperties()) == null || (value = methodProperties.getPropertyValue(this.propertyName)) == null) continue;
            if (values.containsKey(value)) {
                ((Set)values.get(value)).add(executableRulesMethod);
                continue;
            }
            HashSet<ExecutableRulesMethod> setOfExecutableRulesMethods = new HashSet<ExecutableRulesMethod>();
            setOfExecutableRulesMethods.add(executableRulesMethod);
            values.put(value, setOfExecutableRulesMethods);
        }
        for (Map.Entry entry : values.entrySet()) {
            if (((Set)entry.getValue()).size() <= 1) continue;
            TablePropertyDefinition property = TablePropertyDefinitionUtils.getPropertyByName(this.propertyName);
            Severity errorSeverity = null;
            if (property != null) {
                errorSeverity = property.getErrorSeverity();
            }
            Object value = entry.getKey();
            for (ExecutableRulesMethod method : (Set)entry.getValue()) {
                OpenLMessage message = this.getMessage(String.format("Found non-unique value '%s' for table property '%s'.", value, this.propertyName), errorSeverity, method.getSyntaxNode());
                messages.add(message);
            }
        }
        return ValidationUtils.withMessages(messages);
    }

    private OpenLMessage getMessage(String message, Severity severity, TableSyntaxNode syntaxNode) {
        if (Severity.WARN.equals((Object)severity)) {
            if (syntaxNode != null) {
                return new OpenLWarnMessage(message, (ISyntaxNode)syntaxNode);
            }
            return OpenLMessagesUtils.newWarnMessage((String)message);
        }
        if (Severity.ERROR.equals((Object)severity)) {
            SyntaxNodeException sne = SyntaxNodeExceptionUtils.createError((String)message, (ISyntaxNode)syntaxNode);
            return new OpenLErrorMessage((OpenLException)sne);
        }
        return new OpenLWarnMessage(message, (ISyntaxNode)syntaxNode);
    }

    private Collection<ExecutableRulesMethod> selectActiveMethods(List<IOpenMethod> methods) {
        return CollectionUtils.findAll((Iterable)methods.stream().filter(ExecutableRulesMethod.class::isInstance).map(ExecutableRulesMethod.class::cast).collect(Collectors.toList()), method -> {
            if (method.getMethodProperties() == null || method.getMethodProperties().getActive() == null) {
                return true;
            }
            return method.getMethodProperties().getActive();
        });
    }
}

