/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.platform;

import info.aduna.platform.DefaultPlatform;
import info.aduna.platform.Platform;
import info.aduna.platform.support.MacOSXPlatform;
import info.aduna.platform.support.PosixGnomePlatform;
import info.aduna.platform.support.PosixKDEPlatform;
import info.aduna.platform.support.PosixPlatform;
import info.aduna.platform.support.WindowsPlatform;

public abstract class PlatformFactory {
    private static Platform PLATFORM;

    public static Platform getPlatform() {
        return PLATFORM;
    }

    private static boolean isGnome() {
        String gdmSession = System.getenv("GDMSESSION");
        if (gdmSession != null && gdmSession.toLowerCase().indexOf("gnome") >= 0) {
            return true;
        }
        String desktopSession = System.getenv("DESKTOP_SESSION");
        if (desktopSession != null && desktopSession.toLowerCase().indexOf("gnome") >= 0) {
            return true;
        }
        String gnomeDesktopSessionId = System.getenv("GNOME_DESKTOP_SESSION_ID");
        return gnomeDesktopSessionId != null && gnomeDesktopSessionId.trim().length() > 0;
    }

    private static boolean isKDE() {
        String gdmSession = System.getenv("GDMSESSION");
        if (gdmSession != null && gdmSession.toLowerCase().indexOf("kde") >= 0) {
            return true;
        }
        String desktopSession = System.getenv("DESKTOP_SESSION");
        if (desktopSession != null && desktopSession.toLowerCase().indexOf("kde") >= 0) {
            return true;
        }
        String windowManager = System.getenv("WINDOW_MANAGER");
        return windowManager != null && windowManager.trim().toLowerCase().endsWith("kde");
    }

    public static void main(String[] args) {
        Platform platform = PlatformFactory.getPlatform();
        System.out.println(platform.getApplicationDataDir("My Application: Test").getAbsolutePath());
    }

    static {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.indexOf("windows") != -1) {
            PLATFORM = new WindowsPlatform();
        } else if (osName.indexOf("solaris") != -1 || osName.indexOf("sunos") != -1 || osName.indexOf("linux") != -1 || osName.indexOf("hp-ux") != -1) {
            PosixPlatform unixPlatform = new PosixPlatform();
            PLATFORM = PlatformFactory.isGnome() ? new PosixGnomePlatform() : (PlatformFactory.isKDE() ? new PosixKDEPlatform() : unixPlatform);
        } else {
            PLATFORM = osName.indexOf("mac os x") != -1 || osName.indexOf("macos") != -1 || osName.indexOf("darwin") != -1 ? new MacOSXPlatform() : new DefaultPlatform();
        }
    }
}

