/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra;

import java.util.ArrayList;
import java.util.List;
import org.openrdf.query.algebra.OrderElem;
import org.openrdf.query.algebra.QueryModelNode;
import org.openrdf.query.algebra.QueryModelVisitor;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.UnaryTupleOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Order
extends UnaryTupleOperator {
    private List<OrderElem> elements = new ArrayList<OrderElem>();

    public Order() {
    }

    public Order(TupleExpr arg) {
        super(arg);
    }

    public Order(TupleExpr arg, OrderElem ... elements) {
        this(arg);
        this.addElements(elements);
    }

    public Order(TupleExpr arg, Iterable<OrderElem> elements) {
        this(arg);
        this.addElements(elements);
    }

    public List<OrderElem> getElements() {
        return this.elements;
    }

    public void setElements(List<OrderElem> elements) {
        this.elements = elements;
    }

    public void addElements(OrderElem ... elements) {
        for (OrderElem pe : elements) {
            this.addElement(pe);
        }
    }

    public void addElements(Iterable<OrderElem> elements) {
        for (OrderElem pe : elements) {
            this.addElement(pe);
        }
    }

    public void addElement(OrderElem pe) {
        this.elements.add(pe);
        pe.setParentNode(this);
    }

    @Override
    public <X extends Exception> void visit(QueryModelVisitor<X> visitor) throws X {
        visitor.meet(this);
    }

    @Override
    public <X extends Exception> void visitChildren(QueryModelVisitor<X> visitor) throws X {
        for (OrderElem elem : this.elements) {
            elem.visit(visitor);
        }
        super.visitChildren(visitor);
    }

    @Override
    public void replaceChildNode(QueryModelNode current, QueryModelNode replacement) {
        int index = this.elements.indexOf(current);
        if (index >= 0) {
            this.elements.set(index, (OrderElem)replacement);
            replacement.setParentNode(this);
        } else {
            super.replaceChildNode(current, replacement);
        }
    }

    @Override
    public Order clone() {
        Order clone = (Order)super.clone();
        ArrayList<OrderElem> elementsClone = new ArrayList<OrderElem>(this.getElements().size());
        for (OrderElem elem : this.getElements()) {
            elementsClone.add(elem.clone());
        }
        clone.setElements(elementsClone);
        return clone;
    }
}

