/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.openrdf.query.algebra.ProjectionElem;
import org.openrdf.query.algebra.QueryModelNode;
import org.openrdf.query.algebra.QueryModelNodeBase;
import org.openrdf.query.algebra.QueryModelVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectionElemList
extends QueryModelNodeBase {
    private List<ProjectionElem> elements = new ArrayList<ProjectionElem>();

    public ProjectionElemList() {
    }

    public ProjectionElemList(ProjectionElem ... elements) {
        this.addElements(elements);
    }

    public ProjectionElemList(Iterable<ProjectionElem> elements) {
        this.addElements(elements);
    }

    public List<ProjectionElem> getElements() {
        return this.elements;
    }

    public void setElements(List<ProjectionElem> elements) {
        this.elements = elements;
    }

    public void addElements(ProjectionElem ... elements) {
        for (ProjectionElem pe : elements) {
            this.addElement(pe);
        }
    }

    public void addElements(Iterable<ProjectionElem> elements) {
        for (ProjectionElem pe : elements) {
            this.addElement(pe);
        }
    }

    public void addElement(ProjectionElem pe) {
        assert (pe != null) : "pe must not be null";
        this.elements.add(pe);
        pe.setParentNode(this);
    }

    public Set<String> getTargetNames() {
        LinkedHashSet<String> targetNames = new LinkedHashSet<String>(this.elements.size());
        for (ProjectionElem pe : this.elements) {
            targetNames.add(pe.getTargetName());
        }
        return targetNames;
    }

    @Override
    public <X extends Exception> void visit(QueryModelVisitor<X> visitor) throws X {
        visitor.meet(this);
    }

    @Override
    public <X extends Exception> void visitChildren(QueryModelVisitor<X> visitor) throws X {
        for (ProjectionElem pe : this.elements) {
            pe.visit(visitor);
        }
        super.visitChildren(visitor);
    }

    @Override
    public void replaceChildNode(QueryModelNode current, QueryModelNode replacement) {
        int index = this.elements.indexOf(current);
        if (index >= 0) {
            this.elements.set(index, (ProjectionElem)replacement);
            replacement.setParentNode(this);
        } else {
            super.replaceChildNode(current, replacement);
        }
    }

    @Override
    public ProjectionElemList clone() {
        ProjectionElemList clone = (ProjectionElemList)super.clone();
        ArrayList<ProjectionElem> elementsClone = new ArrayList<ProjectionElem>(this.getElements().size());
        for (ProjectionElem pe : this.getElements()) {
            elementsClone.add(pe.clone());
        }
        clone.setElements(elementsClone);
        return clone;
    }
}

