/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/*
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

package org.opensearch.client.opensearch.core;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

// typedef: _global.clear_scroll.Response

@JsonpDeserializable
public class ClearScrollResponse implements PlainJsonSerializable {
    private final boolean succeeded;

    private final int numFreed;

    // ---------------------------------------------------------------------------------------------

    private ClearScrollResponse(Builder builder) {

        this.succeeded = ApiTypeHelper.requireNonNull(builder.succeeded, this, "succeeded");
        this.numFreed = ApiTypeHelper.requireNonNull(builder.numFreed, this, "numFreed");

    }

    public static ClearScrollResponse of(Function<Builder, ObjectBuilder<ClearScrollResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    /**
     * Required - API name: {@code succeeded}
     */
    public final boolean succeeded() {
        return this.succeeded;
    }

    /**
     * Required - API name: {@code num_freed}
     */
    public final int numFreed() {
        return this.numFreed;
    }

    /**
     * Serialize this object to JSON.
     */
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {

        generator.writeKey("succeeded");
        generator.write(this.succeeded);

        generator.writeKey("num_freed");
        generator.write(this.numFreed);

    }

    // ---------------------------------------------------------------------------------------------

    /**
     * Builder for {@link ClearScrollResponse}.
     */

    public static class Builder extends ObjectBuilderBase implements ObjectBuilder<ClearScrollResponse> {
        private Boolean succeeded;

        private Integer numFreed;

        /**
         * Required - API name: {@code succeeded}
         */
        public final Builder succeeded(boolean value) {
            this.succeeded = value;
            return this;
        }

        /**
         * Required - API name: {@code num_freed}
         */
        public final Builder numFreed(int value) {
            this.numFreed = value;
            return this;
        }

        /**
         * Builds a {@link ClearScrollResponse}.
         *
         * @throws NullPointerException
         *             if some of the required fields are null.
         */
        public ClearScrollResponse build() {
            _checkSingleUse();

            return new ClearScrollResponse(this);
        }
    }

    // ---------------------------------------------------------------------------------------------

    /**
     * Json deserializer for {@link ClearScrollResponse}
     */
    public static final JsonpDeserializer<ClearScrollResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(
        Builder::new,
        ClearScrollResponse::setupClearScrollResponseDeserializer
    );

    protected static void setupClearScrollResponseDeserializer(ObjectDeserializer<ClearScrollResponse.Builder> op) {

        op.add(Builder::succeeded, JsonpDeserializer.booleanDeserializer(), "succeeded");
        op.add(Builder::numFreed, JsonpDeserializer.integerDeserializer(), "num_freed");

    }

}
