/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/*
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

package org.opensearch.client.opensearch.indices.shard_stores;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

// typedef: indices.shard_stores.ShardStoreException

@JsonpDeserializable
public class ShardStoreException implements PlainJsonSerializable {
    private final String reason;

    private final String type;

    // ---------------------------------------------------------------------------------------------

    private ShardStoreException(Builder builder) {

        this.reason = ApiTypeHelper.requireNonNull(builder.reason, this, "reason");
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");

    }

    public static ShardStoreException of(Function<Builder, ObjectBuilder<ShardStoreException>> fn) {
        return fn.apply(new Builder()).build();
    }

    /**
     * Required - API name: {@code reason}
     */
    public final String reason() {
        return this.reason;
    }

    /**
     * Required - API name: {@code type}
     */
    public final String type() {
        return this.type;
    }

    /**
     * Serialize this object to JSON.
     */
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {

        generator.writeKey("reason");
        generator.write(this.reason);

        generator.writeKey("type");
        generator.write(this.type);

    }

    // ---------------------------------------------------------------------------------------------

    /**
     * Builder for {@link ShardStoreException}.
     */

    public static class Builder extends ObjectBuilderBase implements ObjectBuilder<ShardStoreException> {
        private String reason;

        private String type;

        /**
         * Required - API name: {@code reason}
         */
        public final Builder reason(String value) {
            this.reason = value;
            return this;
        }

        /**
         * Required - API name: {@code type}
         */
        public final Builder type(String value) {
            this.type = value;
            return this;
        }

        /**
         * Builds a {@link ShardStoreException}.
         *
         * @throws NullPointerException
         *             if some of the required fields are null.
         */
        public ShardStoreException build() {
            _checkSingleUse();

            return new ShardStoreException(this);
        }
    }

    // ---------------------------------------------------------------------------------------------

    /**
     * Json deserializer for {@link ShardStoreException}
     */
    public static final JsonpDeserializer<ShardStoreException> _DESERIALIZER = ObjectBuilderDeserializer.lazy(
        Builder::new,
        ShardStoreException::setupShardStoreExceptionDeserializer
    );

    protected static void setupShardStoreExceptionDeserializer(ObjectDeserializer<ShardStoreException.Builder> op) {

        op.add(Builder::reason, JsonpDeserializer.stringDeserializer(), "reason");
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type");

    }

}
