/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBase;
import org.opensearch.client.opensearch._types.query_dsl.QueryVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.MissingRequiredPropertiesException;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class NeuralQuery
extends QueryBase
implements QueryVariant {
    private final String field;
    private final String queryText;
    private final String queryImage;
    private final int k;
    @Nullable
    private final String modelId;
    @Nullable
    private final Query filter;
    public static final JsonpDeserializer<NeuralQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NeuralQuery::setupNeuralQueryDeserializer);

    private NeuralQuery(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        if (builder.queryText == null && builder.queryImage == null && !ApiTypeHelper.requiredPropertiesCheckDisabled()) {
            throw new MissingRequiredPropertiesException(this, "queryText", "queryImage");
        }
        this.queryText = builder.queryText;
        this.queryImage = builder.queryImage;
        this.k = ApiTypeHelper.requireNonNull(builder.k, this, "k");
        this.modelId = builder.modelId;
        this.filter = builder.filter;
    }

    public static NeuralQuery of(Function<Builder, ObjectBuilder<NeuralQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.Neural;
    }

    public final String field() {
        return this.field;
    }

    public final String queryText() {
        return this.queryText;
    }

    public final String queryImage() {
        return this.queryImage;
    }

    public final int k() {
        return this.k;
    }

    @Nullable
    public final String modelId() {
        return this.modelId;
    }

    @Nullable
    public final Query filter() {
        return this.filter;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject(this.field);
        super.serializeInternal(generator, mapper);
        if (this.queryText != null) {
            generator.write("query_text", this.queryText);
        }
        if (this.queryImage != null) {
            generator.write("query_image", this.queryImage);
        }
        if (this.modelId != null) {
            generator.write("model_id", this.modelId);
        }
        generator.write("k", this.k);
        if (this.filter != null) {
            generator.writeKey("filter");
            this.filter.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    public Builder toBuilder() {
        return this.toBuilder(new Builder()).field(this.field).queryText(this.queryText).queryImage(this.queryImage).k(this.k).modelId(this.modelId).filter(this.filter);
    }

    protected static void setupNeuralQueryDeserializer(ObjectDeserializer<Builder> op) {
        NeuralQuery.setupQueryBaseDeserializer(op);
        op.add(Builder::queryText, JsonpDeserializer.stringDeserializer(), "query_text");
        op.add(Builder::queryImage, JsonpDeserializer.stringDeserializer(), "query_image");
        op.add(Builder::modelId, JsonpDeserializer.stringDeserializer(), "model_id");
        op.add(Builder::k, JsonpDeserializer.integerDeserializer(), "k");
        op.add(Builder::filter, Query._DESERIALIZER, "filter");
        op.setKey(Builder::field, JsonpDeserializer.stringDeserializer());
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<NeuralQuery> {
        private String field;
        private String queryText;
        private String queryImage;
        private Integer k;
        @Nullable
        private String modelId;
        @Nullable
        private Query filter;

        public Builder field(@Nullable String field) {
            this.field = field;
            return this;
        }

        public Builder queryText(@Nullable String queryText) {
            this.queryText = queryText;
            return this;
        }

        public Builder queryImage(@Nullable String queryImage) {
            this.queryImage = queryImage;
            return this;
        }

        public Builder modelId(@Nullable String modelId) {
            this.modelId = modelId;
            return this;
        }

        public Builder k(@Nullable Integer k) {
            this.k = k;
            return this;
        }

        public Builder filter(@Nullable Query filter) {
            this.filter = filter;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public NeuralQuery build() {
            this._checkSingleUse();
            return new NeuralQuery(this);
        }
    }
}

