/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.FieldMemoryUsage;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class FielddataStats
implements JsonpSerializable {
    @Nullable
    private final Long evictions;
    @Nullable
    private final String memorySize;
    private final long memorySizeInBytes;
    private final Map<String, FieldMemoryUsage> fields;
    public static final JsonpDeserializer<FielddataStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FielddataStats::setupFielddataStatsDeserializer);

    private FielddataStats(Builder builder) {
        this.evictions = builder.evictions;
        this.memorySize = builder.memorySize;
        this.memorySizeInBytes = ApiTypeHelper.requireNonNull(builder.memorySizeInBytes, this, "memorySizeInBytes");
        this.fields = ApiTypeHelper.unmodifiable(builder.fields);
    }

    public static FielddataStats of(Function<Builder, ObjectBuilder<FielddataStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Long evictions() {
        return this.evictions;
    }

    @Nullable
    public final String memorySize() {
        return this.memorySize;
    }

    public final long memorySizeInBytes() {
        return this.memorySizeInBytes;
    }

    public final Map<String, FieldMemoryUsage> fields() {
        return this.fields;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.evictions != null) {
            generator.writeKey("evictions");
            generator.write(this.evictions.longValue());
        }
        if (this.memorySize != null) {
            generator.writeKey("memory_size");
            generator.write(this.memorySize);
        }
        generator.writeKey("memory_size_in_bytes");
        generator.write(this.memorySizeInBytes);
        if (ApiTypeHelper.isDefined(this.fields)) {
            generator.writeKey("fields");
            generator.writeStartObject();
            for (Map.Entry<String, FieldMemoryUsage> item0 : this.fields.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupFielddataStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::evictions, JsonpDeserializer.longDeserializer(), "evictions");
        op.add(Builder::memorySize, JsonpDeserializer.stringDeserializer(), "memory_size");
        op.add(Builder::memorySizeInBytes, JsonpDeserializer.longDeserializer(), "memory_size_in_bytes");
        op.add(Builder::fields, JsonpDeserializer.stringMapDeserializer(FieldMemoryUsage._DESERIALIZER), "fields");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<FielddataStats> {
        @Nullable
        private Long evictions;
        @Nullable
        private String memorySize;
        private Long memorySizeInBytes;
        @Nullable
        private Map<String, FieldMemoryUsage> fields;

        public final Builder evictions(@Nullable Long value) {
            this.evictions = value;
            return this;
        }

        public final Builder memorySize(@Nullable String value) {
            this.memorySize = value;
            return this;
        }

        public final Builder memorySizeInBytes(long value) {
            this.memorySizeInBytes = value;
            return this;
        }

        public final Builder fields(Map<String, FieldMemoryUsage> map) {
            this.fields = Builder._mapPutAll(this.fields, map);
            return this;
        }

        public final Builder fields(String key, FieldMemoryUsage value) {
            this.fields = Builder._mapPut(this.fields, key, value);
            return this;
        }

        public final Builder fields(String key, Function<FieldMemoryUsage.Builder, ObjectBuilder<FieldMemoryUsage>> fn) {
            return this.fields(key, fn.apply(new FieldMemoryUsage.Builder()).build());
        }

        @Override
        public FielddataStats build() {
            this._checkSingleUse();
            return new FielddataStats(this);
        }
    }
}

