/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/*
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.util.ObjectBuilder;

// typedef: _types.aggregations.MedianAbsoluteDeviationAggregation

@JsonpDeserializable
public class MedianAbsoluteDeviationAggregation extends FormatMetricAggregationBase implements AggregationVariant {
    @Nullable
    private final Double compression;

    // ---------------------------------------------------------------------------------------------

    private MedianAbsoluteDeviationAggregation(Builder builder) {
        super(builder);

        this.compression = builder.compression;

    }

    public static MedianAbsoluteDeviationAggregation of(Function<Builder, ObjectBuilder<MedianAbsoluteDeviationAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    /**
     * Aggregation variant kind.
     */
    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.MedianAbsoluteDeviation;
    }

    /**
     * API name: {@code compression}
     */
    @Nullable
    public final Double compression() {
        return this.compression;
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {

        super.serializeInternal(generator, mapper);
        if (this.compression != null) {
            generator.writeKey("compression");
            generator.write(this.compression);

        }

    }

    // ---------------------------------------------------------------------------------------------

    /**
     * Builder for {@link MedianAbsoluteDeviationAggregation}.
     */

    public static class Builder extends FormatMetricAggregationBase.AbstractBuilder<Builder>
        implements
            ObjectBuilder<MedianAbsoluteDeviationAggregation> {
        @Nullable
        private Double compression;

        /**
         * API name: {@code compression}
         */
        public final Builder compression(@Nullable Double value) {
            this.compression = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        /**
         * Builds a {@link MedianAbsoluteDeviationAggregation}.
         *
         * @throws NullPointerException
         *             if some of the required fields are null.
         */
        public MedianAbsoluteDeviationAggregation build() {
            _checkSingleUse();

            return new MedianAbsoluteDeviationAggregation(this);
        }
    }

    // ---------------------------------------------------------------------------------------------

    /**
     * Json deserializer for {@link MedianAbsoluteDeviationAggregation}
     */
    public static final JsonpDeserializer<MedianAbsoluteDeviationAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(
        Builder::new,
        MedianAbsoluteDeviationAggregation::setupMedianAbsoluteDeviationAggregationDeserializer
    );

    protected static void setupMedianAbsoluteDeviationAggregationDeserializer(
        ObjectDeserializer<MedianAbsoluteDeviationAggregation.Builder> op
    ) {
        setupFormatMetricAggregationBaseDeserializer(op);
        op.add(Builder::compression, JsonpDeserializer.doubleDeserializer(), "compression");

    }

}
