/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core;

import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.JsonpSerializer;
import org.opensearch.client.json.JsonpUtils;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.OpType;
import org.opensearch.client.opensearch._types.Refresh;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch._types.VersionType;
import org.opensearch.client.opensearch._types.WaitForActiveShards;
import org.opensearch.client.opensearch.core.IndexResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

public class IndexRequest<TDocument>
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final String id;
    @Nullable
    private final Long ifPrimaryTerm;
    @Nullable
    private final Long ifSeqNo;
    private final String index;
    @Nullable
    private final OpType opType;
    @Nullable
    private final String pipeline;
    @Nullable
    private final Refresh refresh;
    @Nullable
    private final Boolean requireAlias;
    @Nullable
    private final String routing;
    @Nullable
    private final Time timeout;
    @Nullable
    private final Long version;
    @Nullable
    private final VersionType versionType;
    @Nullable
    private final WaitForActiveShards waitForActiveShards;
    private final TDocument document;
    @Nullable
    private final JsonpSerializer<TDocument> tDocumentSerializer;
    public static final Endpoint<IndexRequest<?>, IndexResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<IndexRequest, IndexResponse>(request -> {
        boolean _index = true;
        int _id = 2;
        int propsSet = 0;
        propsSet |= 1;
        if (request.id() != null) {
            propsSet |= 2;
        }
        if (propsSet == 3) {
            return "PUT";
        }
        if (propsSet == 1) {
            return "POST";
        }
        throw SimpleEndpoint.noPathTemplateFound("method");
    }, request -> {
        boolean _index = true;
        int _id = 2;
        int propsSet = 0;
        propsSet |= 1;
        if (request.id() != null) {
            propsSet |= 2;
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/_doc");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            return buf.toString();
        }
        if (propsSet == 1) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/_doc");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.pipeline != null) {
            params.put("pipeline", request.pipeline);
        }
        if (request.routing != null) {
            params.put("routing", request.routing);
        }
        if (request.requireAlias != null) {
            params.put("require_alias", String.valueOf(request.requireAlias));
        }
        if (request.versionType != null) {
            params.put("version_type", request.versionType.jsonValue());
        }
        if (request.ifPrimaryTerm != null) {
            params.put("if_primary_term", String.valueOf(request.ifPrimaryTerm));
        }
        if (request.ifSeqNo != null) {
            params.put("if_seq_no", String.valueOf(request.ifSeqNo));
        }
        if (request.refresh != null) {
            params.put("refresh", request.refresh.jsonValue());
        }
        if (request.waitForActiveShards != null) {
            params.put("wait_for_active_shards", request.waitForActiveShards._toJsonString());
        }
        if (request.opType != null) {
            params.put("op_type", request.opType.jsonValue());
        }
        if (request.version != null) {
            params.put("version", String.valueOf(request.version));
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, IndexResponse._DESERIALIZER);

    private IndexRequest(Builder<TDocument> builder) {
        this.id = builder.id;
        this.ifPrimaryTerm = builder.ifPrimaryTerm;
        this.ifSeqNo = builder.ifSeqNo;
        this.index = ApiTypeHelper.requireNonNull(builder.index, this, "index");
        this.opType = builder.opType;
        this.pipeline = builder.pipeline;
        this.refresh = builder.refresh;
        this.requireAlias = builder.requireAlias;
        this.routing = builder.routing;
        this.timeout = builder.timeout;
        this.version = builder.version;
        this.versionType = builder.versionType;
        this.waitForActiveShards = builder.waitForActiveShards;
        this.document = ApiTypeHelper.requireNonNull(builder.document, this, "document");
        this.tDocumentSerializer = builder.tDocumentSerializer;
    }

    public static <TDocument> IndexRequest<TDocument> of(Function<Builder<TDocument>, ObjectBuilder<IndexRequest<TDocument>>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String id() {
        return this.id;
    }

    @Nullable
    public final Long ifPrimaryTerm() {
        return this.ifPrimaryTerm;
    }

    @Nullable
    public final Long ifSeqNo() {
        return this.ifSeqNo;
    }

    public final String index() {
        return this.index;
    }

    @Nullable
    public final OpType opType() {
        return this.opType;
    }

    @Nullable
    public final String pipeline() {
        return this.pipeline;
    }

    @Nullable
    public final Refresh refresh() {
        return this.refresh;
    }

    @Nullable
    public final Boolean requireAlias() {
        return this.requireAlias;
    }

    @Nullable
    public final String routing() {
        return this.routing;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Nullable
    public final Long version() {
        return this.version;
    }

    @Nullable
    public final VersionType versionType() {
        return this.versionType;
    }

    @Nullable
    public final WaitForActiveShards waitForActiveShards() {
        return this.waitForActiveShards;
    }

    public final TDocument document() {
        return this.document;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        JsonpUtils.serialize(this.document, generator, this.tDocumentSerializer, mapper);
    }

    public Builder<TDocument> toBuilder() {
        return new Builder().id(this.id).ifPrimaryTerm(this.ifPrimaryTerm).ifSeqNo(this.ifSeqNo).index(this.index).opType(this.opType).pipeline(this.pipeline).refresh(this.refresh).requireAlias(this.requireAlias).routing(this.routing).timeout(this.timeout).version(this.version).versionType(this.versionType).waitForActiveShards(this.waitForActiveShards).document(this.document).tDocumentSerializer(this.tDocumentSerializer);
    }

    public static <TDocument> JsonpDeserializer<IndexRequest<TDocument>> createIndexRequestDeserializer(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        JsonpDeserializer valueDeserializer = tDocumentDeserializer;
        return JsonpDeserializer.of(valueDeserializer.acceptedEvents(), (parser, mapper) -> new Builder().document(valueDeserializer.deserialize((JsonParser)parser, (JsonpMapper)mapper)).build());
    }

    public static class Builder<TDocument>
    extends ObjectBuilderBase
    implements ObjectBuilder<IndexRequest<TDocument>> {
        @Nullable
        private String id;
        @Nullable
        private Long ifPrimaryTerm;
        @Nullable
        private Long ifSeqNo;
        private String index;
        @Nullable
        private OpType opType;
        @Nullable
        private String pipeline;
        @Nullable
        private Refresh refresh;
        @Nullable
        private Boolean requireAlias;
        @Nullable
        private String routing;
        @Nullable
        private Time timeout;
        @Nullable
        private Long version;
        @Nullable
        private VersionType versionType;
        @Nullable
        private WaitForActiveShards waitForActiveShards;
        private TDocument document;
        @Nullable
        private JsonpSerializer<TDocument> tDocumentSerializer;

        public final Builder<TDocument> id(@Nullable String value) {
            this.id = value;
            return this;
        }

        public final Builder<TDocument> ifPrimaryTerm(@Nullable Long value) {
            this.ifPrimaryTerm = value;
            return this;
        }

        public final Builder<TDocument> ifSeqNo(@Nullable Long value) {
            this.ifSeqNo = value;
            return this;
        }

        public final Builder<TDocument> index(String value) {
            this.index = value;
            return this;
        }

        public final Builder<TDocument> opType(@Nullable OpType value) {
            this.opType = value;
            return this;
        }

        public final Builder<TDocument> pipeline(@Nullable String value) {
            this.pipeline = value;
            return this;
        }

        public final Builder<TDocument> refresh(@Nullable Refresh value) {
            this.refresh = value;
            return this;
        }

        public final Builder<TDocument> requireAlias(@Nullable Boolean value) {
            this.requireAlias = value;
            return this;
        }

        public final Builder<TDocument> routing(@Nullable String value) {
            this.routing = value;
            return this;
        }

        public final Builder<TDocument> timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder<TDocument> timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder<TDocument> version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        public final Builder<TDocument> versionType(@Nullable VersionType value) {
            this.versionType = value;
            return this;
        }

        public final Builder<TDocument> waitForActiveShards(@Nullable WaitForActiveShards value) {
            this.waitForActiveShards = value;
            return this;
        }

        public final Builder<TDocument> waitForActiveShards(Function<WaitForActiveShards.Builder, ObjectBuilder<WaitForActiveShards>> fn) {
            return this.waitForActiveShards(fn.apply(new WaitForActiveShards.Builder()).build());
        }

        public final Builder<TDocument> document(TDocument value) {
            this.document = value;
            return this;
        }

        public final Builder<TDocument> tDocumentSerializer(@Nullable JsonpSerializer<TDocument> value) {
            this.tDocumentSerializer = value;
            return this;
        }

        @Override
        public IndexRequest<TDocument> build() {
            this._checkSingleUse();
            return new IndexRequest(this);
        }
    }
}

