/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ingest;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch.ingest.InferenceConfig;
import org.opensearch.client.opensearch.ingest.Processor;
import org.opensearch.client.opensearch.ingest.ProcessorBase;
import org.opensearch.client.opensearch.ingest.ProcessorVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class InferenceProcessor
extends ProcessorBase
implements ProcessorVariant {
    private final String modelId;
    private final String targetField;
    private final Map<String, JsonData> fieldMap;
    @Nullable
    private final InferenceConfig inferenceConfig;
    public static final JsonpDeserializer<InferenceProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, InferenceProcessor::setupInferenceProcessorDeserializer);

    private InferenceProcessor(Builder builder) {
        super(builder);
        this.modelId = ApiTypeHelper.requireNonNull(builder.modelId, this, "modelId");
        this.targetField = ApiTypeHelper.requireNonNull(builder.targetField, this, "targetField");
        this.fieldMap = ApiTypeHelper.unmodifiable(builder.fieldMap);
        this.inferenceConfig = builder.inferenceConfig;
    }

    public static InferenceProcessor of(Function<Builder, ObjectBuilder<InferenceProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Processor.Kind _processorKind() {
        return Processor.Kind.Inference;
    }

    public final String modelId() {
        return this.modelId;
    }

    public final String targetField() {
        return this.targetField;
    }

    public final Map<String, JsonData> fieldMap() {
        return this.fieldMap;
    }

    @Nullable
    public final InferenceConfig inferenceConfig() {
        return this.inferenceConfig;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("model_id");
        generator.write(this.modelId);
        generator.writeKey("target_field");
        generator.write(this.targetField);
        if (ApiTypeHelper.isDefined(this.fieldMap)) {
            generator.writeKey("field_map");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.fieldMap.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.inferenceConfig != null) {
            generator.writeKey("inference_config");
            this.inferenceConfig.serialize(generator, mapper);
        }
    }

    protected static void setupInferenceProcessorDeserializer(ObjectDeserializer<Builder> op) {
        ProcessorBase.setupProcessorBaseDeserializer(op);
        op.add(Builder::modelId, JsonpDeserializer.stringDeserializer(), "model_id");
        op.add(Builder::targetField, JsonpDeserializer.stringDeserializer(), "target_field");
        op.add(Builder::fieldMap, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "field_map");
        op.add(Builder::inferenceConfig, InferenceConfig._DESERIALIZER, "inference_config");
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<InferenceProcessor> {
        private String modelId;
        private String targetField;
        @Nullable
        private Map<String, JsonData> fieldMap;
        @Nullable
        private InferenceConfig inferenceConfig;

        public final Builder modelId(String value) {
            this.modelId = value;
            return this;
        }

        public final Builder targetField(String value) {
            this.targetField = value;
            return this;
        }

        public final Builder fieldMap(Map<String, JsonData> map) {
            this.fieldMap = Builder._mapPutAll(this.fieldMap, map);
            return this;
        }

        public final Builder fieldMap(String key, JsonData value) {
            this.fieldMap = Builder._mapPut(this.fieldMap, key, value);
            return this;
        }

        public final Builder inferenceConfig(@Nullable InferenceConfig value) {
            this.inferenceConfig = value;
            return this;
        }

        public final Builder inferenceConfig(Function<InferenceConfig.Builder, ObjectBuilder<InferenceConfig>> fn) {
            return this.inferenceConfig(fn.apply(new InferenceConfig.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public InferenceProcessor build() {
            this._checkSingleUse();
            return new InferenceProcessor(this);
        }
    }
}

