/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client;

import java.io.IOException;
import org.opensearch.action.admin.cluster.health.ClusterHealthRequest;
import org.opensearch.action.admin.cluster.settings.ClusterGetSettingsRequest;
import org.opensearch.action.admin.cluster.settings.ClusterUpdateSettingsRequest;
import org.opensearch.action.support.ActiveShardCount;
import org.opensearch.client.Request;
import org.opensearch.client.RequestConverters;
import org.opensearch.client.cluster.RemoteInfoRequest;
import org.opensearch.client.indices.ComponentTemplatesExistRequest;
import org.opensearch.client.indices.DeleteComponentTemplateRequest;
import org.opensearch.client.indices.GetComponentTemplatesRequest;
import org.opensearch.client.indices.PutComponentTemplateRequest;
import org.opensearch.common.Strings;
import org.opensearch.core.xcontent.ToXContent;

final class ClusterRequestConverters {
    private ClusterRequestConverters() {
    }

    static Request clusterPutSettings(ClusterUpdateSettingsRequest clusterUpdateSettingsRequest) throws IOException {
        Request request = new Request("PUT", "/_cluster/settings");
        RequestConverters.Params parameters = new RequestConverters.Params();
        parameters.withTimeout(clusterUpdateSettingsRequest.timeout());
        parameters.withMasterTimeout(clusterUpdateSettingsRequest.clusterManagerNodeTimeout());
        request.addParameters(parameters.asMap());
        request.setEntity(RequestConverters.createEntity((ToXContent)clusterUpdateSettingsRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request clusterGetSettings(ClusterGetSettingsRequest clusterGetSettingsRequest) throws IOException {
        Request request = new Request("GET", "/_cluster/settings");
        RequestConverters.Params parameters = new RequestConverters.Params();
        parameters.withLocal(clusterGetSettingsRequest.local());
        parameters.withIncludeDefaults(clusterGetSettingsRequest.includeDefaults());
        parameters.withMasterTimeout(clusterGetSettingsRequest.clusterManagerNodeTimeout());
        request.addParameters(parameters.asMap());
        return request;
    }

    static Request clusterHealth(ClusterHealthRequest healthRequest) {
        String[] indices = healthRequest.indices() == null ? Strings.EMPTY_ARRAY : healthRequest.indices();
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_cluster/health").addCommaSeparatedPathParts(indices).build();
        Request request = new Request("GET", endpoint);
        RequestConverters.Params params = new RequestConverters.Params().withWaitForStatus(healthRequest.waitForStatus()).withWaitForNoRelocatingShards(healthRequest.waitForNoRelocatingShards()).withWaitForNoInitializingShards(healthRequest.waitForNoInitializingShards()).withWaitForActiveShards(healthRequest.waitForActiveShards(), ActiveShardCount.NONE).withWaitForNodes(healthRequest.waitForNodes()).withWaitForEvents(healthRequest.waitForEvents()).withTimeout(healthRequest.timeout()).withMasterTimeout(healthRequest.clusterManagerNodeTimeout()).withLocal(healthRequest.local()).withLevel(healthRequest.level());
        request.addParameters(params.asMap());
        return request;
    }

    static Request remoteInfo(RemoteInfoRequest remoteInfoRequest) {
        return new Request("GET", "/_remote/info");
    }

    static Request putComponentTemplate(PutComponentTemplateRequest putComponentTemplateRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_component_template").addPathPart(putComponentTemplateRequest.name()).build();
        Request request = new Request("PUT", endpoint);
        RequestConverters.Params params = new RequestConverters.Params();
        params.withMasterTimeout(putComponentTemplateRequest.clusterManagerNodeTimeout());
        if (putComponentTemplateRequest.create()) {
            params.putParam("create", Boolean.TRUE.toString());
        }
        if (Strings.hasText((String)putComponentTemplateRequest.cause())) {
            params.putParam("cause", putComponentTemplateRequest.cause());
        }
        request.addParameters(params.asMap());
        request.setEntity(RequestConverters.createEntity((ToXContent)putComponentTemplateRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request getComponentTemplates(GetComponentTemplatesRequest getComponentTemplatesRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_component_template").addPathPart(getComponentTemplatesRequest.name()).build();
        Request request = new Request("GET", endpoint);
        RequestConverters.Params params = new RequestConverters.Params();
        params.withLocal(getComponentTemplatesRequest.isLocal());
        params.withMasterTimeout(getComponentTemplatesRequest.getMasterNodeTimeout());
        request.addParameters(params.asMap());
        return request;
    }

    static Request componentTemplatesExist(ComponentTemplatesExistRequest componentTemplatesRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_component_template").addPathPart(componentTemplatesRequest.name()).build();
        Request request = new Request("HEAD", endpoint);
        RequestConverters.Params params = new RequestConverters.Params();
        params.withLocal(componentTemplatesRequest.isLocal());
        params.withMasterTimeout(componentTemplatesRequest.getMasterNodeTimeout());
        request.addParameters(params.asMap());
        return request;
    }

    static Request deleteComponentTemplate(DeleteComponentTemplateRequest deleteComponentTemplateRequest) {
        String name = deleteComponentTemplateRequest.getName();
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_component_template").addPathPart(name).build();
        Request request = new Request("DELETE", endpoint);
        RequestConverters.Params params = new RequestConverters.Params();
        params.withMasterTimeout(deleteComponentTemplateRequest.clusterManagerNodeTimeout());
        request.addParameters(params.asMap());
        return request;
    }
}

