/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.loader;

import java.io.File;
import javax.xml.bind.annotation.XmlTransient;
import org.optaplanner.benchmark.impl.loader.ProblemProvider;
import org.optaplanner.benchmark.impl.result.SubSingleBenchmarkResult;
import org.optaplanner.persistence.common.api.domain.solution.SolutionFileIO;

public class FileProblemProvider<Solution_>
implements ProblemProvider<Solution_> {
    @XmlTransient
    private SolutionFileIO<Solution_> solutionFileIO;
    private File problemFile;

    private FileProblemProvider() {
    }

    public FileProblemProvider(SolutionFileIO<Solution_> solutionFileIO, File problemFile) {
        this.solutionFileIO = solutionFileIO;
        this.problemFile = problemFile;
    }

    public SolutionFileIO<Solution_> getSolutionFileIO() {
        return this.solutionFileIO;
    }

    public File getProblemFile() {
        return this.problemFile;
    }

    @Override
    public String getProblemName() {
        String name = this.problemFile.getName();
        int lastDotIndex = name.lastIndexOf(46);
        if (lastDotIndex > 0) {
            return name.substring(0, lastDotIndex);
        }
        return name;
    }

    @Override
    public Solution_ readProblem() {
        return (Solution_)this.solutionFileIO.read(this.problemFile);
    }

    @Override
    public void writeSolution(Solution_ solution, SubSingleBenchmarkResult subSingleBenchmarkResult) {
        String filename = subSingleBenchmarkResult.getSingleBenchmarkResult().getProblemBenchmarkResult().getName() + "." + this.solutionFileIO.getOutputFileExtension();
        File solutionFile = new File(subSingleBenchmarkResult.getResultDirectory(), filename);
        this.solutionFileIO.write(solution, solutionFile);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof FileProblemProvider) {
            FileProblemProvider other = (FileProblemProvider)o;
            return this.problemFile.equals(other.problemFile);
        }
        return false;
    }

    public int hashCode() {
        return this.problemFile.hashCode();
    }

    public String toString() {
        return this.problemFile.toString();
    }
}

