/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.common;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.function.Function;
import java.util.function.Supplier;
import org.optaplanner.constraint.streams.bavet.common.AbstractGroup;
import org.optaplanner.constraint.streams.bavet.common.AbstractNode;
import org.optaplanner.constraint.streams.bavet.common.BavetTupleState;
import org.optaplanner.constraint.streams.bavet.common.GroupWithAccumulate;
import org.optaplanner.constraint.streams.bavet.common.GroupWithoutAccumulate;
import org.optaplanner.constraint.streams.bavet.common.Tuple;
import org.optaplanner.constraint.streams.bavet.common.TupleLifecycle;
import org.optaplanner.core.config.solver.EnvironmentMode;

public abstract class AbstractGroupNode<InTuple_ extends Tuple, OutTuple_ extends Tuple, MutableOutTuple_ extends OutTuple_, GroupKey_, ResultContainer_, Result_>
extends AbstractNode
implements TupleLifecycle<InTuple_> {
    private final int groupStoreIndex;
    private final int undoStoreIndex;
    private final Function<InTuple_, GroupKey_> groupKeyFunction;
    private final Supplier<ResultContainer_> supplier;
    private final Function<ResultContainer_, Result_> finisher;
    private final boolean hasMultipleGroups;
    private final boolean hasCollector;
    private final TupleLifecycle<OutTuple_> nextNodesTupleLifecycle;
    private final Map<Object, AbstractGroup<MutableOutTuple_, ResultContainer_>> groupMap;
    private AbstractGroup<MutableOutTuple_, ResultContainer_> singletonGroup;
    private final Queue<AbstractGroup<MutableOutTuple_, ResultContainer_>> dirtyGroupQueue;
    private final boolean useAssertingGroupKey;

    protected AbstractGroupNode(int groupStoreIndex, int undoStoreIndex, Function<InTuple_, GroupKey_> groupKeyFunction, Supplier<ResultContainer_> supplier, Function<ResultContainer_, Result_> finisher, TupleLifecycle<OutTuple_> nextNodesTupleLifecycle, EnvironmentMode environmentMode) {
        this.groupStoreIndex = groupStoreIndex;
        this.undoStoreIndex = undoStoreIndex;
        this.groupKeyFunction = groupKeyFunction;
        this.supplier = supplier;
        this.finisher = finisher;
        this.hasMultipleGroups = groupKeyFunction != null;
        this.hasCollector = supplier != null;
        this.nextNodesTupleLifecycle = nextNodesTupleLifecycle;
        this.groupMap = this.hasMultipleGroups ? new HashMap() : null;
        this.dirtyGroupQueue = new ArrayDeque<AbstractGroup<MutableOutTuple_, ResultContainer_>>();
        this.useAssertingGroupKey = environmentMode.isAsserted();
    }

    protected AbstractGroupNode(int groupStoreIndex, Function<InTuple_, GroupKey_> groupKeyFunction, TupleLifecycle<OutTuple_> nextNodesTupleLifecycle, EnvironmentMode environmentMode) {
        this(groupStoreIndex, -1, groupKeyFunction, null, null, nextNodesTupleLifecycle, environmentMode);
    }

    @Override
    public void insert(InTuple_ tuple) {
        if (tuple.getStore(this.groupStoreIndex) != null) {
            throw new IllegalStateException("Impossible state: the input for the tuple (" + tuple + ") was already added in the tupleStore.");
        }
        GroupKey_ userSuppliedKey = this.hasMultipleGroups ? (GroupKey_)this.groupKeyFunction.apply(tuple) : null;
        this.createTuple(tuple, userSuppliedKey);
    }

    private void createTuple(InTuple_ tuple, GroupKey_ userSuppliedKey) {
        AbstractGroup<MutableOutTuple_, ResultContainer_> newGroup = this.getOrCreateGroup(userSuppliedKey);
        OutTuple_ outTuple = this.accumulate(tuple, newGroup);
        switch (outTuple.getState()) {
            case CREATING: 
            case UPDATING: {
                break;
            }
            case OK: {
                outTuple.setState(BavetTupleState.UPDATING);
                this.dirtyGroupQueue.add(newGroup);
                break;
            }
            case DYING: {
                outTuple.setState(BavetTupleState.UPDATING);
                break;
            }
            case ABORTING: {
                outTuple.setState(BavetTupleState.CREATING);
                break;
            }
            default: {
                throw new IllegalStateException("Impossible state: The group (" + newGroup + ") in node (" + this + ") is in an unexpected state (" + outTuple.getState() + ").");
            }
        }
    }

    private OutTuple_ accumulate(InTuple_ tuple, AbstractGroup<MutableOutTuple_, ResultContainer_> group) {
        if (this.hasCollector) {
            Runnable undoAccumulator = this.accumulate(group.getResultContainer(), tuple);
            tuple.setStore(this.undoStoreIndex, undoAccumulator);
        }
        tuple.setStore(this.groupStoreIndex, group);
        return group.outTuple;
    }

    private AbstractGroup<MutableOutTuple_, ResultContainer_> getOrCreateGroup(GroupKey_ userSuppliedKey) {
        Object groupMapKey;
        Object object = groupMapKey = this.useAssertingGroupKey ? new AssertingGroupKey(userSuppliedKey) : userSuppliedKey;
        if (this.hasMultipleGroups) {
            AbstractGroup<MutableOutTuple_, ResultContainer_> group = this.groupMap.get(groupMapKey);
            if (group == null) {
                group = this.createGroup(groupMapKey);
                this.groupMap.put(groupMapKey, group);
            } else {
                ++group.parentCount;
            }
            return group;
        }
        if (this.singletonGroup == null) {
            this.singletonGroup = this.createGroup(groupMapKey);
        } else {
            ++this.singletonGroup.parentCount;
        }
        return this.singletonGroup;
    }

    private AbstractGroup<MutableOutTuple_, ResultContainer_> createGroup(Object groupMapKey) {
        GroupKey_ userSuppliedKey = this.extractUserSuppliedKey(groupMapKey);
        MutableOutTuple_ outTuple = this.createOutTuple(userSuppliedKey);
        AbstractGroup group = this.hasCollector ? new GroupWithAccumulate<MutableOutTuple_, ResultContainer_>(groupMapKey, this.supplier.get(), outTuple) : new GroupWithoutAccumulate(groupMapKey, outTuple);
        this.dirtyGroupQueue.add(group);
        return group;
    }

    private GroupKey_ extractUserSuppliedKey(Object groupMapKey) {
        return (GroupKey_)(this.useAssertingGroupKey ? ((AssertingGroupKey)groupMapKey).getKey() : groupMapKey);
    }

    @Override
    public void update(InTuple_ tuple) {
        GroupKey_ newUserSuppliedGroupKey;
        AbstractGroup oldGroup = (AbstractGroup)tuple.getStore(this.groupStoreIndex);
        if (oldGroup == null) {
            this.insert(tuple);
            return;
        }
        if (this.hasCollector) {
            Runnable undoAccumulator = (Runnable)tuple.getStore(this.undoStoreIndex);
            undoAccumulator.run();
        }
        GroupKey_ oldUserSuppliedGroupKey = this.extractUserSuppliedKey(oldGroup.groupKey);
        GroupKey_ GroupKey_ = newUserSuppliedGroupKey = this.hasMultipleGroups ? (GroupKey_)this.groupKeyFunction.apply(tuple) : null;
        if (Objects.equals(newUserSuppliedGroupKey, oldUserSuppliedGroupKey)) {
            OutTuple_ outTuple = this.accumulate(tuple, oldGroup);
            switch (outTuple.getState()) {
                case CREATING: 
                case UPDATING: {
                    break;
                }
                case OK: {
                    outTuple.setState(BavetTupleState.UPDATING);
                    this.dirtyGroupQueue.add(oldGroup);
                    break;
                }
                default: {
                    throw new IllegalStateException("Impossible state: The group (" + oldGroup + ") in node (" + this + ") is in an unexpected state (" + outTuple.getState() + ").");
                }
            }
        } else {
            this.killTuple(oldGroup);
            this.createTuple(tuple, newUserSuppliedGroupKey);
        }
    }

    private void killTuple(AbstractGroup<MutableOutTuple_, ResultContainer_> group) {
        Object groupKey;
        AbstractGroup<MutableOutTuple_, ResultContainer_> old;
        int newParentCount;
        boolean killGroup;
        boolean bl = killGroup = (newParentCount = --group.parentCount) == 0;
        if (killGroup && (old = this.removeGroup(groupKey = group.groupKey)) == null) {
            throw new IllegalStateException("Impossible state: the group for the groupKey (" + groupKey + ") doesn't exist in the groupMap.\nMaybe groupKey hashcode changed while it shouldn't have?");
        }
        Object outTuple = group.outTuple;
        switch (outTuple.getState()) {
            case CREATING: {
                if (!killGroup) break;
                outTuple.setState(BavetTupleState.ABORTING);
                break;
            }
            case UPDATING: {
                if (!killGroup) break;
                outTuple.setState(BavetTupleState.DYING);
                break;
            }
            case OK: {
                outTuple.setState(killGroup ? BavetTupleState.DYING : BavetTupleState.UPDATING);
                this.dirtyGroupQueue.add(group);
                break;
            }
            default: {
                throw new IllegalStateException("Impossible state: The group (" + group + ") in node (" + this + ") is in an unexpected state (" + outTuple.getState() + ").");
            }
        }
    }

    private AbstractGroup<MutableOutTuple_, ResultContainer_> removeGroup(Object groupKey) {
        if (this.hasMultipleGroups) {
            return this.groupMap.remove(groupKey);
        }
        AbstractGroup<MutableOutTuple_, ResultContainer_> old = this.singletonGroup;
        this.singletonGroup = null;
        return old;
    }

    @Override
    public void retract(InTuple_ tuple) {
        AbstractGroup group = (AbstractGroup)tuple.removeStore(this.groupStoreIndex);
        if (group == null) {
            return;
        }
        if (this.hasCollector) {
            Runnable undoAccumulator = (Runnable)tuple.removeStore(this.undoStoreIndex);
            undoAccumulator.run();
        }
        this.killTuple(group);
    }

    protected abstract Runnable accumulate(ResultContainer_ var1, InTuple_ var2);

    @Override
    public void calculateScore() {
        block6: for (AbstractGroup abstractGroup : this.dirtyGroupQueue) {
            Object outTuple = abstractGroup.outTuple;
            switch (outTuple.getState()) {
                case CREATING: {
                    if (this.hasCollector) {
                        this.updateOutTupleToFinisher(outTuple, abstractGroup.getResultContainer());
                    }
                    this.nextNodesTupleLifecycle.insert(outTuple);
                    outTuple.setState(BavetTupleState.OK);
                    continue block6;
                }
                case UPDATING: {
                    if (this.hasCollector) {
                        this.updateOutTupleToFinisher(outTuple, abstractGroup.getResultContainer());
                    }
                    this.nextNodesTupleLifecycle.update(outTuple);
                    outTuple.setState(BavetTupleState.OK);
                    continue block6;
                }
                case DYING: {
                    this.nextNodesTupleLifecycle.retract(outTuple);
                    outTuple.setState(BavetTupleState.DEAD);
                    continue block6;
                }
                case ABORTING: {
                    outTuple.setState(BavetTupleState.DEAD);
                    continue block6;
                }
            }
            throw new IllegalStateException("Impossible state: The group (" + abstractGroup + ") in node (" + this + ") is in an unexpected state (" + outTuple.getState() + ").");
        }
        this.dirtyGroupQueue.clear();
    }

    protected abstract MutableOutTuple_ createOutTuple(GroupKey_ var1);

    private void updateOutTupleToFinisher(MutableOutTuple_ outTuple, ResultContainer_ resultContainer) {
        Result_ result = this.finisher.apply(resultContainer);
        this.updateOutTupleToResult(outTuple, result);
    }

    protected abstract void updateOutTupleToResult(MutableOutTuple_ var1, Result_ var2);

    private final class AssertingGroupKey {
        private final GroupKey_ key;
        private final int initialHashCode;

        public AssertingGroupKey(GroupKey_ key) {
            this.key = key;
            this.initialHashCode = key == null ? 0 : key.hashCode();
        }

        public GroupKey_ getKey() {
            if (this.key != null && this.key.hashCode() != this.initialHashCode) {
                throw new IllegalStateException("hashCode of object (" + this.key + ") of class (" + this.key.getClass() + ") has changed while it was being used as a group key within groupBy (" + AbstractGroupNode.this.getClass() + ").\nGroup key hashCode must consistently return the same integer, as required by the general hashCode contract.");
            }
            return this.key;
        }

        public boolean equals(Object other) {
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            return Objects.equals(this.getKey(), ((AssertingGroupKey)other).getKey());
        }

        public int hashCode() {
            Object key = this.getKey();
            return key == null ? 0 : key.hashCode();
        }
    }
}

