/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.common;

import java.util.ArrayDeque;
import java.util.Queue;
import org.optaplanner.constraint.streams.bavet.common.AbstractNode;
import org.optaplanner.constraint.streams.bavet.common.BavetTupleState;
import org.optaplanner.constraint.streams.bavet.common.Tuple;
import org.optaplanner.constraint.streams.bavet.common.TupleLifecycle;
import org.optaplanner.constraint.streams.bavet.uni.UniTuple;
import org.optaplanner.constraint.streams.bavet.uni.UniTupleImpl;

public abstract class AbstractMapNode<InTuple_ extends Tuple, Right_>
extends AbstractNode
implements TupleLifecycle<InTuple_> {
    private final int inputStoreIndex;
    private final TupleLifecycle<UniTuple<Right_>> nextNodesTupleLifecycle;
    private final int outputStoreSize;
    private final Queue<UniTuple<Right_>> dirtyTupleQueue;

    protected AbstractMapNode(int inputStoreIndex, TupleLifecycle<UniTuple<Right_>> nextNodesTupleLifecycle, int outputStoreSize) {
        this.inputStoreIndex = inputStoreIndex;
        this.nextNodesTupleLifecycle = nextNodesTupleLifecycle;
        this.outputStoreSize = outputStoreSize;
        this.dirtyTupleQueue = new ArrayDeque<UniTuple<Right_>>(1000);
    }

    @Override
    public void insert(InTuple_ tuple) {
        if (tuple.getStore(this.inputStoreIndex) != null) {
            throw new IllegalStateException("Impossible state: the input for the tuple (" + tuple + ") was already added in the tupleStore.");
        }
        Right_ mapped = this.map(tuple);
        UniTupleImpl<Right_> outTuple = new UniTupleImpl<Right_>(mapped, this.outputStoreSize);
        tuple.setStore(this.inputStoreIndex, outTuple);
        this.dirtyTupleQueue.add(outTuple);
    }

    protected abstract Right_ map(InTuple_ var1);

    @Override
    public void update(InTuple_ tuple) {
        UniTupleImpl outTuple = (UniTupleImpl)tuple.getStore(this.inputStoreIndex);
        if (outTuple == null) {
            this.insert(tuple);
            return;
        }
        Object oldMapped = outTuple.factA;
        Right_ mapped = this.map(tuple);
        if (mapped != oldMapped) {
            outTuple.factA = mapped;
            outTuple.state = BavetTupleState.UPDATING;
            this.dirtyTupleQueue.add(outTuple);
        }
    }

    @Override
    public void retract(InTuple_ tuple) {
        UniTuple outTuple = (UniTuple)tuple.removeStore(this.inputStoreIndex);
        if (outTuple == null) {
            return;
        }
        outTuple.setState(BavetTupleState.DYING);
        this.dirtyTupleQueue.add(outTuple);
    }

    @Override
    public void calculateScore() {
        block6: for (UniTuple uniTuple : this.dirtyTupleQueue) {
            switch (uniTuple.getState()) {
                case CREATING: {
                    this.nextNodesTupleLifecycle.insert(uniTuple);
                    uniTuple.setState(BavetTupleState.OK);
                    continue block6;
                }
                case UPDATING: {
                    this.nextNodesTupleLifecycle.update(uniTuple);
                    uniTuple.setState(BavetTupleState.OK);
                    continue block6;
                }
                case DYING: {
                    this.nextNodesTupleLifecycle.retract(uniTuple);
                    uniTuple.setState(BavetTupleState.DEAD);
                    continue block6;
                }
                case ABORTING: {
                    uniTuple.setState(BavetTupleState.DEAD);
                    continue block6;
                }
            }
            throw new IllegalStateException("Impossible state: The tuple (" + uniTuple + ") in node (" + this + ") is in an unexpected state (" + uniTuple.getState() + ").");
        }
        this.dirtyTupleQueue.clear();
    }
}

