/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.common;

import java.util.function.Function;
import org.optaplanner.constraint.streams.bavet.common.AbstractIfExistsNode;
import org.optaplanner.constraint.streams.bavet.common.ExistsCounter;
import org.optaplanner.constraint.streams.bavet.common.LeftTupleLifecycle;
import org.optaplanner.constraint.streams.bavet.common.RightTupleLifecycle;
import org.optaplanner.constraint.streams.bavet.common.Tuple;
import org.optaplanner.constraint.streams.bavet.common.TupleLifecycle;
import org.optaplanner.constraint.streams.bavet.common.collection.TupleList;
import org.optaplanner.constraint.streams.bavet.common.collection.TupleListEntry;
import org.optaplanner.constraint.streams.bavet.common.index.IndexProperties;
import org.optaplanner.constraint.streams.bavet.common.index.Indexer;
import org.optaplanner.constraint.streams.bavet.uni.UniTuple;

public abstract class AbstractIndexedIfExistsNode<LeftTuple_ extends Tuple, Right_>
extends AbstractIfExistsNode<LeftTuple_, Right_>
implements LeftTupleLifecycle<LeftTuple_>,
RightTupleLifecycle<UniTuple<Right_>> {
    private final Function<Right_, IndexProperties> mappingRight;
    private final int inputStoreIndexLeftProperties;
    private final int inputStoreIndexLeftCounterEntry;
    private final int inputStoreIndexRightProperties;
    private final int inputStoreIndexRightEntry;
    private final Indexer<ExistsCounter<LeftTuple_>> indexerLeft;
    private final Indexer<UniTuple<Right_>> indexerRight;

    protected AbstractIndexedIfExistsNode(boolean shouldExist, Function<Right_, IndexProperties> mappingRight, int inputStoreIndexLeftProperties, int inputStoreIndexLeftCounterEntry, int inputStoreIndexLeftTrackerList, int inputStoreIndexRightProperties, int inputStoreIndexRightEntry, int inputStoreIndexRightTrackerList, TupleLifecycle<LeftTuple_> nextNodesTupleLifecycle, Indexer<ExistsCounter<LeftTuple_>> indexerLeft, Indexer<UniTuple<Right_>> indexerRight, boolean isFiltering) {
        super(shouldExist, inputStoreIndexLeftTrackerList, inputStoreIndexRightTrackerList, nextNodesTupleLifecycle, isFiltering);
        this.mappingRight = mappingRight;
        this.inputStoreIndexLeftProperties = inputStoreIndexLeftProperties;
        this.inputStoreIndexLeftCounterEntry = inputStoreIndexLeftCounterEntry;
        this.inputStoreIndexRightProperties = inputStoreIndexRightProperties;
        this.inputStoreIndexRightEntry = inputStoreIndexRightEntry;
        this.indexerLeft = indexerLeft;
        this.indexerRight = indexerRight;
    }

    @Override
    public final void insertLeft(LeftTuple_ leftTuple) {
        if (leftTuple.getStore(this.inputStoreIndexLeftProperties) != null) {
            throw new IllegalStateException("Impossible state: the input for the tuple (" + leftTuple + ") was already added in the tupleStore.");
        }
        IndexProperties indexProperties = this.createIndexProperties(leftTuple);
        leftTuple.setStore(this.inputStoreIndexLeftProperties, indexProperties);
        ExistsCounter<LeftTuple_> counter = new ExistsCounter<LeftTuple_>(leftTuple);
        TupleListEntry<ExistsCounter<LeftTuple_>> counterEntry = this.indexerLeft.put(indexProperties, counter);
        leftTuple.setStore(this.inputStoreIndexLeftCounterEntry, counterEntry);
        if (!this.isFiltering) {
            counter.countRight = this.indexerRight.size(indexProperties);
        } else {
            TupleList leftTrackerList = new TupleList();
            this.indexerRight.forEach(indexProperties, rightTuple -> this.updateCounterFromLeft(leftTuple, rightTuple, counter, leftTrackerList));
            leftTuple.setStore(this.inputStoreIndexLeftTrackerList, leftTrackerList);
        }
        this.initCounterLeft(counter);
    }

    @Override
    public final void updateLeft(LeftTuple_ leftTuple) {
        IndexProperties oldIndexProperties = (IndexProperties)leftTuple.getStore(this.inputStoreIndexLeftProperties);
        if (oldIndexProperties == null) {
            this.insertLeft(leftTuple);
            return;
        }
        IndexProperties newIndexProperties = this.createIndexProperties(leftTuple);
        TupleListEntry<ExistsCounter> counterEntry = (TupleListEntry<ExistsCounter>)leftTuple.getStore(this.inputStoreIndexLeftCounterEntry);
        ExistsCounter counter = (ExistsCounter)counterEntry.getElement();
        if (oldIndexProperties.equals(newIndexProperties)) {
            if (!this.isFiltering) {
                this.updateUnchangedCounterLeft(counter);
            } else {
                TupleList leftTrackerList = (TupleList)leftTuple.getStore(this.inputStoreIndexLeftTrackerList);
                leftTrackerList.forEach(AbstractIfExistsNode.FilteringTracker::remove);
                counter.countRight = 0;
                this.indexerRight.forEach(oldIndexProperties, rightTuple -> this.updateCounterFromLeft(leftTuple, rightTuple, counter, leftTrackerList));
                this.updateCounterLeft(counter);
            }
        } else {
            this.updateIndexerLeft(oldIndexProperties, counterEntry, leftTuple);
            counter.countRight = 0;
            leftTuple.setStore(this.inputStoreIndexLeftProperties, newIndexProperties);
            counterEntry = this.indexerLeft.put(newIndexProperties, counter);
            leftTuple.setStore(this.inputStoreIndexLeftCounterEntry, counterEntry);
            if (!this.isFiltering) {
                counter.countRight = this.indexerRight.size(newIndexProperties);
            } else {
                TupleList leftTrackerList = new TupleList();
                this.indexerRight.forEach(newIndexProperties, rightTuple -> this.updateCounterFromLeft(leftTuple, rightTuple, counter, leftTrackerList));
                leftTuple.setStore(this.inputStoreIndexLeftTrackerList, leftTrackerList);
            }
            this.updateCounterLeft(counter);
        }
    }

    @Override
    public final void retractLeft(LeftTuple_ leftTuple) {
        IndexProperties indexProperties = (IndexProperties)leftTuple.removeStore(this.inputStoreIndexLeftProperties);
        if (indexProperties == null) {
            return;
        }
        TupleListEntry counterEntry = (TupleListEntry)leftTuple.getStore(this.inputStoreIndexLeftCounterEntry);
        ExistsCounter counter = (ExistsCounter)counterEntry.getElement();
        this.updateIndexerLeft(indexProperties, counterEntry, leftTuple);
        this.killCounterLeft(counter);
    }

    private void updateIndexerLeft(IndexProperties indexProperties, TupleListEntry<ExistsCounter<LeftTuple_>> counterEntry, LeftTuple_ leftTuple) {
        this.indexerLeft.remove(indexProperties, counterEntry);
        if (this.isFiltering) {
            TupleList leftTrackerList = (TupleList)leftTuple.getStore(this.inputStoreIndexLeftTrackerList);
            leftTrackerList.forEach(AbstractIfExistsNode.FilteringTracker::remove);
        }
    }

    @Override
    public final void insertRight(UniTuple<Right_> rightTuple) {
        if (rightTuple.getStore(this.inputStoreIndexRightProperties) != null) {
            throw new IllegalStateException("Impossible state: the input for the tuple (" + rightTuple + ") was already added in the tupleStore.");
        }
        IndexProperties indexProperties = this.mappingRight.apply(rightTuple.getFactA());
        rightTuple.setStore(this.inputStoreIndexRightProperties, indexProperties);
        TupleListEntry<UniTuple<Right_>> rightEntry = this.indexerRight.put(indexProperties, rightTuple);
        rightTuple.setStore(this.inputStoreIndexRightEntry, rightEntry);
        if (!this.isFiltering) {
            this.indexerLeft.forEach(indexProperties, this::incrementCounterRight);
        } else {
            TupleList rightTrackerList = new TupleList();
            this.indexerLeft.forEach(indexProperties, counter -> this.updateCounterFromRight(rightTuple, counter, rightTrackerList));
            rightTuple.setStore(this.inputStoreIndexRightTrackerList, rightTrackerList);
        }
    }

    @Override
    public final void updateRight(UniTuple<Right_> rightTuple) {
        IndexProperties oldIndexProperties = (IndexProperties)rightTuple.getStore(this.inputStoreIndexRightProperties);
        if (oldIndexProperties == null) {
            this.insertRight(rightTuple);
            return;
        }
        IndexProperties newIndexProperties = this.mappingRight.apply(rightTuple.getFactA());
        if (oldIndexProperties.equals(newIndexProperties)) {
            if (this.isFiltering) {
                TupleList rightTrackerList = this.updateRightTrackerList(rightTuple);
                this.indexerLeft.forEach(oldIndexProperties, counter -> this.updateCounterFromRight(rightTuple, counter, rightTrackerList));
            }
        } else {
            TupleListEntry<UniTuple<Right_>> rightEntry = (TupleListEntry<UniTuple<Right_>>)rightTuple.getStore(this.inputStoreIndexRightEntry);
            this.indexerRight.remove(oldIndexProperties, rightEntry);
            if (!this.isFiltering) {
                this.indexerLeft.forEach(oldIndexProperties, this::decrementCounterRight);
            } else {
                this.updateRightTrackerList(rightTuple);
            }
            rightTuple.setStore(this.inputStoreIndexRightProperties, newIndexProperties);
            rightEntry = this.indexerRight.put(newIndexProperties, rightTuple);
            rightTuple.setStore(this.inputStoreIndexRightEntry, rightEntry);
            if (!this.isFiltering) {
                this.indexerLeft.forEach(newIndexProperties, this::incrementCounterRight);
            } else {
                TupleList rightTrackerList = new TupleList();
                this.indexerLeft.forEach(newIndexProperties, counter -> this.updateCounterFromRight(rightTuple, counter, rightTrackerList));
                rightTuple.setStore(this.inputStoreIndexRightTrackerList, rightTrackerList);
            }
        }
    }

    @Override
    public final void retractRight(UniTuple<Right_> rightTuple) {
        IndexProperties indexProperties = (IndexProperties)rightTuple.removeStore(this.inputStoreIndexRightProperties);
        if (indexProperties == null) {
            return;
        }
        TupleListEntry rightEntry = (TupleListEntry)rightTuple.removeStore(this.inputStoreIndexRightEntry);
        this.indexerRight.remove(indexProperties, rightEntry);
        if (!this.isFiltering) {
            this.indexerLeft.forEach(indexProperties, this::decrementCounterRight);
        } else {
            this.updateRightTrackerList(rightTuple);
        }
    }

    protected abstract IndexProperties createIndexProperties(LeftTuple_ var1);
}

