/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.common.inliner;

import java.math.BigDecimal;
import java.util.Arrays;
import org.optaplanner.constraint.streams.common.inliner.AbstractScoreInliner;
import org.optaplanner.constraint.streams.common.inliner.UndoScoreImpacter;
import org.optaplanner.constraint.streams.common.inliner.WeightedScoreImpacter;
import org.optaplanner.core.api.score.buildin.bendablebigdecimal.BendableBigDecimalScore;
import org.optaplanner.core.api.score.stream.Constraint;

final class BendableBigDecimalScoreInliner
extends AbstractScoreInliner<BendableBigDecimalScore> {
    private final BigDecimal[] hardScores;
    private final BigDecimal[] softScores;

    BendableBigDecimalScoreInliner(boolean constraintMatchEnabled, int hardLevelsSize, int softLevelsSize) {
        super(constraintMatchEnabled);
        this.hardScores = new BigDecimal[hardLevelsSize];
        Arrays.fill(this.hardScores, BigDecimal.ZERO);
        this.softScores = new BigDecimal[softLevelsSize];
        Arrays.fill(this.softScores, BigDecimal.ZERO);
    }

    @Override
    public WeightedScoreImpacter buildWeightedScoreImpacter(Constraint constraint, BendableBigDecimalScore constraintWeight) {
        this.validateConstraintWeight(constraint, constraintWeight);
        Integer singleLevel = null;
        for (int i = 0; i < constraintWeight.getLevelsSize(); ++i) {
            if (constraintWeight.getHardOrSoftScore(i).equals(BigDecimal.ZERO)) continue;
            if (singleLevel != null) {
                singleLevel = null;
                break;
            }
            singleLevel = i;
        }
        if (singleLevel != null) {
            BigDecimal levelWeight = constraintWeight.getHardOrSoftScore(singleLevel.intValue());
            if (singleLevel < constraintWeight.getHardLevelsSize()) {
                int level = singleLevel;
                return WeightedScoreImpacter.of((matchWeight, justificationsSupplier) -> {
                    BigDecimal hardImpact = levelWeight.multiply(matchWeight);
                    this.hardScores[level] = this.hardScores[level].add(hardImpact);
                    UndoScoreImpacter undoScoreImpact = () -> {
                        this.hardScores[level] = this.hardScores[level].subtract(hardImpact);
                    };
                    if (!this.constraintMatchEnabled) {
                        return undoScoreImpact;
                    }
                    Runnable undoConstraintMatch = this.addConstraintMatch(constraint, constraintWeight, BendableBigDecimalScore.ofHard((int)this.hardScores.length, (int)this.softScores.length, (int)level, (BigDecimal)hardImpact), justificationsSupplier);
                    return () -> {
                        undoScoreImpact.run();
                        undoConstraintMatch.run();
                    };
                });
            }
            int level = singleLevel - constraintWeight.getHardLevelsSize();
            return WeightedScoreImpacter.of((matchWeight, justificationsSupplier) -> {
                BigDecimal softImpact = levelWeight.multiply(matchWeight);
                this.softScores[level] = this.softScores[level].add(softImpact);
                UndoScoreImpacter undoScoreImpact = () -> {
                    this.softScores[level] = this.softScores[level].subtract(softImpact);
                };
                if (!this.constraintMatchEnabled) {
                    return undoScoreImpact;
                }
                Runnable undoConstraintMatch = this.addConstraintMatch(constraint, constraintWeight, BendableBigDecimalScore.ofSoft((int)this.hardScores.length, (int)this.softScores.length, (int)level, (BigDecimal)softImpact), justificationsSupplier);
                return () -> {
                    undoScoreImpact.run();
                    undoConstraintMatch.run();
                };
            });
        }
        return WeightedScoreImpacter.of((matchWeight, justificationsSupplier) -> {
            int i;
            BigDecimal[] hardImpacts = new BigDecimal[this.hardScores.length];
            BigDecimal[] softImpacts = new BigDecimal[this.softScores.length];
            for (i = 0; i < hardImpacts.length; ++i) {
                hardImpacts[i] = constraintWeight.getHardScore(i).multiply(matchWeight);
                this.hardScores[i] = this.hardScores[i].add(hardImpacts[i]);
            }
            for (i = 0; i < softImpacts.length; ++i) {
                softImpacts[i] = constraintWeight.getSoftScore(i).multiply(matchWeight);
                this.softScores[i] = this.softScores[i].add(softImpacts[i]);
            }
            UndoScoreImpacter undoScoreImpact = () -> {
                int i;
                for (i = 0; i < hardImpacts.length; ++i) {
                    this.hardScores[i] = this.hardScores[i].subtract(hardImpacts[i]);
                }
                for (i = 0; i < softImpacts.length; ++i) {
                    this.softScores[i] = this.softScores[i].subtract(softImpacts[i]);
                }
            };
            if (!this.constraintMatchEnabled) {
                return undoScoreImpact;
            }
            Runnable undoConstraintMatch = this.addConstraintMatch(constraint, constraintWeight, BendableBigDecimalScore.of((BigDecimal[])hardImpacts, (BigDecimal[])softImpacts), justificationsSupplier);
            return () -> {
                undoScoreImpact.run();
                undoConstraintMatch.run();
            };
        });
    }

    @Override
    public BendableBigDecimalScore extractScore(int initScore) {
        return BendableBigDecimalScore.ofUninitialized((int)initScore, (BigDecimal[])Arrays.copyOf(this.hardScores, this.hardScores.length), (BigDecimal[])Arrays.copyOf(this.softScores, this.softScores.length));
    }

    public String toString() {
        return BendableBigDecimalScore.class.getSimpleName() + " inliner";
    }
}

