/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.conferencescheduling.persistence;

import java.io.File;
import java.math.BigInteger;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import org.optaplanner.examples.common.app.CommonApp;
import org.optaplanner.examples.common.app.LoggingMain;
import org.optaplanner.examples.common.persistence.AbstractSolutionImporter;
import org.optaplanner.examples.common.persistence.generator.StringDataGenerator;
import org.optaplanner.examples.common.util.Pair;
import org.optaplanner.examples.conferencescheduling.domain.ConferenceConstraintConfiguration;
import org.optaplanner.examples.conferencescheduling.domain.ConferenceSolution;
import org.optaplanner.examples.conferencescheduling.domain.Room;
import org.optaplanner.examples.conferencescheduling.domain.Speaker;
import org.optaplanner.examples.conferencescheduling.domain.Talk;
import org.optaplanner.examples.conferencescheduling.domain.TalkType;
import org.optaplanner.examples.conferencescheduling.domain.Timeslot;
import org.optaplanner.examples.conferencescheduling.persistence.ConferenceSchedulingXlsxFileIO;
import org.optaplanner.persistence.common.api.domain.solution.SolutionFileIO;

public class ConferenceSchedulingGenerator
extends LoggingMain {
    private final StringDataGenerator conferenceNameGenerator = new StringDataGenerator().addPart(true, 0, "Javoxx", "Red Bonnet Summit", "JayFocus", "YCon", "JAQ").addPart(false, 0, "2021", "2022", "2023", "2024", "2025");
    private static final String LAB_TALK_TYPE = "Lab";
    private static final String BREAKOUT_TALK_TYPE = "Breakout";
    private final LocalDate timeslotFirstDay = LocalDate.of(2018, 10, 1);
    private final List<Pair<LocalTime, LocalTime>> timeslotOptions = Arrays.asList(Pair.of(LocalTime.of(10, 15), LocalTime.of(12, 15)), Pair.of(LocalTime.of(10, 15), LocalTime.of(11, 0)), Pair.of(LocalTime.of(11, 30), LocalTime.of(12, 15)), Pair.of(LocalTime.of(13, 0), LocalTime.of(15, 0)), Pair.of(LocalTime.of(15, 30), LocalTime.of(16, 15)), Pair.of(LocalTime.of(16, 30), LocalTime.of(17, 15)));
    private final List<Pair<String, Double>> roomTagProbabilityList = Arrays.asList(Pair.of("Large", 0.2), Pair.of("Recorded", 0.5));
    private final StringDataGenerator speakerNameGenerator = StringDataGenerator.buildFullNames();
    private final String[] contentTagOptions = new String[]{"OpenShift", "WildFly", "Spring", "Drools", "OptaPlanner", "jBPM", "Camel", "Jackson", "Docker", "Hibernate", "GWT", "Errai", "Angular", "Weld", "RestEasy", "Android", "Tensorflow", "VertX", "JUnit", "Keycloak"};
    private final StringDataGenerator talkTitleGenerator = new StringDataGenerator().addPart(true, 0, "Hands on", "Advanced", "Learn", "Intro to", "Discover", "Mastering", "Tuning", "Building", "Securing", "Debug", "Prepare for", "Understand", "Applying", "Grok", "Troubleshooting", "Using", "Deliver", "Implement", "Program", "Hack").addPart(true, 0, "real-time", "containerized", "virtualized", "serverless", "AI-driven", "machine learning", "IOT-driven", "deep learning", "scalable", "enterprise", "streaming", "mobile", "modern", "distributed", "reliable", "secure", "stable", "platform-independent", "flexible", "modularized").addPart(true, 1, this.contentTagOptions).addPart(false, 3, "in a nutshell", "in practice", "for dummies", "in action", "recipes", "on the web", "for decision makers", "on the whiteboard", "out of the box", "for programmers", "for managers", "for QA engineers", "in Java", "in Scala", "in Kotlin", "in Lisp", "in C++", "in Assembly", "with style", "like a pro");
    private final List<String> themeTagOptions = Arrays.asList("Artificial Intelligence", "Cloud", "Big Data", "Culture", "Middleware", "Mobile", "IoT", "Modern Web", "Security");
    private final List<String> sectorTagOptions = Arrays.asList("Education", "Financial services", "Government", "Healthcare", "Telecommunications", "Transportation");
    private final List<String> audienceTypeOptions = Arrays.asList("Programmers", "Business analysts", "Managers");
    private static final String TIMESLOT_AFTER_LUNCH_TAG = "After lunch";
    private static final List<String> mutuallyExclusiveTagList = List.of("Platinum Sponsor");
    protected final SolutionFileIO<ConferenceSolution> solutionFileIO = new ConferenceSchedulingXlsxFileIO();
    protected final File outputDir = new File(CommonApp.determineDataDir("conferencescheduling"), "unsolved");
    private TalkType breakoutTalkType;
    private TalkType labTalkType;
    protected int labTalkCount;
    protected Random random;

    public static void main(String[] args) {
        ConferenceSchedulingGenerator generator = new ConferenceSchedulingGenerator();
        generator.writeConferenceSolution(1, 5);
        generator.writeConferenceSolution(2, 5);
        generator.writeConferenceSolution(2, 10);
        generator.writeConferenceSolution(3, 10);
        generator.writeConferenceSolution(3, 20);
    }

    private void writeConferenceSolution(int dayListSize, int roomListSize) {
        int labTimeslotCount = (int)this.timeslotOptions.stream().filter(pair -> Duration.between((Temporal)pair.getKey(), (Temporal)pair.getValue()).toMinutes() >= 120L).count();
        int labRoomCount = roomListSize / 5;
        this.labTalkCount = dayListSize * labTimeslotCount * labRoomCount;
        int timeslotListSize = dayListSize * this.timeslotOptions.size();
        int talkListSize = dayListSize * (this.timeslotOptions.size() - labTimeslotCount) * (roomListSize - labRoomCount) + this.labTalkCount;
        int speakerListSize = talkListSize * 2 / 3;
        String fileName = talkListSize + "talks-" + timeslotListSize + "timeslots-" + roomListSize + "rooms";
        File outputFile = new File(this.outputDir, fileName + "." + this.solutionFileIO.getOutputFileExtension());
        ConferenceSolution solution = this.createConferenceSolution(fileName, timeslotListSize, roomListSize, speakerListSize, talkListSize);
        this.solutionFileIO.write((Object)solution, outputFile);
    }

    public ConferenceSolution createConferenceSolution(String fileName, int timeslotListSize, int roomListSize, int speakerListSize, int talkListSize) {
        this.random = new Random(37L);
        ConferenceSolution solution = new ConferenceSolution(0L);
        solution.setConferenceName(this.conferenceNameGenerator.generateNextValue());
        ConferenceConstraintConfiguration constraintConfiguration = new ConferenceConstraintConfiguration(0L);
        constraintConfiguration.setMinimumConsecutiveTalksPauseInMinutes(15);
        solution.setConstraintConfiguration(constraintConfiguration);
        this.createTalkTypeList(solution);
        this.createTimeslotList(solution, timeslotListSize);
        this.createRoomList(solution, roomListSize);
        this.createSpeakerList(solution, speakerListSize);
        this.createTalkList(solution, talkListSize);
        BigInteger possibleSolutionSize = BigInteger.valueOf((long)timeslotListSize * (long)roomListSize).pow(talkListSize);
        this.logger.info("Conference {} has {} talks, {} timeslots and {} rooms with a search space of {}.", new Object[]{fileName, talkListSize, timeslotListSize, roomListSize, AbstractSolutionImporter.getFlooredPossibleSolutionSize(possibleSolutionSize)});
        return solution;
    }

    private void createTalkTypeList(ConferenceSolution solution) {
        ArrayList<TalkType> talkTypeList = new ArrayList<TalkType>(2);
        this.breakoutTalkType = new TalkType(0L);
        this.breakoutTalkType.setName(BREAKOUT_TALK_TYPE);
        this.breakoutTalkType.setCompatibleTimeslotSet(new LinkedHashSet<Timeslot>());
        this.breakoutTalkType.setCompatibleRoomSet(new LinkedHashSet<Room>());
        talkTypeList.add(this.breakoutTalkType);
        this.labTalkType = new TalkType(1L);
        this.labTalkType.setName(LAB_TALK_TYPE);
        this.labTalkType.setCompatibleTimeslotSet(new LinkedHashSet<Timeslot>());
        this.labTalkType.setCompatibleRoomSet(new LinkedHashSet<Room>());
        talkTypeList.add(this.labTalkType);
        solution.setTalkTypeList(talkTypeList);
    }

    private void createTimeslotList(ConferenceSolution solution, int timeslotListSize) {
        ArrayList<Timeslot> timeslotList = new ArrayList<Timeslot>(timeslotListSize);
        int timeslotOptionsIndex = 0;
        LocalDate day = this.timeslotFirstDay;
        for (int i = 0; i < timeslotListSize; ++i) {
            Timeslot timeslot = new Timeslot(i);
            if (timeslotOptionsIndex >= this.timeslotOptions.size()) {
                timeslotOptionsIndex = 0;
                day = day.plusDays(1L);
            }
            Pair<LocalTime, LocalTime> pair = this.timeslotOptions.get(timeslotOptionsIndex);
            timeslot.setStartDateTime(LocalDateTime.of(day, pair.getKey()));
            timeslot.setEndDateTime(LocalDateTime.of(day, pair.getValue()));
            TalkType talkType = timeslot.getDurationInMinutes() >= 120 ? this.labTalkType : this.breakoutTalkType;
            talkType.getCompatibleTimeslotSet().add(timeslot);
            timeslot.setTalkTypeSet(Collections.singleton(talkType));
            ++timeslotOptionsIndex;
            LinkedHashSet<String> tagSet = new LinkedHashSet<String>(2);
            if (timeslot.getStartDateTime().getHour() == 13) {
                tagSet.add(TIMESLOT_AFTER_LUNCH_TAG);
            }
            timeslot.setTagSet(tagSet);
            this.logger.trace("Created timeslot ({}) with tags ({}).", (Object)timeslot, tagSet);
            timeslotList.add(timeslot);
        }
        solution.setTimeslotList(timeslotList);
    }

    private void createRoomList(ConferenceSolution solution, int roomListSize) {
        int roomsPerFloor = 12;
        ArrayList<Room> roomList = new ArrayList<Room>(roomListSize);
        for (int i = 0; i < roomListSize; ++i) {
            Room room = new Room(i);
            room.setName("R " + (i / 12 * 100 + i % 12 + 1));
            room.setCapacity((1 + this.random.nextInt(100)) * 10);
            TalkType talkType = i % 5 == 4 ? this.labTalkType : this.breakoutTalkType;
            talkType.getCompatibleRoomSet().add(room);
            room.setTalkTypeSet(Collections.singleton(talkType));
            room.setUnavailableTimeslotSet(new LinkedHashSet<Timeslot>());
            LinkedHashSet<String> tagSet = new LinkedHashSet<String>(this.roomTagProbabilityList.size());
            for (Pair<String, Double> roomTagProbability : this.roomTagProbabilityList) {
                if (i != 0 && i != 4 && !(this.random.nextDouble() < roomTagProbability.getValue()) || !roomTagProbability.getKey().equals("Recorded")) continue;
                tagSet.add(roomTagProbability.getKey());
            }
            if (room.getCapacity() >= 500) {
                tagSet.add("Large");
            }
            room.setTagSet(tagSet);
            this.logger.trace("Created room with name ({}) and tags ({}).", (Object)room.getName(), tagSet);
            roomList.add(room);
        }
        solution.setRoomList(roomList);
    }

    private void createSpeakerList(ConferenceSolution solution, int speakerListSize) {
        ArrayList<Speaker> speakerList = new ArrayList<Speaker>(speakerListSize);
        this.speakerNameGenerator.predictMaximumSizeAndReset(speakerListSize);
        for (int i = 0; i < speakerListSize; ++i) {
            Set<Timeslot> unavailableTimeslotSet;
            Speaker speaker = new Speaker(i);
            speaker.setName(this.speakerNameGenerator.generateNextValue());
            LinkedHashSet<String> preferredTimeslotTagSet = new LinkedHashSet<String>();
            LinkedHashSet<String> undesiredTimeslotTagSet = new LinkedHashSet<String>();
            List<Timeslot> timeslotList = solution.getTimeslotList();
            if (this.random.nextDouble() < 0.1) {
                double segmentRandom = this.random.nextDouble();
                if (segmentRandom < 0.1) {
                    unavailableTimeslotSet = timeslotList.stream().filter(timeslot -> timeslot.getStartDateTime().toLocalTime().isBefore(LocalTime.of(12, 0))).collect(Collectors.toCollection(LinkedHashSet::new));
                    preferredTimeslotTagSet.add(TIMESLOT_AFTER_LUNCH_TAG);
                } else if (segmentRandom < 0.2) {
                    unavailableTimeslotSet = timeslotList.stream().filter(timeslot -> !timeslot.getStartDateTime().toLocalTime().isBefore(LocalTime.of(12, 0))).collect(Collectors.toCollection(LinkedHashSet::new));
                } else if (segmentRandom < 0.3) {
                    LocalDate availableDate = timeslotList.get(this.random.nextInt(timeslotList.size())).getDate();
                    unavailableTimeslotSet = timeslotList.stream().filter(timeslot -> !timeslot.getDate().equals(availableDate)).collect(Collectors.toCollection(LinkedHashSet::new));
                } else {
                    unavailableTimeslotSet = timeslotList.stream().filter(timeslot -> this.random.nextDouble() < 0.05).collect(Collectors.toCollection(LinkedHashSet::new));
                    undesiredTimeslotTagSet.add(TIMESLOT_AFTER_LUNCH_TAG);
                }
            } else {
                unavailableTimeslotSet = new LinkedHashSet<Timeslot>(timeslotList.size());
            }
            speaker.setUnavailableTimeslotSet(unavailableTimeslotSet);
            speaker.setRequiredTimeslotTagSet(new LinkedHashSet<String>());
            speaker.setPreferredTimeslotTagSet(preferredTimeslotTagSet);
            speaker.setProhibitedTimeslotTagSet(new LinkedHashSet<String>());
            speaker.setUndesiredTimeslotTagSet(undesiredTimeslotTagSet);
            LinkedHashSet<String> requiredRoomTagSet = new LinkedHashSet<String>();
            LinkedHashSet<String> preferredRoomTagSet = new LinkedHashSet<String>();
            LinkedHashSet<String> prohibitedRoomTagSet = new LinkedHashSet<String>();
            LinkedHashSet<String> undesiredRoomTagSet = new LinkedHashSet<String>();
            this.initializeRoomTagSets(requiredRoomTagSet, preferredRoomTagSet, prohibitedRoomTagSet, undesiredRoomTagSet);
            speaker.setRequiredRoomTagSet(requiredRoomTagSet);
            speaker.setPreferredRoomTagSet(preferredRoomTagSet);
            speaker.setProhibitedRoomTagSet(prohibitedRoomTagSet);
            speaker.setUndesiredRoomTagSet(undesiredRoomTagSet);
            this.logger.trace("Created speaker with name ({}).", (Object)speaker.getName());
            speakerList.add(speaker);
        }
        solution.setSpeakerList(speakerList);
    }

    private void createTalkList(ConferenceSolution solution, int talkListSize) {
        ArrayList<Talk> talkList = new ArrayList<Talk>(talkListSize);
        this.talkTitleGenerator.predictMaximumSizeAndReset(talkListSize);
        int speakerListIndex = 0;
        for (int i = 0; i < talkListSize; ++i) {
            Talk talk = new Talk(i);
            talk.setCode(String.format("S%0" + String.valueOf(talkListSize).length() + "d", i));
            talk.setTitle(this.talkTitleGenerator.generateNextValue());
            double speakerRandomDouble = this.random.nextDouble();
            talk.setTalkType(i < this.labTalkCount ? this.labTalkType : this.breakoutTalkType);
            int speakerCount = speakerRandomDouble < 0.01 ? 4 : (speakerRandomDouble < 0.03 ? 3 : (speakerRandomDouble < 0.4 ? 2 : 1));
            ArrayList<Speaker> speakerList = new ArrayList<Speaker>(speakerCount);
            for (int j = 0; j < speakerCount; ++j) {
                speakerList.add(solution.getSpeakerList().get(speakerListIndex));
                speakerListIndex = (speakerListIndex + 1) % solution.getSpeakerList().size();
            }
            talk.setSpeakerList(speakerList);
            LinkedHashSet<String> themeTagSet = new LinkedHashSet<String>();
            themeTagSet.add(this.themeTagOptions.get(this.random.nextInt(this.themeTagOptions.size())));
            if (this.random.nextDouble() < 0.2) {
                themeTagSet.add(this.themeTagOptions.get(this.random.nextInt(this.themeTagOptions.size())));
            }
            talk.setThemeTrackTagSet(themeTagSet);
            LinkedHashSet<String> sectorTagSet = new LinkedHashSet<String>();
            if (this.random.nextDouble() < 0.2) {
                sectorTagSet.add(this.sectorTagOptions.get(this.random.nextInt(this.sectorTagOptions.size())));
            }
            talk.setAudienceTypeSet(Collections.singleton(this.audienceTypeOptions.get(this.random.nextInt(this.audienceTypeOptions.size()))));
            talk.setAudienceLevel(1 + this.random.nextInt(3));
            LinkedHashSet<String> contentTagSet = new LinkedHashSet<String>();
            for (String contentTagOption : this.contentTagOptions) {
                if (!talk.getTitle().contains(contentTagOption)) continue;
                contentTagSet.add(contentTagOption);
                if (!contentTagOption.equalsIgnoreCase("OpenShift") && !contentTagOption.equalsIgnoreCase("Docker") || !(this.random.nextDouble() < 0.4)) break;
                contentTagSet.add("Kubernetes");
                break;
            }
            talk.setContentTagSet(contentTagSet);
            talk.setSectorTagSet(sectorTagSet);
            talk.setLanguage("en");
            talk.setRequiredTimeslotTagSet(new LinkedHashSet<String>());
            talk.setPreferredTimeslotTagSet(new LinkedHashSet<String>());
            talk.setProhibitedTimeslotTagSet(new LinkedHashSet<String>());
            talk.setUndesiredTimeslotTagSet(new LinkedHashSet<String>());
            LinkedHashSet<String> requiredRoomTagSet = new LinkedHashSet<String>();
            LinkedHashSet<String> preferredRoomTagSet = new LinkedHashSet<String>();
            LinkedHashSet<String> prohibitedRoomTagSet = new LinkedHashSet<String>();
            LinkedHashSet<String> undesiredRoomTagSet = new LinkedHashSet<String>();
            this.initializeRoomTagSets(requiredRoomTagSet, preferredRoomTagSet, prohibitedRoomTagSet, undesiredRoomTagSet);
            talk.setRequiredRoomTagSet(requiredRoomTagSet);
            talk.setPreferredRoomTagSet(preferredRoomTagSet);
            talk.setProhibitedRoomTagSet(prohibitedRoomTagSet);
            talk.setUndesiredRoomTagSet(undesiredRoomTagSet);
            LinkedHashSet<String> mutuallyExclusiveTagSet = new LinkedHashSet<String>();
            if (this.random.nextDouble() < 0.025) {
                mutuallyExclusiveTagSet.add(mutuallyExclusiveTagList.get(this.random.nextInt(mutuallyExclusiveTagList.size())));
            }
            talk.setMutuallyExclusiveTalksTagSet(mutuallyExclusiveTagSet);
            LinkedHashSet<Talk> prerequisiteTalkCodeSet = new LinkedHashSet<Talk>();
            if (this.random.nextDouble() < 0.025) {
                prerequisiteTalkCodeSet.add((Talk)talkList.get(this.random.nextInt(talkList.size())));
            }
            talk.setPrerequisiteTalkSet(prerequisiteTalkCodeSet);
            talk.setFavoriteCount(this.random.nextInt(1000));
            if (this.random.nextDouble() < 0.02) {
                talk.setCrowdControlRisk(1);
                Talk pairedTalk = (Talk)talkList.get(this.random.nextInt(talkList.size()));
                while (pairedTalk.getCrowdControlRisk() != 0 || !pairedTalk.getTalkType().equals(talk.getTalkType())) {
                    pairedTalk = (Talk)talkList.get(this.random.nextInt(talkList.size()));
                }
                pairedTalk.setCrowdControlRisk(1);
            }
            talk.setCrowdControlRisk(0);
            this.logger.trace("Created talk with code ({}), title ({}) and speakers ({}).", new Object[]{talk.getCode(), talk.getTitle(), speakerList});
            talkList.add(talk);
        }
        Talk pinnedTalk = (Talk)talkList.get(this.labTalkCount + this.random.nextInt(talkListSize - this.labTalkCount));
        pinnedTalk.setPinnedByUser(true);
        pinnedTalk.setTimeslot(solution.getTimeslotList().stream().filter(timeslot -> timeslot.getTalkTypeSet().contains(this.breakoutTalkType)).findFirst().get());
        pinnedTalk.setRoom(solution.getRoomList().get(0));
        Talk publishedTalk = (Talk)talkList.get(this.random.nextInt(this.labTalkCount));
        publishedTalk.setTimeslot(solution.getTimeslotList().stream().filter(timeslot -> timeslot.getTalkTypeSet().contains(this.labTalkType)).findFirst().get());
        publishedTalk.setRoom(solution.getRoomList().stream().filter(room -> room.getTalkTypeSet().contains(this.labTalkType)).findFirst().get());
        publishedTalk.setPublishedTimeslot(publishedTalk.getTimeslot());
        publishedTalk.setPublishedRoom(publishedTalk.getRoom());
        solution.setTalkList(talkList);
    }

    private void initializeRoomTagSets(Set<String> requiredRoomTagSet, Set<String> preferredRoomTagSet, Set<String> prohibitedRoomTagSet, Set<String> undesiredRoomTagSet) {
        for (Pair<String, Double> roomTagProbability : this.roomTagProbabilityList) {
            double segmentRandom = this.random.nextDouble();
            if (segmentRandom < roomTagProbability.getValue() / 25.0) {
                requiredRoomTagSet.add(roomTagProbability.getKey());
                continue;
            }
            if (segmentRandom < roomTagProbability.getValue() / 20.0) {
                prohibitedRoomTagSet.add(roomTagProbability.getKey());
                continue;
            }
            if (segmentRandom < roomTagProbability.getValue() / 15.0) {
                preferredRoomTagSet.add(roomTagProbability.getKey());
                continue;
            }
            if (!(segmentRandom < roomTagProbability.getValue() / 10.0)) continue;
            undesiredRoomTagSet.add(roomTagProbability.getKey());
        }
    }
}

