/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.experimental.impl;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.BiFunction;
import org.optaplanner.examples.common.experimental.api.Break;
import org.optaplanner.examples.common.experimental.api.ConsecutiveInfo;
import org.optaplanner.examples.common.experimental.api.Sequence;
import org.optaplanner.examples.common.experimental.impl.BreakImpl;
import org.optaplanner.examples.common.experimental.impl.MapValuesIterable;
import org.optaplanner.examples.common.experimental.impl.SequenceImpl;

public final class ConsecutiveSetTree<Value_, Point_ extends Comparable<Point_>, Difference_ extends Comparable<Difference_>>
implements ConsecutiveInfo<Value_, Difference_> {
    private final BiFunction<Point_, Point_, Difference_> differenceFunction;
    private final BiFunction<Difference_, Difference_, Difference_> sumFunction;
    private final Difference_ maxDifference;
    private final Difference_ zeroDifference;
    private final NavigableMap<Value_, Integer> itemToCountMap;
    private final NavigableMap<Value_, SequenceImpl<Value_, Difference_>> startItemToSequence;
    private final NavigableMap<Value_, BreakImpl<Value_, Difference_>> startItemToPreviousBreak;
    private final Map<Value_, Point_> indexMap;
    private final MapValuesIterable<Value_, SequenceImpl<Value_, Difference_>> sequenceList;
    private final MapValuesIterable<Value_, BreakImpl<Value_, Difference_>> breakList;

    public ConsecutiveSetTree(BiFunction<Point_, Point_, Difference_> differenceFunction, BiFunction<Difference_, Difference_, Difference_> sumFunction, Difference_ maxDifference, Difference_ zeroDifference) {
        this.differenceFunction = differenceFunction;
        this.sumFunction = sumFunction;
        this.maxDifference = maxDifference;
        this.zeroDifference = zeroDifference;
        this.indexMap = new HashMap<Value_, Point_>();
        ValueComparator<Value_, Point_> comparator = new ValueComparator<Value_, Point_>(this.indexMap);
        this.itemToCountMap = new TreeMap<Value_, Integer>(comparator);
        this.startItemToSequence = new TreeMap<Value_, SequenceImpl<Value_, Difference_>>(comparator);
        this.startItemToPreviousBreak = new TreeMap<Value_, BreakImpl<Value_, Difference_>>(comparator);
        this.sequenceList = new MapValuesIterable<SequenceImpl<Value_, Difference_>, SequenceImpl<SequenceImpl<Value_, Difference_>, Difference_>>(this.startItemToSequence);
        this.breakList = new MapValuesIterable<BreakImpl<Value_, Difference_>, BreakImpl<BreakImpl<Value_, Difference_>, Difference_>>(this.startItemToPreviousBreak);
    }

    @Override
    public Iterable<Sequence<Value_, Difference_>> getConsecutiveSequences() {
        return this.sequenceList;
    }

    @Override
    public Iterable<Break<Value_, Difference_>> getBreaks() {
        return this.breakList;
    }

    public boolean add(Value_ item, Point_ point) {
        this.indexMap.put(item, point);
        int newCount = this.itemToCountMap.compute(item, (key, count) -> count == null ? 1 : count + 1);
        if (newCount > 1) {
            return true;
        }
        Value_ firstBeforeItem = this.startItemToSequence.floorKey(item);
        Comparable itemIndex = (Comparable)this.indexMap.get(item);
        if (firstBeforeItem != null) {
            Value_ endOfBeforeSequenceItem = this.getEndItem(firstBeforeItem);
            Comparable endOfBeforeSequenceIndex = (Comparable)this.indexMap.get(endOfBeforeSequenceItem);
            if (this.isInNaturalOrderAndHashOrderIfEqual(itemIndex, item, endOfBeforeSequenceIndex, endOfBeforeSequenceItem)) {
                return true;
            }
            Value_ firstAfterItem = this.startItemToSequence.higherKey(item);
            if (firstAfterItem != null) {
                Comparable startOfAfterSequenceIndex = (Comparable)this.indexMap.get(firstAfterItem);
                this.addBetweenItems(item, itemIndex, firstBeforeItem, endOfBeforeSequenceItem, endOfBeforeSequenceIndex, firstAfterItem, startOfAfterSequenceIndex);
            } else {
                SequenceImpl prevBag = (SequenceImpl)this.startItemToSequence.get(firstBeforeItem);
                if (this.isFirstSuccessorOfSecond(itemIndex, item, endOfBeforeSequenceIndex, endOfBeforeSequenceItem)) {
                    prevBag.setEnd(item);
                } else {
                    SequenceImpl newBag = new SequenceImpl(this, item);
                    this.startItemToSequence.put(item, newBag);
                    this.startItemToPreviousBreak.put(item, new BreakImpl<Value_, Comparable>(prevBag, newBag, (Comparable)this.differenceFunction.apply(endOfBeforeSequenceIndex, itemIndex)));
                }
            }
        } else {
            Value_ firstAfterItem = this.startItemToSequence.higherKey(item);
            if (firstAfterItem != null) {
                Comparable startOfAfterSequenceIndex = (Comparable)this.indexMap.get(firstAfterItem);
                if (this.isFirstSuccessorOfSecond(startOfAfterSequenceIndex, firstAfterItem, itemIndex, item)) {
                    SequenceImpl afterBag = (SequenceImpl)this.startItemToSequence.remove(firstAfterItem);
                    afterBag.setStart(item);
                    this.startItemToSequence.put(item, afterBag);
                } else {
                    SequenceImpl afterBag = (SequenceImpl)this.startItemToSequence.get(firstAfterItem);
                    SequenceImpl newBag = new SequenceImpl(this, item);
                    this.startItemToSequence.put(item, newBag);
                    this.startItemToPreviousBreak.put(firstAfterItem, new BreakImpl<Value_, Comparable>(newBag, afterBag, (Comparable)this.differenceFunction.apply(itemIndex, startOfAfterSequenceIndex)));
                }
            } else {
                SequenceImpl newBag = new SequenceImpl(this, item);
                this.startItemToSequence.put(item, newBag);
            }
        }
        return true;
    }

    public boolean remove(Value_ item) {
        Integer currentCount = (Integer)this.itemToCountMap.get(item);
        if (currentCount == null) {
            return false;
        }
        if (currentCount != 1) {
            this.itemToCountMap.put(item, currentCount - 1);
            return true;
        }
        this.itemToCountMap.remove(item);
        Value_ firstBeforeItem = this.startItemToSequence.floorKey(item);
        SequenceImpl bag = (SequenceImpl)this.startItemToSequence.get(firstBeforeItem);
        Object endItem = bag.getLastItem();
        if (bag.getFirstItem() == bag.getLastItem()) {
            this.startItemToSequence.remove(firstBeforeItem);
            BreakImpl removedBreak = (BreakImpl)this.startItemToPreviousBreak.remove(firstBeforeItem);
            Map.Entry<Value_, BreakImpl<Value_, Difference_>> extendedBreakEntry = this.startItemToPreviousBreak.higherEntry(firstBeforeItem);
            if (extendedBreakEntry != null) {
                if (removedBreak != null) {
                    BreakImpl extendedBreak = extendedBreakEntry.getValue();
                    extendedBreak.setPreviousSequence(removedBreak.getPreviousSequence());
                    this.updateLengthOfBreak(extendedBreak);
                } else {
                    this.startItemToPreviousBreak.remove(extendedBreakEntry.getKey());
                }
            }
            this.indexMap.remove(item);
            return true;
        }
        return this.removeItemFromBag(bag, item, firstBeforeItem, endItem);
    }

    Break<Value_, Difference_> getBreakBefore(Value_ item) {
        return (Break)this.startItemToPreviousBreak.get(item);
    }

    Break<Value_, Difference_> getBreakAfter(Value_ item) {
        Map.Entry<Value_, BreakImpl<Value_, Difference_>> entry = this.startItemToPreviousBreak.higherEntry(item);
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }

    NavigableSet<Value_> getItemSet() {
        return (NavigableSet)this.itemToCountMap.keySet();
    }

    void updateLengthOfBreak(BreakImpl<Value_, Difference_> theBreak) {
        theBreak.setLength(this.getBreakLengthBetween(theBreak.getPreviousSequenceEnd(), theBreak.getNextSequenceStart()));
    }

    Difference_ getSequenceLength(Sequence<Value_, Difference_> sequence) {
        return (Difference_)((Comparable)this.sumFunction.apply(this.maxDifference, (Comparable)this.differenceFunction.apply((Comparable)this.indexMap.get(sequence.getFirstItem()), (Comparable)this.indexMap.get(sequence.getLastItem()))));
    }

    Difference_ getBreakLengthBetween(Value_ from, Value_ to) {
        return (Difference_)((Comparable)this.differenceFunction.apply((Comparable)this.indexMap.get(from), (Comparable)this.indexMap.get(to)));
    }

    Value_ getEndItem(Value_ key) {
        return ((SequenceImpl)this.startItemToSequence.get(key)).getLastItem();
    }

    private <T extends Comparable<T>> boolean isInNaturalOrderAndHashOrderIfEqual(T a, Value_ aItem, T b, Value_ bItem) {
        int difference = a.compareTo(b);
        if (difference != 0) {
            return difference < 0;
        }
        return System.identityHashCode(aItem) - System.identityHashCode(bItem) < 0;
    }

    private boolean isFirstSuccessorOfSecond(Point_ first, Value_ firstValue, Point_ second, Value_ secondValue) {
        Comparable difference = (Comparable)this.differenceFunction.apply(second, first);
        return this.isInNaturalOrderAndHashOrderIfEqual((Comparable)this.zeroDifference, secondValue, (Comparable)difference, firstValue) && difference.compareTo(this.maxDifference) <= 0;
    }

    private void addBetweenItems(Value_ item, Point_ itemIndex, Value_ firstBeforeItem, Value_ endOfBeforeSequenceItem, Point_ endOfBeforeSequenceItemIndex, Value_ firstAfterItem, Point_ startOfAfterSequenceIndex) {
        if (this.isFirstSuccessorOfSecond(itemIndex, item, endOfBeforeSequenceItemIndex, endOfBeforeSequenceItem)) {
            SequenceImpl prevBag = (SequenceImpl)this.startItemToSequence.get(firstBeforeItem);
            if (this.isFirstSuccessorOfSecond(startOfAfterSequenceIndex, firstAfterItem, itemIndex, item)) {
                this.startItemToPreviousBreak.remove(firstAfterItem);
                SequenceImpl afterBag = (SequenceImpl)this.startItemToSequence.remove(firstAfterItem);
                prevBag.merge(afterBag);
                Map.Entry<Value_, BreakImpl<Value_, Difference_>> maybeNextBreak = this.startItemToPreviousBreak.higherEntry(firstAfterItem);
                if (maybeNextBreak != null) {
                    maybeNextBreak.getValue().setPreviousSequence(prevBag);
                }
            } else {
                prevBag.setEnd(item);
                BreakImpl nextBreak = (BreakImpl)this.startItemToPreviousBreak.get(firstAfterItem);
                nextBreak.setLength((Comparable)this.differenceFunction.apply(itemIndex, startOfAfterSequenceIndex));
            }
        } else if (this.isFirstSuccessorOfSecond(startOfAfterSequenceIndex, firstAfterItem, itemIndex, item)) {
            SequenceImpl afterBag = (SequenceImpl)this.startItemToSequence.remove(firstAfterItem);
            afterBag.setStart(item);
            this.startItemToSequence.put(item, afterBag);
            BreakImpl prevBreak = (BreakImpl)this.startItemToPreviousBreak.remove(firstAfterItem);
            prevBreak.setLength((Comparable)this.differenceFunction.apply(endOfBeforeSequenceItemIndex, itemIndex));
            this.startItemToPreviousBreak.put(item, prevBreak);
        } else {
            SequenceImpl newBag = new SequenceImpl(this, item);
            this.startItemToSequence.put(item, newBag);
            BreakImpl nextBreak = (BreakImpl)this.startItemToPreviousBreak.get(firstAfterItem);
            nextBreak.setPreviousSequence(newBag);
            nextBreak.setLength((Comparable)this.differenceFunction.apply(itemIndex, startOfAfterSequenceIndex));
            this.startItemToPreviousBreak.put(item, new BreakImpl<Value_, Comparable>((Sequence)this.startItemToSequence.get(firstBeforeItem), newBag, (Comparable)this.differenceFunction.apply(endOfBeforeSequenceItemIndex, itemIndex)));
        }
    }

    private boolean removeItemFromBag(SequenceImpl<Value_, Difference_> bag, Value_ item, Value_ sequenceStart, Value_ sequenceEnd) {
        NavigableSet<Value_> itemSet = this.getItemSet();
        if (item.equals(sequenceStart)) {
            bag.setStart(itemSet.higher(item));
            this.startItemToSequence.remove(sequenceStart);
            BreakImpl extendedBreak = (BreakImpl)this.startItemToPreviousBreak.remove(sequenceStart);
            Value_ firstItem = bag.getFirstItem();
            this.startItemToSequence.put(firstItem, bag);
            if (extendedBreak != null) {
                this.updateLengthOfBreak(extendedBreak);
                this.startItemToPreviousBreak.put(firstItem, extendedBreak);
            }
            this.indexMap.remove(item);
            return true;
        }
        if (item.equals(sequenceEnd)) {
            bag.setEnd(itemSet.lower(item));
            Map.Entry<Value_, BreakImpl<Value_, Difference_>> extendedBreakEntry = this.startItemToPreviousBreak.higherEntry(item);
            if (extendedBreakEntry != null) {
                BreakImpl<Value_, Difference_> extendedBreak = extendedBreakEntry.getValue();
                this.updateLengthOfBreak(extendedBreak);
            }
            this.indexMap.remove(item);
            return true;
        }
        Value_ firstAfterItem = bag.getItems().higher(item);
        Value_ firstBeforeItem = bag.getItems().lower(item);
        if (this.isFirstSuccessorOfSecond((Comparable)this.indexMap.get(firstAfterItem), firstAfterItem, (Comparable)this.indexMap.get(firstBeforeItem), firstBeforeItem)) {
            this.indexMap.remove(item);
            return true;
        }
        SequenceImpl<Value_, Difference_> splitBag = bag.split(item);
        Value_ firstSplitItem = splitBag.getFirstItem();
        Value_ lastOriginalItem = bag.getLastItem();
        this.startItemToSequence.put(firstSplitItem, splitBag);
        this.startItemToPreviousBreak.put(firstSplitItem, new BreakImpl<Value_, Difference_>(bag, splitBag, this.getBreakLengthBetween(lastOriginalItem, firstSplitItem)));
        Map.Entry<Value_, BreakImpl<Value_, Difference_>> maybeNextBreak = this.startItemToPreviousBreak.higherEntry(firstAfterItem);
        if (maybeNextBreak != null) {
            maybeNextBreak.getValue().setPreviousSequence(splitBag);
        }
        this.indexMap.remove(item);
        return true;
    }

    public String toString() {
        return "Sequences {sequenceList=" + this.sequenceList + ", breakList=" + this.breakList + "}";
    }

    private static final class ValueComparator<Value_, Point_ extends Comparable<Point_>>
    implements Comparator<Value_> {
        private final Map<Value_, Point_> indexMap;

        public ValueComparator(Map<Value_, Point_> indexMap) {
            this.indexMap = Objects.requireNonNull(indexMap);
        }

        @Override
        public int compare(Value_ o1, Value_ o2) {
            Comparable point2;
            if (o1 == o2) {
                return 0;
            }
            Comparable point1 = (Comparable)this.indexMap.get(o1);
            if (point1 == (point2 = (Comparable)this.indexMap.get(o2))) {
                return ValueComparator.compareWithIdentityHashCode(o1, o2);
            }
            int comparison = point1.compareTo(point2);
            if (comparison != 0) {
                return comparison;
            }
            return ValueComparator.compareWithIdentityHashCode(o1, o2);
        }

        private static int compareWithIdentityHashCode(Object o1, Object o2) {
            int identityHashCode1 = System.identityHashCode(o1);
            int identityHashCode2 = System.identityHashCode(o2);
            return Integer.compare(identityHashCode1, identityHashCode2);
        }
    }
}

