/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.conferencescheduling.domain;

import org.optaplanner.core.api.domain.constraintweight.ConstraintConfiguration;
import org.optaplanner.core.api.domain.constraintweight.ConstraintWeight;
import org.optaplanner.core.api.score.buildin.hardmediumsoft.HardMediumSoftScore;
import org.optaplanner.examples.common.domain.AbstractPersistable;

@ConstraintConfiguration(constraintPackage="org.optaplanner.examples.conferencescheduling.solver")
public class ConferenceConstraintConfiguration
extends AbstractPersistable {
    public static final String TALK_TYPE_OF_TIMESLOT = "Talk type of timeslot";
    public static final String TALK_TYPE_OF_ROOM = "Talk type of room";
    public static final String ROOM_UNAVAILABLE_TIMESLOT = "Room unavailable timeslot";
    public static final String ROOM_CONFLICT = "Room conflict";
    public static final String SPEAKER_UNAVAILABLE_TIMESLOT = "Speaker unavailable timeslot";
    public static final String SPEAKER_CONFLICT = "Speaker conflict";
    public static final String SPEAKER_REQUIRED_TIMESLOT_TAGS = "Speaker required timeslot tags";
    public static final String SPEAKER_PROHIBITED_TIMESLOT_TAGs = "Speaker prohibited timeslot tags";
    public static final String TALK_REQUIRED_TIMESLOT_TAGS = "Talk required timeslot tags";
    public static final String TALK_PROHIBITED_TIMESLOT_TAGS = "Talk prohibited timeslot tags";
    public static final String SPEAKER_REQUIRED_ROOM_TAGS = "Speaker required room tags";
    public static final String SPEAKER_PROHIBITED_ROOM_TAGS = "Speaker prohibited room tags";
    public static final String TALK_REQUIRED_ROOM_TAGS = "Talk required room tags";
    public static final String TALK_PROHIBITED_ROOM_TAGS = "Talk prohibited room tags";
    public static final String TALK_PREREQUISITE_TALKS = "Talk prerequisite talks";
    public static final String CONSECUTIVE_TALKS_PAUSE = "Consecutive talks pause";
    public static final String TALK_MUTUALLY_EXCLUSIVE_TALKS_TAGS = "Talk mutually-exclusive-talks tags";
    public static final String PUBLISHED_TIMESLOT = "Published timeslot";
    public static final String THEME_TRACK_CONFLICT = "Theme track conflict";
    public static final String SECTOR_CONFLICT = "Sector conflict";
    public static final String AUDIENCE_TYPE_DIVERSITY = "Audience type diversity";
    public static final String AUDIENCE_TYPE_THEME_TRACK_CONFLICT = "Audience type theme track conflict";
    public static final String AUDIENCE_LEVEL_DIVERSITY = "Audience level diversity";
    public static final String AUDIENCE_LEVEL_FLOW_PER_CONTENT_VIOLATION = "Audience level flow per content violation";
    public static final String CONTENT_CONFLICT = "Content conflict";
    public static final String LANGUAGE_DIVERSITY = "Language diversity";
    public static final String SPEAKER_PREFERRED_TIMESLOT_TAGS = "Speaker preferred timeslot tags";
    public static final String SPEAKER_UNDESIRED_TIMESLOT_TAGS = "Speaker undesired timeslot tags";
    public static final String TALK_PREFERRED_TIMESLOT_TAGS = "Talk preferred timeslot tags";
    public static final String TALK_UNDESIRED_TIMESLOT_TAGS = "Talk undesired timeslot tags";
    public static final String SPEAKER_PREFERRED_ROOM_TAGS = "Speaker preferred room tags";
    public static final String SPEAKER_UNDESIRED_ROOM_TAGS = "Speaker undesired room tags";
    public static final String TALK_PREFERRED_ROOM_TAGS = "Talk preferred room tags";
    public static final String TALK_UNDESIRED_ROOM_TAGS = "Talk undesired room tags";
    public static final String SAME_DAY_TALKS = "Same day talks";
    public static final String POPULAR_TALKS = "Popular talks";
    public static final String CROWD_CONTROL = "Crowd control";
    public static final String PUBLISHED_ROOM = "Published room";
    public static final String ROOM_STABILITY = "Room stability";
    private int minimumConsecutiveTalksPauseInMinutes = 30;
    @ConstraintWeight(value="Talk type of timeslot")
    private HardMediumSoftScore talkTypeOfTimeslot = HardMediumSoftScore.ofHard((int)10000);
    @ConstraintWeight(value="Talk type of room")
    private HardMediumSoftScore talkTypeOfRoom = HardMediumSoftScore.ofHard((int)10000);
    @ConstraintWeight(value="Room unavailable timeslot")
    private HardMediumSoftScore roomUnavailableTimeslot = HardMediumSoftScore.ofHard((int)10000);
    @ConstraintWeight(value="Room conflict")
    private HardMediumSoftScore roomConflict = HardMediumSoftScore.ofHard((int)10);
    @ConstraintWeight(value="Speaker unavailable timeslot")
    private HardMediumSoftScore speakerUnavailableTimeslot = HardMediumSoftScore.ofHard((int)1);
    @ConstraintWeight(value="Speaker conflict")
    private HardMediumSoftScore speakerConflict = HardMediumSoftScore.ofHard((int)1);
    @ConstraintWeight(value="Speaker required timeslot tags")
    private HardMediumSoftScore speakerRequiredTimeslotTags = HardMediumSoftScore.ofHard((int)1);
    @ConstraintWeight(value="Speaker prohibited timeslot tags")
    private HardMediumSoftScore speakerProhibitedTimeslotTags = HardMediumSoftScore.ofHard((int)1);
    @ConstraintWeight(value="Talk required timeslot tags")
    private HardMediumSoftScore talkRequiredTimeslotTags = HardMediumSoftScore.ofHard((int)1);
    @ConstraintWeight(value="Talk prohibited timeslot tags")
    private HardMediumSoftScore talkProhibitedTimeslotTags = HardMediumSoftScore.ofHard((int)1);
    @ConstraintWeight(value="Speaker required room tags")
    private HardMediumSoftScore speakerRequiredRoomTags = HardMediumSoftScore.ofHard((int)1);
    @ConstraintWeight(value="Speaker prohibited room tags")
    private HardMediumSoftScore speakerProhibitedRoomTags = HardMediumSoftScore.ofHard((int)1);
    @ConstraintWeight(value="Talk required room tags")
    private HardMediumSoftScore talkRequiredRoomTags = HardMediumSoftScore.ofHard((int)1);
    @ConstraintWeight(value="Talk prohibited room tags")
    private HardMediumSoftScore talkProhibitedRoomTags = HardMediumSoftScore.ofHard((int)1);
    @ConstraintWeight(value="Talk prerequisite talks")
    private HardMediumSoftScore talkPrerequisiteTalks = HardMediumSoftScore.ofHard((int)1);
    @ConstraintWeight(value="Consecutive talks pause")
    private HardMediumSoftScore consecutiveTalksPause = HardMediumSoftScore.ofHard((int)1);
    @ConstraintWeight(value="Talk mutually-exclusive-talks tags")
    private HardMediumSoftScore talkMutuallyExclusiveTalksTags = HardMediumSoftScore.ofHard((int)1);
    @ConstraintWeight(value="Published timeslot")
    private HardMediumSoftScore publishedTimeslot = HardMediumSoftScore.ofMedium((int)1);
    @ConstraintWeight(value="Theme track conflict")
    private HardMediumSoftScore themeTrackConflict = HardMediumSoftScore.ofSoft((int)10);
    @ConstraintWeight(value="Sector conflict")
    private HardMediumSoftScore sectorConflict = HardMediumSoftScore.ofSoft((int)10);
    @ConstraintWeight(value="Audience type diversity")
    private HardMediumSoftScore audienceTypeDiversity = HardMediumSoftScore.ofSoft((int)1);
    @ConstraintWeight(value="Audience type theme track conflict")
    private HardMediumSoftScore audienceTypeThemeTrackConflict = HardMediumSoftScore.ofSoft((int)0);
    @ConstraintWeight(value="Audience level diversity")
    private HardMediumSoftScore audienceLevelDiversity = HardMediumSoftScore.ofSoft((int)1);
    @ConstraintWeight(value="Audience level flow per content violation")
    private HardMediumSoftScore audienceLevelFlowPerContentViolation = HardMediumSoftScore.ofSoft((int)10);
    @ConstraintWeight(value="Content conflict")
    private HardMediumSoftScore contentConflict = HardMediumSoftScore.ofSoft((int)100);
    @ConstraintWeight(value="Language diversity")
    private HardMediumSoftScore languageDiversity = HardMediumSoftScore.ofSoft((int)10);
    @ConstraintWeight(value="Speaker preferred timeslot tags")
    private HardMediumSoftScore speakerPreferredTimeslotTags = HardMediumSoftScore.ofSoft((int)20);
    @ConstraintWeight(value="Speaker undesired timeslot tags")
    private HardMediumSoftScore speakerUndesiredTimeslotTags = HardMediumSoftScore.ofSoft((int)20);
    @ConstraintWeight(value="Talk preferred timeslot tags")
    private HardMediumSoftScore talkPreferredTimeslotTags = HardMediumSoftScore.ofSoft((int)20);
    @ConstraintWeight(value="Talk undesired timeslot tags")
    private HardMediumSoftScore talkUndesiredTimeslotTags = HardMediumSoftScore.ofSoft((int)20);
    @ConstraintWeight(value="Speaker preferred room tags")
    private HardMediumSoftScore speakerPreferredRoomTags = HardMediumSoftScore.ofSoft((int)20);
    @ConstraintWeight(value="Speaker undesired room tags")
    private HardMediumSoftScore speakerUndesiredRoomTags = HardMediumSoftScore.ofSoft((int)20);
    @ConstraintWeight(value="Talk preferred room tags")
    private HardMediumSoftScore talkPreferredRoomTags = HardMediumSoftScore.ofSoft((int)20);
    @ConstraintWeight(value="Talk undesired room tags")
    private HardMediumSoftScore talkUndesiredRoomTags = HardMediumSoftScore.ofSoft((int)20);
    @ConstraintWeight(value="Same day talks")
    private HardMediumSoftScore sameDayTalks = HardMediumSoftScore.ofSoft((int)10);
    @ConstraintWeight(value="Popular talks")
    private HardMediumSoftScore popularTalks = HardMediumSoftScore.ofSoft((int)10);
    @ConstraintWeight(value="Crowd control")
    private HardMediumSoftScore crowdControl = HardMediumSoftScore.ofSoft((int)10);
    @ConstraintWeight(value="Published room")
    private HardMediumSoftScore publishedRoom = HardMediumSoftScore.ofSoft((int)10);
    @ConstraintWeight(value="Room stability")
    private HardMediumSoftScore roomStability = HardMediumSoftScore.ofSoft((int)10);

    public ConferenceConstraintConfiguration() {
    }

    public ConferenceConstraintConfiguration(long id) {
        super(id);
    }

    public int getMinimumConsecutiveTalksPauseInMinutes() {
        return this.minimumConsecutiveTalksPauseInMinutes;
    }

    public void setMinimumConsecutiveTalksPauseInMinutes(int minimumConsecutiveTalksPauseInMinutes) {
        this.minimumConsecutiveTalksPauseInMinutes = minimumConsecutiveTalksPauseInMinutes;
    }

    public HardMediumSoftScore getTalkTypeOfTimeslot() {
        return this.talkTypeOfTimeslot;
    }

    public HardMediumSoftScore getTalkTypeOfRoom() {
        return this.talkTypeOfRoom;
    }

    public void setTalkTypeOfRoom(HardMediumSoftScore talkTypeOfRoom) {
        this.talkTypeOfRoom = talkTypeOfRoom;
    }

    public void setTalkTypeOfTimeslot(HardMediumSoftScore talkTypeOfTimeslot) {
        this.talkTypeOfTimeslot = talkTypeOfTimeslot;
    }

    public HardMediumSoftScore getRoomUnavailableTimeslot() {
        return this.roomUnavailableTimeslot;
    }

    public void setRoomUnavailableTimeslot(HardMediumSoftScore roomUnavailableTimeslot) {
        this.roomUnavailableTimeslot = roomUnavailableTimeslot;
    }

    public HardMediumSoftScore getRoomConflict() {
        return this.roomConflict;
    }

    public void setRoomConflict(HardMediumSoftScore roomConflict) {
        this.roomConflict = roomConflict;
    }

    public HardMediumSoftScore getSpeakerUnavailableTimeslot() {
        return this.speakerUnavailableTimeslot;
    }

    public void setSpeakerUnavailableTimeslot(HardMediumSoftScore speakerUnavailableTimeslot) {
        this.speakerUnavailableTimeslot = speakerUnavailableTimeslot;
    }

    public HardMediumSoftScore getSpeakerConflict() {
        return this.speakerConflict;
    }

    public void setSpeakerConflict(HardMediumSoftScore speakerConflict) {
        this.speakerConflict = speakerConflict;
    }

    public HardMediumSoftScore getSpeakerRequiredTimeslotTags() {
        return this.speakerRequiredTimeslotTags;
    }

    public void setSpeakerRequiredTimeslotTags(HardMediumSoftScore speakerRequiredTimeslotTags) {
        this.speakerRequiredTimeslotTags = speakerRequiredTimeslotTags;
    }

    public HardMediumSoftScore getSpeakerProhibitedTimeslotTags() {
        return this.speakerProhibitedTimeslotTags;
    }

    public void setSpeakerProhibitedTimeslotTags(HardMediumSoftScore speakerProhibitedTimeslotTags) {
        this.speakerProhibitedTimeslotTags = speakerProhibitedTimeslotTags;
    }

    public HardMediumSoftScore getTalkRequiredTimeslotTags() {
        return this.talkRequiredTimeslotTags;
    }

    public void setTalkRequiredTimeslotTags(HardMediumSoftScore talkRequiredTimeslotTags) {
        this.talkRequiredTimeslotTags = talkRequiredTimeslotTags;
    }

    public HardMediumSoftScore getTalkProhibitedTimeslotTags() {
        return this.talkProhibitedTimeslotTags;
    }

    public void setTalkProhibitedTimeslotTags(HardMediumSoftScore talkProhibitedTimeslotTags) {
        this.talkProhibitedTimeslotTags = talkProhibitedTimeslotTags;
    }

    public HardMediumSoftScore getSpeakerRequiredRoomTags() {
        return this.speakerRequiredRoomTags;
    }

    public void setSpeakerRequiredRoomTags(HardMediumSoftScore speakerRequiredRoomTags) {
        this.speakerRequiredRoomTags = speakerRequiredRoomTags;
    }

    public HardMediumSoftScore getSpeakerProhibitedRoomTags() {
        return this.speakerProhibitedRoomTags;
    }

    public void setSpeakerProhibitedRoomTags(HardMediumSoftScore speakerProhibitedRoomTags) {
        this.speakerProhibitedRoomTags = speakerProhibitedRoomTags;
    }

    public HardMediumSoftScore getTalkRequiredRoomTags() {
        return this.talkRequiredRoomTags;
    }

    public void setTalkRequiredRoomTags(HardMediumSoftScore talkRequiredRoomTags) {
        this.talkRequiredRoomTags = talkRequiredRoomTags;
    }

    public HardMediumSoftScore getTalkProhibitedRoomTags() {
        return this.talkProhibitedRoomTags;
    }

    public void setTalkProhibitedRoomTags(HardMediumSoftScore talkProhibitedRoomTags) {
        this.talkProhibitedRoomTags = talkProhibitedRoomTags;
    }

    public HardMediumSoftScore getTalkMutuallyExclusiveTalksTags() {
        return this.talkMutuallyExclusiveTalksTags;
    }

    public void setTalkMutuallyExclusiveTalksTags(HardMediumSoftScore talkMutuallyExclusiveTalksTags) {
        this.talkMutuallyExclusiveTalksTags = talkMutuallyExclusiveTalksTags;
    }

    public HardMediumSoftScore getPublishedTimeslot() {
        return this.publishedTimeslot;
    }

    public void setPublishedTimeslot(HardMediumSoftScore publishedTimeslot) {
        this.publishedTimeslot = publishedTimeslot;
    }

    public HardMediumSoftScore getThemeTrackConflict() {
        return this.themeTrackConflict;
    }

    public void setThemeTrackConflict(HardMediumSoftScore themeTrackConflict) {
        this.themeTrackConflict = themeTrackConflict;
    }

    public HardMediumSoftScore getSectorConflict() {
        return this.sectorConflict;
    }

    public void setSectorConflict(HardMediumSoftScore sectorConflict) {
        this.sectorConflict = sectorConflict;
    }

    public HardMediumSoftScore getAudienceTypeDiversity() {
        return this.audienceTypeDiversity;
    }

    public void setAudienceTypeDiversity(HardMediumSoftScore audienceTypeDiversity) {
        this.audienceTypeDiversity = audienceTypeDiversity;
    }

    public HardMediumSoftScore getAudienceTypeThemeTrackConflict() {
        return this.audienceTypeThemeTrackConflict;
    }

    public void setAudienceTypeThemeTrackConflict(HardMediumSoftScore audienceTypeThemeTrackConflict) {
        this.audienceTypeThemeTrackConflict = audienceTypeThemeTrackConflict;
    }

    public HardMediumSoftScore getAudienceLevelDiversity() {
        return this.audienceLevelDiversity;
    }

    public void setAudienceLevelDiversity(HardMediumSoftScore audienceLevelDiversity) {
        this.audienceLevelDiversity = audienceLevelDiversity;
    }

    public HardMediumSoftScore getAudienceLevelFlowPerContentViolation() {
        return this.audienceLevelFlowPerContentViolation;
    }

    public void setAudienceLevelFlowPerContentViolation(HardMediumSoftScore audienceLevelFlowPerContentViolation) {
        this.audienceLevelFlowPerContentViolation = audienceLevelFlowPerContentViolation;
    }

    public HardMediumSoftScore getContentConflict() {
        return this.contentConflict;
    }

    public void setContentConflict(HardMediumSoftScore contentConflict) {
        this.contentConflict = contentConflict;
    }

    public HardMediumSoftScore getLanguageDiversity() {
        return this.languageDiversity;
    }

    public void setLanguageDiversity(HardMediumSoftScore languageDiversity) {
        this.languageDiversity = languageDiversity;
    }

    public HardMediumSoftScore getSpeakerPreferredTimeslotTags() {
        return this.speakerPreferredTimeslotTags;
    }

    public void setSpeakerPreferredTimeslotTags(HardMediumSoftScore speakerPreferredTimeslotTags) {
        this.speakerPreferredTimeslotTags = speakerPreferredTimeslotTags;
    }

    public HardMediumSoftScore getSpeakerUndesiredTimeslotTags() {
        return this.speakerUndesiredTimeslotTags;
    }

    public void setSpeakerUndesiredTimeslotTags(HardMediumSoftScore speakerUndesiredTimeslotTags) {
        this.speakerUndesiredTimeslotTags = speakerUndesiredTimeslotTags;
    }

    public HardMediumSoftScore getTalkPreferredTimeslotTags() {
        return this.talkPreferredTimeslotTags;
    }

    public void setTalkPreferredTimeslotTags(HardMediumSoftScore talkPreferredTimeslotTags) {
        this.talkPreferredTimeslotTags = talkPreferredTimeslotTags;
    }

    public HardMediumSoftScore getTalkUndesiredTimeslotTags() {
        return this.talkUndesiredTimeslotTags;
    }

    public void setTalkUndesiredTimeslotTags(HardMediumSoftScore talkUndesiredTimeslotTags) {
        this.talkUndesiredTimeslotTags = talkUndesiredTimeslotTags;
    }

    public HardMediumSoftScore getSpeakerPreferredRoomTags() {
        return this.speakerPreferredRoomTags;
    }

    public void setSpeakerPreferredRoomTags(HardMediumSoftScore speakerPreferredRoomTags) {
        this.speakerPreferredRoomTags = speakerPreferredRoomTags;
    }

    public HardMediumSoftScore getSpeakerUndesiredRoomTags() {
        return this.speakerUndesiredRoomTags;
    }

    public void setSpeakerUndesiredRoomTags(HardMediumSoftScore speakerUndesiredRoomTags) {
        this.speakerUndesiredRoomTags = speakerUndesiredRoomTags;
    }

    public HardMediumSoftScore getTalkPreferredRoomTags() {
        return this.talkPreferredRoomTags;
    }

    public void setTalkPreferredRoomTags(HardMediumSoftScore talkPreferredRoomTags) {
        this.talkPreferredRoomTags = talkPreferredRoomTags;
    }

    public HardMediumSoftScore getTalkUndesiredRoomTags() {
        return this.talkUndesiredRoomTags;
    }

    public void setTalkUndesiredRoomTags(HardMediumSoftScore talkUndesiredRoomTags) {
        this.talkUndesiredRoomTags = talkUndesiredRoomTags;
    }

    public HardMediumSoftScore getTalkPrerequisiteTalks() {
        return this.talkPrerequisiteTalks;
    }

    public void setTalkPrerequisiteTalks(HardMediumSoftScore talkPrerequisiteTalks) {
        this.talkPrerequisiteTalks = talkPrerequisiteTalks;
    }

    public HardMediumSoftScore getConsecutiveTalksPause() {
        return this.consecutiveTalksPause;
    }

    public void setConsecutiveTalksPause(HardMediumSoftScore consecutiveTalksPause) {
        this.consecutiveTalksPause = consecutiveTalksPause;
    }

    public HardMediumSoftScore getSameDayTalks() {
        return this.sameDayTalks;
    }

    public void setSameDayTalks(HardMediumSoftScore sameDayTalks) {
        this.sameDayTalks = sameDayTalks;
    }

    public HardMediumSoftScore getPopularTalks() {
        return this.popularTalks;
    }

    public void setPopularTalks(HardMediumSoftScore popularTalks) {
        this.popularTalks = popularTalks;
    }

    public HardMediumSoftScore getCrowdControl() {
        return this.crowdControl;
    }

    public void setCrowdControl(HardMediumSoftScore crowdControl) {
        this.crowdControl = crowdControl;
    }

    public HardMediumSoftScore getPublishedRoom() {
        return this.publishedRoom;
    }

    public void setPublishedRoom(HardMediumSoftScore publishedRoom) {
        this.publishedRoom = publishedRoom;
    }

    public HardMediumSoftScore getRoomStability() {
        return this.roomStability;
    }

    public void setRoomStability(HardMediumSoftScore roomStability) {
        this.roomStability = roomStability;
    }
}

