/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.nqueens.domain.solution;

import org.apache.commons.lang3.builder.CompareToBuilder;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorterWeightFactory;
import org.optaplanner.examples.nqueens.domain.NQueens;
import org.optaplanner.examples.nqueens.domain.Queen;

public class QueenDifficultyWeightFactory
implements SelectionSorterWeightFactory<NQueens, Queen> {
    public QueenDifficultyWeight createSorterWeight(NQueens nQueens, Queen queen) {
        int distanceFromMiddle = QueenDifficultyWeightFactory.calculateDistanceFromMiddle(nQueens.getN(), queen.getColumnIndex());
        return new QueenDifficultyWeight(queen, distanceFromMiddle);
    }

    private static int calculateDistanceFromMiddle(int n, int columnIndex) {
        int middle = n / 2;
        int distanceFromMiddle = Math.abs(columnIndex - middle);
        if (n % 2 == 0 && columnIndex < middle) {
            --distanceFromMiddle;
        }
        return distanceFromMiddle;
    }

    public static class QueenDifficultyWeight
    implements Comparable<QueenDifficultyWeight> {
        private final Queen queen;
        private final int distanceFromMiddle;

        public QueenDifficultyWeight(Queen queen, int distanceFromMiddle) {
            this.queen = queen;
            this.distanceFromMiddle = distanceFromMiddle;
        }

        @Override
        public int compareTo(QueenDifficultyWeight other) {
            return new CompareToBuilder().append(other.distanceFromMiddle, this.distanceFromMiddle).append(this.queen.getColumnIndex(), other.queen.getColumnIndex()).toComparison();
        }
    }
}

