/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.machinereassignment.swingui;

import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.optaplanner.examples.common.swingui.SolutionPanel;
import org.optaplanner.examples.machinereassignment.domain.MachineReassignment;
import org.optaplanner.examples.machinereassignment.domain.MrMachine;
import org.optaplanner.examples.machinereassignment.domain.MrProcessAssignment;
import org.optaplanner.examples.machinereassignment.domain.MrResource;
import org.optaplanner.examples.machinereassignment.swingui.MrMachinePanel;

public class MachineReassignmentPanel
extends SolutionPanel<MachineReassignment> {
    public static final String LOGO_PATH = "/org/optaplanner/examples/machinereassignment/swingui/machineReassignmentLogo.png";
    private JPanel machineListPanel;
    private MrMachinePanel unassignedPanel;
    private JLabel tooBigLabel = null;
    private Map<MrMachine, MrMachinePanel> machineToPanelMap;

    public MachineReassignmentPanel() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        this.createMachineListPanel();
        JPanel headerPanel = new JPanel();
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(headerPanel).addComponent(this.machineListPanel));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(headerPanel, -2, -2, -2).addComponent(this.machineListPanel, -2, -2, -2));
    }

    private void createMachineListPanel() {
        this.machineListPanel = new JPanel(new GridLayout(0, 1));
        this.unassignedPanel = new MrMachinePanel(this, Collections.emptyList(), null);
        this.machineListPanel.add(this.unassignedPanel);
        this.machineToPanelMap = new LinkedHashMap<MrMachine, MrMachinePanel>();
        this.machineToPanelMap.put(null, this.unassignedPanel);
    }

    @Override
    public void resetPanel(MachineReassignment machineReassignment) {
        for (MrMachinePanel machinePanel : this.machineToPanelMap.values()) {
            if (machinePanel.getMachine() == null) continue;
            this.machineListPanel.remove(machinePanel);
        }
        this.machineToPanelMap.clear();
        this.machineToPanelMap.put(null, this.unassignedPanel);
        this.unassignedPanel.clearProcessAssignments();
        this.updatePanel(machineReassignment);
    }

    @Override
    public void updatePanel(MachineReassignment machineReassignment) {
        List<MrResource> resourceList = machineReassignment.getResourceList();
        this.unassignedPanel.setResourceList(resourceList);
        if (machineReassignment.getMachineList().size() > 1000) {
            if (this.tooBigLabel == null) {
                this.tooBigLabel = new JLabel("The dataset is too big to show.");
                this.machineListPanel.add(this.tooBigLabel);
            }
        } else {
            if (this.tooBigLabel != null) {
                this.machineListPanel.remove(this.tooBigLabel);
                this.tooBigLabel = null;
            }
            LinkedHashSet<MrMachine> deadMachineSet = new LinkedHashSet<MrMachine>(this.machineToPanelMap.keySet());
            deadMachineSet.remove(null);
            for (MrMachine machine : machineReassignment.getMachineList()) {
                deadMachineSet.remove(machine);
                MrMachinePanel machinePanel = this.machineToPanelMap.get(machine);
                if (machinePanel == null) {
                    machinePanel = new MrMachinePanel(this, resourceList, machine);
                    this.machineListPanel.add(machinePanel);
                    this.machineToPanelMap.put(machine, machinePanel);
                }
                machinePanel.clearProcessAssignments();
            }
            this.unassignedPanel.clearProcessAssignments();
            for (MrProcessAssignment processAssignment : machineReassignment.getProcessAssignmentList()) {
                MrMachine machine = processAssignment.getMachine();
                MrMachinePanel machinePanel = this.machineToPanelMap.get(machine);
                machinePanel.addProcessAssignment(processAssignment);
            }
            for (MrMachine deadMachine : deadMachineSet) {
                MrMachinePanel deadMachinePanel = this.machineToPanelMap.remove(deadMachine);
                this.machineListPanel.remove(deadMachinePanel);
            }
            for (MrMachinePanel machinePanel : this.machineToPanelMap.values()) {
                machinePanel.update();
            }
        }
    }

    public void deleteMachine(MrMachine machine) {
        this.logger.info("Scheduling delete of machine ({}).", (Object)machine);
        this.doProblemChange((machineReassignment, problemChangeDirector) -> {
            MrMachine workingMachine = (MrMachine)problemChangeDirector.lookUpWorkingObjectOrFail((Object)machine);
            if (workingMachine == null) {
                return;
            }
            for (MrProcessAssignment processAssignment : machineReassignment.getProcessAssignmentList()) {
                if (processAssignment.getOriginalMachine() == workingMachine) {
                    problemChangeDirector.changeProblemProperty((Object)processAssignment, workingProcessAssignment -> workingProcessAssignment.setOriginalMachine(null));
                }
                if (processAssignment.getMachine() != workingMachine) continue;
                problemChangeDirector.changeVariable((Object)processAssignment, "machine", workingProcessAssignment -> workingProcessAssignment.setMachine(null));
            }
            ArrayList<MrMachine> machineList = new ArrayList<MrMachine>(machineReassignment.getMachineList());
            machineReassignment.setMachineList(machineList);
            problemChangeDirector.removeProblemFact((Object)workingMachine, machineList::remove);
        });
    }
}

