/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.app;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.optaplanner.examples.batchscheduling.app.BatchSchedulingApp;
import org.optaplanner.examples.cheaptime.app.CheapTimeApp;
import org.optaplanner.examples.cloudbalancing.app.CloudBalancingApp;
import org.optaplanner.examples.coachshuttlegathering.app.CoachShuttleGatheringApp;
import org.optaplanner.examples.common.app.CommonApp;
import org.optaplanner.examples.common.swingui.OpenBrowserAction;
import org.optaplanner.examples.common.swingui.SolverAndPersistenceFrame;
import org.optaplanner.examples.conferencescheduling.app.ConferenceSchedulingApp;
import org.optaplanner.examples.curriculumcourse.app.CurriculumCourseApp;
import org.optaplanner.examples.examination.app.ExaminationApp;
import org.optaplanner.examples.flightcrewscheduling.app.FlightCrewSchedulingApp;
import org.optaplanner.examples.investment.app.InvestmentApp;
import org.optaplanner.examples.machinereassignment.app.MachineReassignmentApp;
import org.optaplanner.examples.meetingscheduling.app.MeetingSchedulingApp;
import org.optaplanner.examples.nqueens.app.NQueensApp;
import org.optaplanner.examples.nurserostering.app.NurseRosteringApp;
import org.optaplanner.examples.pas.app.PatientAdmissionScheduleApp;
import org.optaplanner.examples.projectjobscheduling.app.ProjectJobSchedulingApp;
import org.optaplanner.examples.rocktour.app.RockTourApp;
import org.optaplanner.examples.taskassigning.app.TaskAssigningApp;
import org.optaplanner.examples.tennis.app.TennisApp;
import org.optaplanner.examples.travelingtournament.app.TravelingTournamentApp;
import org.optaplanner.examples.tsp.app.TspApp;
import org.optaplanner.examples.vehiclerouting.app.VehicleRoutingApp;

public class OptaPlannerExamplesApp
extends JFrame {
    private JTextArea descriptionTextArea;

    public static void main(String[] args) {
        CommonApp.prepareSwingEnvironment();
        OptaPlannerExamplesApp optaPlannerExamplesApp = new OptaPlannerExamplesApp();
        optaPlannerExamplesApp.pack();
        optaPlannerExamplesApp.setLocationRelativeTo(null);
        optaPlannerExamplesApp.setVisible(true);
    }

    private static String determineOptaPlannerExamplesVersion() {
        String optaPlannerExamplesVersion = OptaPlannerExamplesApp.class.getPackage().getImplementationVersion();
        if (optaPlannerExamplesVersion == null) {
            optaPlannerExamplesVersion = "";
        }
        return optaPlannerExamplesVersion;
    }

    public OptaPlannerExamplesApp() {
        super("OptaPlanner examples " + OptaPlannerExamplesApp.determineOptaPlannerExamplesVersion());
        this.setIconImage(SolverAndPersistenceFrame.OPTA_PLANNER_ICON.getImage());
        this.setContentPane(this.createContentPane());
        this.setDefaultCloseOperation(3);
    }

    private Container createContentPane() {
        JPanel contentPane = new JPanel(new BorderLayout(5, 5));
        contentPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel titleLabel = new JLabel("Which example do you want to see?", 0);
        titleLabel.setFont(titleLabel.getFont().deriveFont(20.0f));
        contentPane.add((Component)titleLabel, "North");
        JScrollPane examplesScrollPane = new JScrollPane(this.createExamplesPanel());
        examplesScrollPane.getHorizontalScrollBar().setUnitIncrement(20);
        examplesScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        examplesScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        contentPane.add((Component)examplesScrollPane, "Center");
        JPanel bottomPanel = new JPanel(new BorderLayout(5, 5));
        bottomPanel.add((Component)this.createDescriptionPanel(), "Center");
        bottomPanel.add((Component)this.createExtraPanel(), "East");
        contentPane.add((Component)bottomPanel, "South");
        return contentPane;
    }

    private JPanel createExamplesPanel() {
        JPanel panel = new JPanel(new GridLayout(0, 3, 5, 5));
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.add(this.createExampleButton(new NurseRosteringApp()));
        panel.add(this.createExampleButton(new TspApp()));
        panel.add(this.createExampleButton(new TaskAssigningApp()));
        panel.add(this.createExampleButton(new CloudBalancingApp()));
        panel.add(this.createExampleButton(new ConferenceSchedulingApp()));
        panel.add(this.createExampleButton(new VehicleRoutingApp()));
        panel.add(this.createExampleButton(new PatientAdmissionScheduleApp()));
        panel.add(this.createExampleButton(new MachineReassignmentApp()));
        panel.add(this.createExampleButton(new CurriculumCourseApp()));
        panel.add(this.createExampleButton(new RockTourApp()));
        panel.add(this.createExampleButton(new ProjectJobSchedulingApp()));
        panel.add(this.createExampleButton(new BatchSchedulingApp()));
        panel.add(this.createExampleButton(new ExaminationApp()));
        panel.add(this.createExampleButton(new CoachShuttleGatheringApp()));
        panel.add(this.createExampleButton(new CheapTimeApp()));
        panel.add(this.createExampleButton(new MeetingSchedulingApp()));
        panel.add(this.createExampleButton(new TravelingTournamentApp()));
        panel.add(this.createExampleButton(new InvestmentApp()));
        panel.add(this.createExampleButton(new TennisApp()));
        panel.add(this.createExampleButton(new FlightCrewSchedulingApp()));
        panel.add(this.createExampleButton(new NQueensApp()));
        return panel;
    }

    private JButton createExampleButton(final CommonApp commonApp) {
        String iconResource = commonApp.getIconResource();
        Icon icon = iconResource == null ? new EmptyIcon() : new ImageIcon(this.getClass().getResource(iconResource));
        JButton button = new JButton(new AbstractAction(commonApp.getName(), icon){

            @Override
            public void actionPerformed(ActionEvent e) {
                commonApp.init(OptaPlannerExamplesApp.this, false);
            }
        });
        button.setHorizontalAlignment(2);
        button.setHorizontalTextPosition(4);
        button.setVerticalTextPosition(0);
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                OptaPlannerExamplesApp.this.descriptionTextArea.setText(commonApp.getDescription());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                OptaPlannerExamplesApp.this.descriptionTextArea.setText("");
            }
        });
        return button;
    }

    private JPanel createDescriptionPanel() {
        JPanel descriptionPanel = new JPanel(new BorderLayout(2, 2));
        descriptionPanel.add((Component)new JLabel("Description"), "North");
        this.descriptionTextArea = new JTextArea(8, 65);
        this.descriptionTextArea.setEditable(false);
        this.descriptionTextArea.setLineWrap(true);
        this.descriptionTextArea.setWrapStyleWord(true);
        descriptionPanel.add((Component)new JScrollPane(this.descriptionTextArea, 22, 31), "Center");
        return descriptionPanel;
    }

    private JPanel createExtraPanel() {
        JPanel extraPanel = new JPanel(new GridLayout(0, 1, 5, 5));
        extraPanel.add(new JPanel());
        OpenBrowserAction homepageAction = new OpenBrowserAction("www.optaplanner.org", "https://www.optaplanner.org");
        extraPanel.add(new JButton(homepageAction));
        OpenBrowserAction documentationAction = new OpenBrowserAction("Documentation", "https://www.optaplanner.org/learn/documentation.html");
        extraPanel.add(new JButton(documentationAction));
        return extraPanel;
    }

    private static class EmptyIcon
    implements Icon {
        private EmptyIcon() {
        }

        @Override
        public int getIconWidth() {
            return 64;
        }

        @Override
        public int getIconHeight() {
            return 64;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
        }
    }
}

