/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.coachshuttlegathering.domain.solver;

import java.util.List;
import java.util.Objects;
import org.optaplanner.core.api.domain.variable.VariableListener;
import org.optaplanner.core.api.score.director.ScoreDirector;
import org.optaplanner.examples.coachshuttlegathering.domain.Bus;
import org.optaplanner.examples.coachshuttlegathering.domain.BusOrStop;
import org.optaplanner.examples.coachshuttlegathering.domain.BusStop;
import org.optaplanner.examples.coachshuttlegathering.domain.CoachShuttleGatheringSolution;
import org.optaplanner.examples.coachshuttlegathering.domain.Shuttle;
import org.optaplanner.examples.coachshuttlegathering.domain.StopOrHub;

public class TransportTimeToHubUpdatingVariableListener
implements VariableListener<CoachShuttleGatheringSolution, BusOrStop> {
    public void beforeEntityAdded(ScoreDirector<CoachShuttleGatheringSolution> scoreDirector, BusOrStop busOrStop) {
    }

    public void afterEntityAdded(ScoreDirector<CoachShuttleGatheringSolution> scoreDirector, BusOrStop busOrStop) {
        if (busOrStop instanceof BusStop) {
            this.updateTransportTimeToHub(scoreDirector, (BusStop)busOrStop);
        } else if (busOrStop instanceof Shuttle) {
            this.updateTransportTimeToHubOfShuttle(scoreDirector, (Shuttle)busOrStop);
        }
    }

    public void beforeVariableChanged(ScoreDirector<CoachShuttleGatheringSolution> scoreDirector, BusOrStop busOrStop) {
    }

    public void afterVariableChanged(ScoreDirector<CoachShuttleGatheringSolution> scoreDirector, BusOrStop busOrStop) {
        if (busOrStop instanceof BusStop) {
            this.updateTransportTimeToHub(scoreDirector, (BusStop)busOrStop);
        } else if (busOrStop instanceof Shuttle) {
            this.updateTransportTimeToHubOfShuttle(scoreDirector, (Shuttle)busOrStop);
        }
    }

    public void beforeEntityRemoved(ScoreDirector<CoachShuttleGatheringSolution> scoreDirector, BusOrStop busOrStop) {
    }

    public void afterEntityRemoved(ScoreDirector<CoachShuttleGatheringSolution> scoreDirector, BusOrStop busOrStop) {
    }

    protected void updateTransportTimeToHub(ScoreDirector<CoachShuttleGatheringSolution> scoreDirector, BusStop sourceStop) {
        Integer transportTimeToHub;
        Bus bus = sourceStop.getBus();
        if (bus == null) {
            transportTimeToHub = null;
        } else {
            StopOrHub destination = bus.getDestination();
            if (destination instanceof BusStop && ((BusStop)destination).getBus() instanceof Shuttle) {
                transportTimeToHub = null;
            } else {
                StopOrHub next = sourceStop.getNextStop();
                if (next != null) {
                    transportTimeToHub = next.getTransportTimeToHub();
                } else if (destination != null) {
                    transportTimeToHub = destination.getTransportTimeToHub();
                    next = destination;
                } else {
                    transportTimeToHub = null;
                }
                transportTimeToHub = TransportTimeToHubUpdatingVariableListener.addTransportTime(transportTimeToHub, sourceStop, next);
            }
        }
        this.updateTransportTime(scoreDirector, sourceStop, bus, transportTimeToHub);
    }

    private void updateTransportTime(ScoreDirector<CoachShuttleGatheringSolution> scoreDirector, BusStop sourceStop, Bus bus, Integer transportTimeToHub) {
        if (sourceStop == null) {
            throw new IllegalArgumentException("The sourceStop (" + sourceStop + ") cannot be null.");
        }
        if (Objects.equals(sourceStop.getTransportTimeToHub(), transportTimeToHub)) {
            return;
        }
        scoreDirector.beforeVariableChanged((Object)sourceStop, "transportTimeToHub");
        sourceStop.setTransportTimeToHub(transportTimeToHub);
        scoreDirector.afterVariableChanged((Object)sourceStop, "transportTimeToHub");
        this.updateTransportTimeForTransferShuttleList(scoreDirector, sourceStop, bus);
        BusStop toStop = sourceStop;
        BusOrStop busOrStop = sourceStop.getPreviousBusOrStop();
        while (busOrStop instanceof BusStop) {
            BusStop stop = (BusStop)busOrStop;
            transportTimeToHub = TransportTimeToHubUpdatingVariableListener.addTransportTime(transportTimeToHub, stop, toStop);
            scoreDirector.beforeVariableChanged((Object)stop, "transportTimeToHub");
            stop.setTransportTimeToHub(transportTimeToHub);
            scoreDirector.afterVariableChanged((Object)stop, "transportTimeToHub");
            this.updateTransportTimeForTransferShuttleList(scoreDirector, stop, bus);
            toStop = stop;
            busOrStop = stop.getPreviousBusOrStop();
        }
    }

    private void updateTransportTimeForTransferShuttleList(ScoreDirector<CoachShuttleGatheringSolution> scoreDirector, BusStop parentStop, Bus parentBus) {
        List<Shuttle> transferShuttleList = parentStop.getTransferShuttleList();
        if (transferShuttleList.isEmpty()) {
            return;
        }
        Integer parentTransportTimeToHub = parentStop.getTransportTimeToHub();
        if (parentBus instanceof Shuttle) {
            parentTransportTimeToHub = null;
        }
        for (Shuttle shuttle : transferShuttleList) {
            this.updateTransportTimeToHubOfShuttle(scoreDirector, parentStop, parentTransportTimeToHub, shuttle);
        }
    }

    private void updateTransportTimeToHubOfShuttle(ScoreDirector<CoachShuttleGatheringSolution> scoreDirector, Shuttle shuttle) {
        StopOrHub destination = shuttle.getDestination();
        Object destinationTransportTimeToHub = destination != null ? (destination instanceof BusStop && ((BusStop)destination).getBus() instanceof Shuttle ? null : destination.getTransportTimeToHub()) : null;
        this.updateTransportTimeToHubOfShuttle(scoreDirector, destination, (Integer)destinationTransportTimeToHub, shuttle);
    }

    private void updateTransportTimeToHubOfShuttle(ScoreDirector<CoachShuttleGatheringSolution> scoreDirector, StopOrHub parentStop, Integer parentTransportTimeToHub, Shuttle shuttle) {
        if (shuttle.getNextStop() == null) {
            return;
        }
        BusStop lastStop = null;
        for (BusStop stop = shuttle.getNextStop(); stop != null; stop = stop.getNextStop()) {
            lastStop = stop;
        }
        Integer transportTimeToHub = parentTransportTimeToHub;
        transportTimeToHub = TransportTimeToHubUpdatingVariableListener.addTransportTime(transportTimeToHub, lastStop, parentStop);
        this.updateTransportTime(scoreDirector, lastStop, shuttle, transportTimeToHub);
    }

    private static Integer addTransportTime(Integer transportTimeToHub, BusStop fromStop, StopOrHub toStop) {
        if (transportTimeToHub == null) {
            return null;
        }
        return transportTimeToHub + fromStop.getBus().getDurationFromTo(fromStop.getLocation(), toStop.getLocation());
    }
}

