/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.rocktour.domain;

import java.time.LocalDate;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.variable.InverseRelationShadowVariable;
import org.optaplanner.examples.rocktour.domain.RockLocation;
import org.optaplanner.examples.rocktour.domain.RockShow;
import org.optaplanner.examples.rocktour.domain.RockTimeOfDay;

@PlanningEntity
public interface RockStandstill {
    public RockLocation getDepartureLocation();

    public LocalDate getDepartureDate();

    public RockTimeOfDay getDepartureTimeOfDay();

    public RockStandstill getHosWeekStart();

    public Long getHosWeekDrivingSecondsTotal();

    public RockLocation getArrivalLocation();

    default public long getDrivingTimeTo(RockStandstill standstill) {
        return this.getDepartureLocation().getDrivingTimeTo(standstill.getArrivalLocation());
    }

    @InverseRelationShadowVariable(sourceVariableName="previousStandstill")
    public RockShow getNextShow();

    public void setNextShow(RockShow var1);
}

