/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.tsp.persistence;

import java.io.IOException;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.common.persistence.AbstractTxtSolutionExporter;
import org.optaplanner.examples.common.persistence.SolutionConverter;
import org.optaplanner.examples.tsp.domain.Standstill;
import org.optaplanner.examples.tsp.domain.TspSolution;
import org.optaplanner.examples.tsp.domain.location.Location;
import org.optaplanner.examples.tsp.persistence.AbstractSvgTspOutputBuilder;

public class SvgTspPathExporter
extends AbstractTxtSolutionExporter<TspSolution> {
    public static final String OUTPUT_FILE_SUFFIX = "path.svg";

    public static void main(String[] args) {
        SolutionConverter<TspSolution> converter = SolutionConverter.createExportConverter("tsp", TspSolution.class, new SvgTspPathExporter());
        converter.convertAll();
    }

    @Override
    public String getOutputFileSuffix() {
        return OUTPUT_FILE_SUFFIX;
    }

    @Override
    public AbstractTxtSolutionExporter.TxtOutputBuilder<TspSolution> createTxtOutputBuilder() {
        return new SvgTspOutputBuilder();
    }

    public static class SvgTspOutputBuilder
    extends AbstractSvgTspOutputBuilder {
        @Override
        public void writeSolution() throws IOException {
            this.determineSizeAndOffset((TspSolution)this.solution);
            this.writeSvgHeader();
            this.bufferedWriter.write("<path style='stroke:#ff0000;stroke-width:1;fill:none'\n");
            this.bufferedWriter.write("d='\n");
            AbstractPersistable standstill = ((TspSolution)this.solution).getDomicile();
            Location home = standstill.getLocation();
            this.bufferedWriter.write("M ");
            this.bufferedWriter.write(home.getLongitude() + this.offsetX + ",");
            this.bufferedWriter.write(this.height - (home.getLatitude() + this.offsetY) + "\n");
            while (standstill != null) {
                this.bufferedWriter.write("L ");
                Location location = standstill.getLocation();
                this.bufferedWriter.write(location.getLongitude() + this.offsetX + ",");
                this.bufferedWriter.write(this.height - (location.getLatitude() + this.offsetY) + "\n");
                standstill = this.findNextVisit((Standstill)((Object)standstill));
            }
            this.bufferedWriter.write("L ");
            this.bufferedWriter.write(home.getLongitude() + this.offsetX + ",");
            this.bufferedWriter.write(this.height - (home.getLatitude() + this.offsetY) + "\n");
            this.bufferedWriter.write("'/>");
            this.bufferedWriter.write("</svg>\n");
        }
    }
}

