/*
 * Decompiled with CFR 0.152.
 */
package org.organicdesign.fp.collections;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import org.organicdesign.fp.collections.AbstractUnmodSet;
import org.organicdesign.fp.collections.BaseMap;
import org.organicdesign.fp.collections.Equator;
import org.organicdesign.fp.collections.ImMap;
import org.organicdesign.fp.collections.ImSet;
import org.organicdesign.fp.collections.MutableMap;
import org.organicdesign.fp.collections.MutableSet;
import org.organicdesign.fp.collections.PersistentHashMap;
import org.organicdesign.fp.collections.UnmodIterator;

public class PersistentHashSet<E>
extends AbstractUnmodSet<E>
implements ImSet<E>,
Serializable {
    public static final PersistentHashSet<Object> EMPTY = new PersistentHashSet<Object>(PersistentHashMap.EMPTY);
    private final ImMap<E, E> impl;
    private static final long serialVersionUID = 20160904155600L;

    public static <E> PersistentHashSet<E> empty() {
        return EMPTY;
    }

    public static <E> MutableHashSet<E> emptyMutable() {
        return PersistentHashSet.empty().mutable();
    }

    public static <E> PersistentHashSet<E> empty(Equator<E> eq) {
        return new PersistentHashSet<E>(PersistentHashMap.empty(eq));
    }

    public static <E> MutableHashSet<E> emptyMutable(Equator<E> eq) {
        return PersistentHashSet.empty(eq).mutable();
    }

    public static <E> PersistentHashSet<E> of(Iterable<E> elements) {
        PersistentHashSet<E> empty = PersistentHashSet.empty();
        MutableSet ret = empty.mutable();
        for (E e : elements) {
            ret.put((Object)e);
        }
        return (PersistentHashSet)ret.immutable();
    }

    public static <E> PersistentHashSet<E> ofEq(Equator<E> eq, Iterable<E> init) {
        MutableHashSet<E> ret = PersistentHashSet.emptyMutable(eq);
        for (E e : init) {
            ret.put((Object)e);
        }
        return (PersistentHashSet)ret.immutable();
    }

    public static <E> PersistentHashSet<E> ofMap(ImMap<E, ?> map) {
        return new PersistentHashSet<E>(map);
    }

    private PersistentHashSet(ImMap<E, E> i) {
        this.impl = i;
    }

    private Object writeReplace() {
        return new SerializationProxy<E>(this.impl);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        throw new InvalidObjectException("Proxy required");
    }

    @Override
    public boolean contains(Object key) {
        return this.impl.containsKey(key);
    }

    public Equator<E> equator() {
        return this.impl.equator();
    }

    @Override
    public PersistentHashSet<E> without(E key) {
        if (this.contains(key)) {
            return new PersistentHashSet<E>(this.impl.without((Object)key));
        }
        return this;
    }

    @Override
    public PersistentHashSet<E> put(E o) {
        if (this.contains(o)) {
            return this;
        }
        return new PersistentHashSet<E>(this.impl.assoc((Object)o, (Object)o));
    }

    @Override
    public UnmodIterator<E> iterator() {
        return this.impl.keyIterator();
    }

    @Override
    public int size() {
        return this.impl.size();
    }

    @Override
    public MutableHashSet<E> mutable() {
        return new MutableHashSet<E>(this.impl.mutable());
    }

    public static final class MutableHashSet<E>
    extends AbstractUnmodSet<E>
    implements MutableSet<E> {
        MutableMap<E, E> impl;

        MutableHashSet(MutableMap<E, E> impl) {
            this.impl = impl;
        }

        @Override
        public int size() {
            return this.impl.size();
        }

        @Override
        public MutableHashSet<E> put(E val) {
            BaseMap m = this.impl.assoc((Object)val, (Object)val);
            if (m != this.impl) {
                this.impl = m;
            }
            return this;
        }

        @Override
        public UnmodIterator<E> iterator() {
            return this.impl.keyIterator();
        }

        @Override
        public boolean contains(Object key) {
            return this.impl.entry(key).isSome();
        }

        @Override
        public MutableHashSet<E> without(E key) {
            BaseMap m = this.impl.without((Object)key);
            if (m != this.impl) {
                this.impl = m;
            }
            return this;
        }

        @Override
        public PersistentHashSet<E> immutable() {
            return new PersistentHashSet(this.impl.immutable());
        }
    }

    private static class SerializationProxy<K>
    implements Serializable {
        private static final long serialVersionUID = 20160904155600L;
        private final int size;
        private transient ImMap<K, K> theMap;

        SerializationProxy(ImMap<K, K> phm) {
            this.size = phm.size();
            this.theMap = phm;
        }

        private void writeObject(ObjectOutputStream s) throws IOException {
            s.defaultWriteObject();
            for (Map.Entry entry : this.theMap) {
                s.writeObject(entry.getKey());
            }
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            BaseMap tempMap = PersistentHashMap.empty().mutable();
            for (int i = 0; i < this.size; ++i) {
                Object k = s.readObject();
                tempMap = tempMap.assoc(k, k);
            }
            this.theMap = tempMap.immutable();
        }

        private Object readResolve() {
            return PersistentHashSet.ofMap(this.theMap);
        }
    }
}

