/*
 * Decompiled with CFR 0.152.
 */
package org.organicdesign.fp.collections;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.organicdesign.fp.collections.BaseList;
import org.organicdesign.fp.collections.Cowry;
import org.organicdesign.fp.collections.ImList;
import org.organicdesign.fp.collections.MutableList;
import org.organicdesign.fp.collections.UnmodIterable;
import org.organicdesign.fp.collections.UnmodSortedIterable;
import org.organicdesign.fp.collections.UnmodSortedIterator;
import org.organicdesign.fp.indent.IndentUtils;
import org.organicdesign.fp.indent.Indented;
import org.organicdesign.fp.tuple.Tuple2;
import org.organicdesign.fp.tuple.Tuple4;

public abstract class RrbTree<E>
implements BaseList<E>,
Indented {
    private static final int NODE_LENGTH_POW_2 = 5;
    static final int STRICT_NODE_LENGTH = 32;
    private static final int HALF_STRICT_NODE_LENGTH = 16;
    private static final int MIN_NODE_LENGTH = 22;
    private static final int MAX_NODE_LENGTH = 44;
    private static final Leaf EMPTY_LEAF = new Leaf<Object>(Cowry.EMPTY_ARRAY);

    public static <T> ImRrbt<T> empty() {
        return ImRrbt.EMPTY_IM_RRBT;
    }

    public static <T> MutableRrbt<T> emptyMutable() {
        return RrbTree.empty().mutable();
    }

    @Override
    public abstract RrbTree<E> append(E var1);

    abstract void debugValidate();

    @Override
    public abstract E get(int var1);

    public abstract RrbTree<E> insert(int var1, E var2);

    @Override
    public abstract UnmodSortedIterator<E> iterator();

    public abstract RrbTree<E> join(RrbTree<E> var1);

    abstract Node<E> pushFocus();

    @Override
    public abstract RrbTree<E> replace(int var1, E var2);

    @Override
    public abstract int size();

    public abstract Tuple2<? extends RrbTree<E>, ? extends RrbTree<E>> split(int var1);

    public RrbTree<E> without(int index) {
        if (index > 0 && index < this.size() - 1) {
            Tuple2<RrbTree<E>, RrbTree<E>> s1 = this.split(index);
            Tuple2<RrbTree<E>, RrbTree<E>> s2 = s1._2().split(1);
            return s1._1().join(s2._2());
        }
        if (index == 0) {
            return this.split(1)._2();
        }
        if (index == this.size() - 1) {
            return this.split(this.size() - 1)._1();
        }
        throw new IndexOutOfBoundsException("Failed test: 0 <= index < size");
    }

    private static <E> Node<E> eliminateUnnecessaryAncestors(Node<E> n) {
        while (!(n instanceof Leaf) && n.numChildren() == 1) {
            n = n.child(0);
        }
        return n;
    }

    private static <E> Node<E> addAncestor(Node<E> n) {
        return n instanceof Leaf && n.size() == 32 ? new Strict(5, n.size(), new Node[]{n}) : (n instanceof Strict ? new Strict(((Strict)n).shift + 5, n.size(), new Node[]{n}) : new Relaxed(new int[]{n.size()}, new Node[]{n}));
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof List)) {
            return false;
        }
        List that = (List)other;
        return this.size() == that.size() && UnmodSortedIterable.equal(this, UnmodSortedIterable.castFromList(that));
    }

    @Override
    public int hashCode() {
        int ret = 1;
        for (Object item : this) {
            ret *= 31;
            if (item == null) continue;
            ret += item.hashCode();
        }
        return ret;
    }

    @Override
    public abstract String indentedStr(int var1);

    private static <T> Leaf<T> emptyLeaf() {
        return EMPTY_LEAF;
    }

    private static <T> Node<T>[] genericNodeArray(int size) {
        return new Node[size];
    }

    private static StringBuilder showSubNodes(StringBuilder sB, Object[] items, int nextIndent) {
        boolean isFirst = true;
        for (Object n : items) {
            if (isFirst) {
                isFirst = false;
            } else if (items[0] instanceof Leaf) {
                sB.append(" ");
            } else {
                sB.append("\n").append((CharSequence)IndentUtils.indentSpace(nextIndent));
            }
            sB.append(((Node)n).indentedStr(nextIndent));
        }
        return sB;
    }

    final class Iter
    implements UnmodSortedIterator<E> {
        private final IdxNode<E>[] stack;
        private int stackMaxIdx = -1;
        private E[] leafArray;
        private int leafArrayIdx;

        private Iter(Node<E> root) {
            this.stack = new IdxNode[root.height()];
            this.leafArray = this.findLeaf(root);
        }

        private E[] findLeaf(Node<E> node) {
            while (!(node instanceof Leaf)) {
                IdxNode in = new IdxNode(node);
                this.stack[++this.stackMaxIdx] = in;
                node = in.next();
            }
            return ((Leaf)node).items;
        }

        private E[] nextLeafArray() {
            while (this.stackMaxIdx > -1 && !this.stack[this.stackMaxIdx].hasNext()) {
                --this.stackMaxIdx;
            }
            if (this.stackMaxIdx < 0) {
                return Cowry.emptyArray();
            }
            return this.findLeaf(this.stack[this.stackMaxIdx].next());
        }

        @Override
        public boolean hasNext() {
            if (this.leafArrayIdx < this.leafArray.length) {
                return true;
            }
            this.leafArray = this.nextLeafArray();
            this.leafArrayIdx = 0;
            return this.leafArray.length > 0;
        }

        @Override
        public E next() {
            if (this.leafArrayIdx >= this.leafArray.length) {
                this.leafArray = this.nextLeafArray();
                this.leafArrayIdx = 0;
            }
            return this.leafArray[this.leafArrayIdx++];
        }
    }

    private static final class IdxNode<E> {
        int idx = 0;
        final Node<E> node;

        IdxNode(Node<E> n) {
            this.node = n;
        }

        public boolean hasNext() {
            return this.idx < this.node.numChildren();
        }

        public Node<E> next() {
            return this.node.child(this.idx++);
        }
    }

    private static class Relaxed<T>
    implements Node<T> {
        final int[] cumulativeSizes;
        final Node<T>[] nodes;

        Relaxed(int[] szs, Node<T>[] ns) {
            this.cumulativeSizes = szs;
            this.nodes = ns;
        }

        @Override
        public Node<T> child(int childIdx) {
            return this.nodes[childIdx];
        }

        @Override
        public int debugValidate() {
            int sz = 0;
            int height = this.height() - 1;
            if (this.nodes.length != this.cumulativeSizes.length) {
                throw new IllegalStateException("Unequal size of nodes and sizes!\n" + this.indentedStr(0));
            }
            for (int i = 0; i < this.nodes.length; ++i) {
                Node<T> n = this.nodes[i];
                if (n.height() != height) {
                    throw new IllegalStateException("Unequal height!\n" + this.indentedStr(0));
                }
                if ((sz += n.size()) == this.cumulativeSizes[i]) continue;
                throw new IllegalStateException("Cumulative Sizes are wrong!\n" + this.indentedStr(0));
            }
            return sz;
        }

        @Override
        public Node<T> endChild(boolean leftMost) {
            return this.nodes[leftMost ? 0 : this.nodes.length - 1];
        }

        @Override
        public Node<T> addEndChild(boolean leftMost, Node<T> shorter) {
            return Relaxed.insertInRelaxedAt(this.cumulativeSizes, this.nodes, shorter, leftMost ? 0 : this.nodes.length);
        }

        @Override
        public Node<T> addEndChildren(boolean leftMost, Node<T>[] newKids) {
            Node[] res = Cowry.spliceIntoArrayAt(newKids, this.nodes, leftMost ? 0 : this.nodes.length, Node.class);
            return new Relaxed<T>(Relaxed.makeSizeArray(res), res);
        }

        @Override
        public int height() {
            return this.nodes[0].height() + 1;
        }

        @Override
        public int size() {
            return this.cumulativeSizes[this.cumulativeSizes.length - 1];
        }

        private int subNodeIndex(int treeIndex) {
            int guess = this.cumulativeSizes.length * treeIndex / this.size();
            if (guess >= this.cumulativeSizes.length) {
                return this.cumulativeSizes.length - 1;
            }
            int guessedCumSize = this.cumulativeSizes[guess];
            if (guessedCumSize < treeIndex) {
                while (guess < this.cumulativeSizes.length - 1) {
                    if ((guessedCumSize = this.cumulativeSizes[++guess]) < treeIndex) continue;
                    return guessedCumSize == treeIndex ? guess + 1 : guess;
                }
                throw new IllegalStateException("Can we get here?  If so, how?");
            }
            if (guessedCumSize > treeIndex + 22) {
                while (guess > 0) {
                    int nextGuess = guess - 1;
                    guessedCumSize = this.cumulativeSizes[nextGuess];
                    if (guessedCumSize <= treeIndex) {
                        return guess;
                    }
                    guess = nextGuess;
                }
                return guess;
            }
            if (guessedCumSize == treeIndex) {
                return treeIndex == this.size() ? guess : guess + 1;
            }
            return guess;
        }

        private int subNodeAdjustedIndex(int index, int subNodeIndex) {
            return subNodeIndex == 0 ? index : index - this.cumulativeSizes[subNodeIndex - 1];
        }

        @Override
        public T get(int index) {
            int subNodeIndex = this.subNodeIndex(index);
            return this.nodes[subNodeIndex].get(this.subNodeAdjustedIndex(index, subNodeIndex));
        }

        @Override
        public boolean thisNodeHasRelaxedCapacity(int numNodes) {
            return this.nodes.length + numNodes < 44;
        }

        @Override
        public boolean hasStrictCapacity() {
            throw new UnsupportedOperationException("I don't think this should ever be called.");
        }

        @Override
        public boolean hasRelaxedCapacity(int index, int size) {
            if (this.thisNodeHasRelaxedCapacity(1)) {
                return true;
            }
            int subNodeIndex = this.subNodeIndex(index);
            return this.nodes[subNodeIndex].hasRelaxedCapacity(this.subNodeAdjustedIndex(index, subNodeIndex), size);
        }

        Relaxed<T>[] split() {
            int midpoint = this.nodes.length >> 1;
            Relaxed<T> left = new Relaxed<T>(Arrays.copyOf(this.cumulativeSizes, midpoint), Arrays.copyOf(this.nodes, midpoint));
            int[] rightCumSizes = new int[this.nodes.length - midpoint];
            int leftCumSizes = this.cumulativeSizes[midpoint - 1];
            for (int j = 0; j < rightCumSizes.length; ++j) {
                rightCumSizes[j] = this.cumulativeSizes[midpoint + j] - leftCumSizes;
            }
            Relaxed<T> right = new Relaxed<T>(rightCumSizes, Arrays.copyOfRange(this.nodes, midpoint, this.nodes.length));
            return new Relaxed[]{left, right};
        }

        @Override
        public SplitNode<T> splitAt(int splitIndex) {
            Node left;
            int size = this.size();
            if (splitIndex == 0) {
                return new SplitNode(RrbTree.emptyLeaf(), Cowry.emptyArray(), RrbTree.emptyLeaf(), Cowry.emptyArray());
            }
            if (splitIndex == size) {
                return new SplitNode(this, Cowry.emptyArray(), RrbTree.emptyLeaf(), Cowry.emptyArray());
            }
            int subNodeIndex = this.subNodeIndex(splitIndex);
            Node<T> subNode = this.nodes[subNodeIndex];
            if (subNodeIndex > 0 && splitIndex == this.cumulativeSizes[subNodeIndex - 1]) {
                Tuple2<Node<T>[], Node<T>[]> splitNodes = Cowry.splitArray(this.nodes, subNodeIndex);
                int[][] splitCumSizes = Cowry.splitArray(this.cumulativeSizes, subNodeIndex);
                int[] leftCumSizes = splitCumSizes[0];
                int[] rightCumSizes = splitCumSizes[1];
                int bias = leftCumSizes[leftCumSizes.length - 1];
                for (int i = 0; i < rightCumSizes.length; ++i) {
                    rightCumSizes[i] = rightCumSizes[i] - bias;
                }
                Relaxed<T> left2 = new Relaxed<T>(leftCumSizes, splitNodes._1());
                Relaxed<T> right = new Relaxed<T>(rightCumSizes, splitNodes._2());
                return new SplitNode<T>(left2, Cowry.emptyArray(), right, Cowry.emptyArray());
            }
            int subNodeAdjustedIndex = this.subNodeAdjustedIndex(splitIndex, subNodeIndex);
            SplitNode<T> split = subNode.splitAt(subNodeAdjustedIndex);
            Node splitLeft = split.left();
            if (subNodeIndex == 0) {
                left = splitLeft;
            } else {
                boolean haveLeft = splitLeft.size() > 0;
                int numLeftItems = subNodeIndex + (haveLeft ? 1 : 0);
                int[] leftCumSizes = new int[numLeftItems];
                Node[] leftNodes = RrbTree.genericNodeArray(numLeftItems);
                System.arraycopy(this.cumulativeSizes, 0, leftCumSizes, 0, numLeftItems);
                if (haveLeft) {
                    int cumulativeSize = numLeftItems > 1 ? leftCumSizes[numLeftItems - 2] : 0;
                    leftCumSizes[numLeftItems - 1] = cumulativeSize + splitLeft.size();
                }
                System.arraycopy(this.nodes, 0, leftNodes, 0, subNodeIndex);
                if (haveLeft) {
                    while (splitLeft.height() < this.height() - 1) {
                        splitLeft = RrbTree.addAncestor(splitLeft);
                    }
                    leftNodes[numLeftItems - 1] = splitLeft;
                }
                left = new Relaxed<T>(leftCumSizes, leftNodes);
            }
            Node<T> right = Relaxed.fixRight(this.nodes, split.right(), subNodeIndex);
            return new SplitNode<T>(left, split.leftFocus(), right, split.rightFocus());
        }

        @Override
        public int numChildren() {
            return this.nodes.length;
        }

        @Override
        public Node<T> pushFocus(int index, T[] oldFocus) {
            int subNodeAdjustedIndex;
            int subNodeIndex = this.subNodeIndex(index);
            Node<T> subNode = this.nodes[subNodeIndex];
            if (subNode.hasRelaxedCapacity(subNodeAdjustedIndex = this.subNodeAdjustedIndex(index, subNodeIndex), oldFocus.length)) {
                Node<T> newNode = subNode.pushFocus(subNodeAdjustedIndex, oldFocus);
                return Relaxed.replaceInRelaxedAt(this.cumulativeSizes, this.nodes, newNode, subNodeIndex, oldFocus.length);
            }
            if (!this.thisNodeHasRelaxedCapacity(1)) {
                Relaxed<T>[] split = this.split();
                int max1 = split[0].size();
                Relaxed<T> newRelaxed = new Relaxed<T>(new int[]{max1, max1 + split[1].size()}, split);
                return newRelaxed.pushFocus(index, oldFocus);
            }
            if (subNode instanceof Leaf) {
                int numToSkip;
                int[] newCumSizes;
                Node[] newNodes;
                if (oldFocus.length >= 22 && (subNodeAdjustedIndex == 0 || subNodeAdjustedIndex == subNode.size())) {
                    Leaf<T> newNode = new Leaf<T>(oldFocus);
                    if (subNodeAdjustedIndex != 0) {
                        ++subNodeIndex;
                    }
                    newNodes = Cowry.insertIntoArrayAt(newNode, this.nodes, subNodeIndex, Node.class);
                    newCumSizes = new int[this.cumulativeSizes.length + 1];
                    int cumulativeSize = 0;
                    if (subNodeIndex > 0) {
                        System.arraycopy(this.cumulativeSizes, 0, newCumSizes, 0, subNodeIndex);
                        cumulativeSize = newCumSizes[subNodeIndex - 1];
                    }
                    newCumSizes[subNodeIndex] = cumulativeSize + oldFocus.length;
                    numToSkip = 1;
                } else {
                    Leaf[] res = ((Leaf)subNode).spliceAndSplit(oldFocus, subNodeAdjustedIndex);
                    Leaf leftLeaf = res[0];
                    Leaf rightLeaf = res[1];
                    newNodes = new Node[this.nodes.length + 1];
                    newCumSizes = new int[this.cumulativeSizes.length + 1];
                    int leftSize = 0;
                    if (subNodeIndex > 0) {
                        System.arraycopy(this.nodes, 0, newNodes, 0, subNodeIndex);
                        System.arraycopy(this.cumulativeSizes, 0, newCumSizes, 0, subNodeIndex);
                        leftSize = this.cumulativeSizes[subNodeIndex - 1];
                    }
                    newNodes[subNodeIndex] = leftLeaf;
                    newNodes[subNodeIndex + 1] = rightLeaf;
                    newCumSizes[subNodeIndex] = leftSize += leftLeaf.size();
                    newCumSizes[subNodeIndex + 1] = leftSize + rightLeaf.size();
                    if (subNodeIndex < this.nodes.length - 1) {
                        System.arraycopy(this.nodes, subNodeIndex + 1, newNodes, subNodeIndex + 2, this.nodes.length - subNodeIndex - 1);
                    }
                    numToSkip = 2;
                }
                for (int i = subNodeIndex + numToSkip; i < newCumSizes.length; ++i) {
                    newCumSizes[i] = this.cumulativeSizes[i - 1] + oldFocus.length;
                }
                return new Relaxed<T>(newCumSizes, newNodes);
            }
            if (subNode instanceof Strict) {
                Relaxed<T> relaxed = ((Strict)subNode).relax();
                Node newNode = relaxed.pushFocus(subNodeAdjustedIndex, oldFocus);
                return Relaxed.replaceInRelaxedAt(this.cumulativeSizes, this.nodes, newNode, subNodeIndex, oldFocus.length);
            }
            Relaxed<T>[] newSubNode = ((Relaxed)subNode).split();
            Relaxed<T> node1 = newSubNode[0];
            Relaxed<T> node2 = newSubNode[1];
            Node[] newNodes = RrbTree.genericNodeArray(this.nodes.length + 1);
            if (subNodeIndex > 0) {
                System.arraycopy(this.nodes, 0, newNodes, 0, subNodeIndex);
            }
            newNodes[subNodeIndex] = node1;
            newNodes[subNodeIndex + 1] = node2;
            if (subNodeIndex < this.nodes.length) {
                System.arraycopy(this.nodes, subNodeIndex + 1, newNodes, subNodeIndex + 2, this.nodes.length - subNodeIndex - 1);
            }
            int[] newCumSizes = new int[this.cumulativeSizes.length + 1];
            int cumulativeSize = 0;
            if (subNodeIndex > 0) {
                System.arraycopy(this.cumulativeSizes, 0, newCumSizes, 0, subNodeIndex);
                cumulativeSize = this.cumulativeSizes[subNodeIndex - 1];
            }
            for (int i = subNodeIndex; i < newCumSizes.length; ++i) {
                newCumSizes[i] = cumulativeSize += newNodes[i].size();
            }
            Relaxed<T> newRelaxed = new Relaxed<T>(newCumSizes, newNodes);
            return newRelaxed.pushFocus(index, oldFocus);
        }

        @Override
        public Node<T> replace(int index, T t) {
            int subNodeIndex = this.subNodeIndex(index);
            Node<T> alteredNode = this.nodes[subNodeIndex].replace(this.subNodeAdjustedIndex(index, subNodeIndex), t);
            Node[] newNodes = Cowry.replaceInArrayAt(alteredNode, this.nodes, subNodeIndex, Node.class);
            return new Relaxed<T>(this.cumulativeSizes, newNodes);
        }

        @Override
        public String indentedStr(int indent) {
            StringBuilder sB = new StringBuilder().append("Relaxed(");
            int nextIndent = indent + sB.length();
            sB.append("cumulativeSizes=").append(IndentUtils.arrayString(this.cumulativeSizes)).append("\n").append((CharSequence)IndentUtils.indentSpace(nextIndent)).append("nodes=[");
            return RrbTree.showSubNodes(sB, this.nodes, nextIndent + 7).append("])").toString();
        }

        public String toString() {
            return this.indentedStr(0);
        }

        private static int[] makeSizeArray(Node[] newNodes) {
            int[] newCumSizes = new int[newNodes.length];
            int cumulativeSize = 0;
            for (int i = 0; i < newCumSizes.length; ++i) {
                newCumSizes[i] = cumulativeSize += newNodes[i].size();
            }
            return newCumSizes;
        }

        static <T> Relaxed<T> replaceInRelaxedAt(int[] is, Node<T>[] ns, Node<T> newNode, int subNodeIndex, int insertSize) {
            Node[] newNodes = Cowry.replaceInArrayAt(newNode, ns, subNodeIndex, Node.class);
            int[] newCumSizes = new int[is.length];
            if (subNodeIndex > 0) {
                System.arraycopy(is, 0, newCumSizes, 0, subNodeIndex);
            }
            for (int i = subNodeIndex; i < is.length; ++i) {
                newCumSizes[i] = is[i] + insertSize;
            }
            return new Relaxed<T>(newCumSizes, newNodes);
        }

        static <T> Relaxed<T> insertInRelaxedAt(int[] oldCumSizes, Node<T>[] ns, Node<T> newNode, int subNodeIndex) {
            Node[] newNodes = Cowry.insertIntoArrayAt(newNode, ns, subNodeIndex, Node.class);
            int oldLen = oldCumSizes.length;
            int[] newCumSizes = new int[oldLen + 1];
            if (subNodeIndex > 0) {
                System.arraycopy(oldCumSizes, 0, newCumSizes, 0, subNodeIndex);
            }
            int newNodeSize = newNode.size();
            int prevNodeTotal = subNodeIndex == 0 ? 0 : oldCumSizes[subNodeIndex - 1];
            newCumSizes[subNodeIndex] = newNodeSize + prevNodeTotal;
            for (int i = subNodeIndex; i < oldCumSizes.length; ++i) {
                newCumSizes[i + 1] = oldCumSizes[i] + newNodeSize;
            }
            return new Relaxed<T>(newCumSizes, newNodes);
        }

        public static <T> Node<T> fixRight(Node<T>[] origNodes, Node<T> splitRight, int subNodeIndex) {
            Relaxed<T> right;
            if (subNodeIndex == origNodes.length - 1) {
                right = new Relaxed<T>(new int[]{splitRight.size()}, new Node[]{splitRight});
            } else {
                boolean haveRightSubNode = splitRight.size() > 0;
                int numRightNodes = origNodes.length - subNodeIndex - (haveRightSubNode ? 0 : 1);
                int[] rightCumSizes = new int[numRightNodes];
                Node[] rightNodes = RrbTree.genericNodeArray(numRightNodes);
                int cumulativeSize = 0;
                int destCopyStartIdx = 0;
                if (haveRightSubNode) {
                    System.arraycopy(origNodes, subNodeIndex + 1, rightNodes, 1, numRightNodes - 1);
                    rightNodes[0] = splitRight;
                    rightCumSizes[0] = cumulativeSize = splitRight.size();
                    destCopyStartIdx = 1;
                } else {
                    System.arraycopy(origNodes, subNodeIndex + 1, rightNodes, 0, numRightNodes);
                }
                for (int i = destCopyStartIdx; i < numRightNodes; ++i) {
                    rightCumSizes[i] = cumulativeSize += rightNodes[i].size();
                }
                right = new Relaxed<T>(rightCumSizes, rightNodes);
            }
            return right;
        }
    }

    private static class Strict<T>
    implements Node<T> {
        final int shift;
        final int size;
        final Node<T>[] nodes;

        Strict(int sh, int sz, Node<T>[] ns) {
            this.shift = sh;
            this.size = sz;
            this.nodes = ns;
        }

        @Override
        public Node<T> child(int childIdx) {
            return this.nodes[childIdx];
        }

        @Override
        public int debugValidate() {
            if (this.nodes.length > 32) {
                throw new IllegalStateException("Too many child nodes!\n" + this.indentedStr(0));
            }
            int sz = 0;
            int height = this.height() - 1;
            int sh = this.shift - 5;
            for (int i = 0; i < this.nodes.length; ++i) {
                Node<T> n = this.nodes[i];
                if (!(n instanceof Strict) && !(n instanceof Leaf)) {
                    throw new IllegalStateException("Strict nodes can only have strict or leaf children!\n" + this.indentedStr(0));
                }
                if (n.height() != height) {
                    throw new IllegalStateException("Unequal height!  My height = " + this.height() + "\n" + this.indentedStr(0));
                }
                if (n instanceof Strict && ((Strict)n).shift != sh) {
                    throw new IllegalStateException("Unexpected shift difference between levels!\n" + this.indentedStr(0));
                }
                if (i < this.nodes.length - 1) {
                    if (n.hasStrictCapacity()) {
                        throw new IllegalStateException("Non-last strict node is not full!\n" + this.indentedStr(0));
                    }
                    if (n.size() % 32 != 0) {
                        throw new IllegalStateException("Non-last strict node has a weird size!\n" + this.indentedStr(0));
                    }
                }
                if (n instanceof Strict) {
                    n.debugValidate();
                }
                sz += n.size();
            }
            return sz;
        }

        @Override
        public Node<T> endChild(boolean leftMost) {
            return this.nodes[leftMost ? 0 : this.nodes.length - 1];
        }

        @Override
        public Node<T> addEndChild(boolean leftMost, Node<T> shorter) {
            if (leftMost || !(shorter instanceof Strict)) {
                return this.relax().addEndChild(leftMost, shorter);
            }
            return new Strict<T>(this.shift, this.size + shorter.size(), Cowry.insertIntoArrayAt(shorter, this.nodes, this.nodes.length, Node.class));
        }

        @Override
        public Node<T> addEndChildren(boolean leftMost, Node<T>[] newKids) {
            return this.relax().addEndChildren(leftMost, newKids);
        }

        @Override
        public int height() {
            return this.shift / 5 + 1;
        }

        private int highBits(int i) {
            return i >> this.shift;
        }

        private int lowBits(int i) {
            int shifter = -1 << this.shift;
            int invShifter = ~shifter;
            return i & invShifter;
        }

        @Override
        public T get(int i) {
            return this.nodes[this.highBits(i)].get(this.lowBits(i));
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean hasStrictCapacity() {
            return this.highBits(this.size) != 32;
        }

        @Override
        public boolean hasRelaxedCapacity(int index, int size) {
            return size < 12;
        }

        @Override
        public SplitNode<T> splitAt(int splitIndex) {
            Strict<T> left;
            if (splitIndex == 0) {
                return new SplitNode(RrbTree.emptyLeaf(), Cowry.emptyArray(), this, Cowry.emptyArray());
            }
            if (splitIndex == this.size) {
                return new SplitNode(this, Cowry.emptyArray(), RrbTree.emptyLeaf(), Cowry.emptyArray());
            }
            int subNodeIndex = this.highBits(splitIndex);
            Node<T> subNode = this.nodes[subNodeIndex];
            int subNodeAdjustedIndex = this.lowBits(splitIndex);
            SplitNode<T> split = subNode.splitAt(subNodeAdjustedIndex);
            Node<T> splitLeft = split.left();
            if (subNodeIndex == 0) {
                left = new Strict<T>(this.shift, splitLeft.size(), new Node[]{splitLeft});
            } else {
                boolean haveLeft = splitLeft.size() > 0;
                int numLeftItems = subNodeIndex + (haveLeft ? 1 : 0);
                Node[] leftNodes = RrbTree.genericNodeArray(numLeftItems);
                System.arraycopy(this.nodes, 0, leftNodes, 0, subNodeIndex);
                if (haveLeft) {
                    leftNodes[numLeftItems - 1] = splitLeft;
                }
                int newSize = 0;
                for (Node n : leftNodes) {
                    newSize += n.size();
                }
                left = new Strict<T>(this.shift, newSize, leftNodes);
            }
            Node<T> right = Relaxed.fixRight(this.nodes, split.right(), subNodeIndex);
            return new SplitNode<T>(left, split.leftFocus(), right, split.rightFocus());
        }

        Relaxed<T> relax() {
            int[] newCumSizes = new int[this.nodes.length];
            int cumulativeSize = 0;
            int subNodeSize = this.nodes[0].size();
            for (int i = 0; i < this.nodes.length - 1; ++i) {
                newCumSizes[i] = cumulativeSize += subNodeSize;
            }
            newCumSizes[newCumSizes.length - 1] = cumulativeSize += this.nodes[this.nodes.length - 1].size();
            return new Relaxed<T>(newCumSizes, this.nodes);
        }

        @Override
        public int numChildren() {
            return this.nodes.length;
        }

        @Override
        public Node<T> pushFocus(int index, T[] oldFocus) {
            int subNodeIndex = this.highBits(index);
            if (oldFocus.length == 32) {
                if (index == this.size()) {
                    int maxShift;
                    Node<T> lastNode = this.nodes[this.nodes.length - 1];
                    if (lastNode.hasStrictCapacity()) {
                        Strict strict = (Strict)lastNode;
                        Node<T> newNode = strict.pushFocus(this.lowBits(index), oldFocus);
                        Node[] newNodes = Cowry.replaceInArrayAt(newNode, this.nodes, this.nodes.length - 1, Node.class);
                        return new Strict<T>(this.shift, this.size + oldFocus.length, newNodes);
                    }
                    Node<T> newNode = new Leaf<T>(oldFocus);
                    int n = maxShift = this.nodes.length < 32 ? this.shift : this.shift + 1;
                    for (int newShift = 5; newShift < maxShift; newShift += 5) {
                        newNode = new Strict<T>(newShift, oldFocus.length, Cowry.singleElementArray(newNode, Node.class));
                    }
                    if (this.nodes.length < 32) {
                        Node[] newNodes = Cowry.insertIntoArrayAt(newNode, this.nodes, subNodeIndex, Node.class);
                        return new Strict<T>(this.shift, this.size + oldFocus.length, newNodes);
                    }
                    return new Strict<T>(this.shift + 5, this.size + oldFocus.length, new Node[]{this, newNode});
                }
                if (this.shift == 5 && this.lowBits(index) == 0 && this.nodes.length < 32) {
                    Leaf<T> newNode = new Leaf<T>(oldFocus);
                    Node[] newNodes = Cowry.insertIntoArrayAt(newNode, this.nodes, subNodeIndex, Node.class);
                    return new Strict<T>(this.shift, this.size + oldFocus.length, newNodes);
                }
            }
            return this.relax().pushFocus(index, oldFocus);
        }

        @Override
        public Node<T> replace(int idx, T t) {
            int thisNodeIdx = this.highBits(idx);
            Node<T> newNode = this.nodes[thisNodeIdx].replace(this.lowBits(idx), t);
            return new Strict<T>(this.shift, this.size, Cowry.replaceInArrayAt(newNode, this.nodes, thisNodeIdx, Node.class));
        }

        @Override
        public boolean thisNodeHasRelaxedCapacity(int numNodes) {
            return this.nodes.length + numNodes < 44;
        }

        public String toString() {
            return "Strict" + this.shift + IndentUtils.arrayString(this.nodes);
        }

        @Override
        public String indentedStr(int indent) {
            StringBuilder sB = new StringBuilder().append("Strict").append(this.shift).append("(");
            int len = sB.length();
            sB.append("size=").append(this.size).append("\n");
            sB.append((CharSequence)IndentUtils.indentSpace(len + indent));
            return RrbTree.showSubNodes(sB, this.nodes, indent + len).append(")").toString();
        }
    }

    private static class Leaf<T>
    implements Node<T> {
        final T[] items;

        Leaf(T[] ts) {
            this.items = ts;
        }

        @Override
        public Node<T> child(int childIdx) {
            throw new UnsupportedOperationException("Don't call this on a leaf");
        }

        @Override
        public int debugValidate() {
            if (this.items.length == 0) {
                return 0;
            }
            if (this.items.length < 22) {
                throw new IllegalStateException("Leaf too short!\n" + this.indentedStr(0));
            }
            if (this.items.length >= 44) {
                throw new IllegalStateException("Leaf too long!\n" + this.indentedStr(0));
            }
            return this.items.length;
        }

        @Override
        public Node<T> endChild(boolean leftMost) {
            throw new UnsupportedOperationException("Don't call this on a leaf");
        }

        @Override
        public Node<T> addEndChild(boolean leftMost, Node<T> shorter) {
            throw new UnsupportedOperationException("Don't call this on a leaf");
        }

        @Override
        public Node<T> addEndChildren(boolean leftMost, Node<T>[] newKids) {
            throw new UnsupportedOperationException("Don't call this on a leaf");
        }

        @Override
        public T get(int i) {
            return this.items[i];
        }

        @Override
        public int height() {
            return 1;
        }

        @Override
        public int size() {
            return this.items.length;
        }

        @Override
        public boolean hasStrictCapacity() {
            return false;
        }

        @Override
        public boolean hasRelaxedCapacity(int index, int size) {
            return this.items.length + size < 44;
        }

        @Override
        public SplitNode<T> splitAt(int splitIndex) {
            if (splitIndex == 0) {
                return new SplitNode(RrbTree.emptyLeaf(), Cowry.emptyArray(), RrbTree.emptyLeaf(), this.items);
            }
            if (splitIndex == this.items.length) {
                return new SplitNode<T>(RrbTree.emptyLeaf(), this.items, RrbTree.emptyLeaf(), Cowry.emptyArray());
            }
            Tuple2<T[], T[]> split = Cowry.splitArray(this.items, splitIndex);
            T[] splitL = split._1();
            T[] splitR = split._2();
            Leaf leafL = RrbTree.emptyLeaf();
            Leaf leafR = RrbTree.emptyLeaf();
            if (splitL.length > 32) {
                leafL = new Leaf(splitL);
                splitL = Cowry.emptyArray();
            }
            if (splitR.length > 32) {
                leafR = new Leaf(splitR);
                splitR = Cowry.emptyArray();
            }
            return new SplitNode(leafL, splitL, leafR, splitR);
        }

        private Leaf<T>[] spliceAndSplit(T[] oldFocus, int splitIndex) {
            T[] newItems = Cowry.spliceIntoArrayAt(oldFocus, this.items, splitIndex, null);
            Tuple2<T[], T[]> split = Cowry.splitArray(newItems, newItems.length >> 1);
            return new Leaf[]{new Leaf(split._1()), new Leaf(split._2())};
        }

        @Override
        public int numChildren() {
            return this.size();
        }

        @Override
        public Node<T> pushFocus(int index, T[] oldFocus) {
            if (this.items.length == 0) {
                return new Leaf<T>(oldFocus);
            }
            if (this.items.length == 32 && oldFocus.length == 32 && (index == 32 || index == 0)) {
                Leaf[] leafArray;
                if (index == 32) {
                    Leaf[] leafArray2 = new Leaf[2];
                    leafArray2[0] = this;
                    leafArray = leafArray2;
                    leafArray2[1] = new Leaf<T>(oldFocus);
                } else {
                    Leaf[] leafArray3 = new Leaf[2];
                    leafArray3[0] = new Leaf<T>(oldFocus);
                    leafArray = leafArray3;
                    leafArray3[1] = this;
                }
                Leaf[] newNodes = leafArray;
                return new Strict(5, 64, newNodes);
            }
            if (this.items.length + oldFocus.length < 44) {
                return new Leaf<T>(Cowry.spliceIntoArrayAt(oldFocus, this.items, index, null));
            }
            Leaf<T>[] res = this.spliceAndSplit(oldFocus, index);
            Leaf<T> leftLeaf = res[0];
            Leaf<T> rightLeaf = res[1];
            int leftSize = leftLeaf.size();
            return new Relaxed<T>(new int[]{leftSize, leftSize + rightLeaf.size()}, res);
        }

        @Override
        public Node<T> replace(int idx, T t) {
            return new Leaf<T>(Cowry.replaceInArrayAt(t, this.items, idx, null));
        }

        @Override
        public boolean thisNodeHasRelaxedCapacity(int numItems) {
            return this.items.length + numItems < 44;
        }

        public String toString() {
            return IndentUtils.arrayString(this.items);
        }

        @Override
        public String indentedStr(int indent) {
            return IndentUtils.arrayString(this.items);
        }
    }

    private static class SplitNode<T>
    extends Tuple4<Node<T>, T[], Node<T>, T[]>
    implements Indented {
        SplitNode(Node<T> ln, T[] lf, Node<T> rn, T[] rf) {
            super(ln, lf, rn, rf);
        }

        public Node<T> left() {
            return (Node)this._1;
        }

        public T[] leftFocus() {
            return (Object[])this._2;
        }

        public Node<T> right() {
            return (Node)this._3;
        }

        public T[] rightFocus() {
            return (Object[])this._4;
        }

        public int size() {
            return ((Node)this._1).size() + ((Object[])this._2).length + ((Node)this._3).size() + ((Object[])this._4).length;
        }

        @Override
        public String indentedStr(int indent) {
            StringBuilder sB = new StringBuilder().append("SplitNode(");
            int nextIndent = indent + sB.length();
            String nextIndentStr = IndentUtils.indentSpace(nextIndent).toString();
            return sB.append("left=").append(this.left().indentedStr(nextIndent + 5)).append(",\n").append(nextIndentStr).append("leftFocus=").append(IndentUtils.arrayString(this.leftFocus())).append(",\n").append(nextIndentStr).append("right=").append(this.right().indentedStr(nextIndent + 6)).append(",\n").append(nextIndentStr).append("rightFocus=").append(IndentUtils.arrayString(this.rightFocus())).append(")").toString();
        }

        @Override
        public String toString() {
            return this.indentedStr(0);
        }
    }

    private static interface Node<T>
    extends Indented {
        public Node<T> child(int var1);

        public int debugValidate();

        public Node<T> endChild(boolean var1);

        public Node<T> addEndChild(boolean var1, Node<T> var2);

        public Node<T> addEndChildren(boolean var1, Node<T>[] var2);

        public T get(int var1);

        public boolean hasStrictCapacity();

        public int height();

        public int size();

        public boolean thisNodeHasRelaxedCapacity(int var1);

        public boolean hasRelaxedCapacity(int var1, int var2);

        public int numChildren();

        public Node<T> pushFocus(int var1, T[] var2);

        public Node<T> replace(int var1, T var2);

        public SplitNode<T> splitAt(int var1);
    }

    public static class ImRrbt<E>
    extends RrbTree<E>
    implements ImList<E>,
    Serializable {
        private final E[] focus;
        private final int focusStartIndex;
        private final transient Node<E> root;
        private final int size;
        private static final long serialVersionUID = 20170625165600L;
        private static final ImRrbt EMPTY_IM_RRBT = new ImRrbt(Cowry.emptyArray(), 0, RrbTree.access$400(), 0);

        ImRrbt(E[] f, int fi, Node<E> r, int s) {
            this.focus = f;
            this.focusStartIndex = fi;
            this.root = r;
            this.size = s;
        }

        private Object writeReplace() {
            return new SerializationProxy(this);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            throw new InvalidObjectException("Proxy required");
        }

        @Override
        public ImRrbt<E> append(E val) {
            if (this.focus.length >= 32 || this.focus.length > 0 && this.focusStartIndex < this.size - this.focus.length) {
                Node<E> newRoot = this.root.pushFocus(this.focusStartIndex, this.focus);
                return new ImRrbt<E>(Cowry.singleElementArray(val), this.size, newRoot, this.size + 1);
            }
            return new ImRrbt<E>(Cowry.insertIntoArrayAt(val, this.focus, this.focus.length, null), this.focusStartIndex, this.root, this.size + 1);
        }

        @Override
        public ImRrbt<E> concat(Iterable<? extends E> es) {
            return ((MutableRrbt)((MutableRrbt)this.mutable()).concat((Iterable)es)).immutable();
        }

        @Override
        void debugValidate() {
            if (this.focus.length > 32) {
                throw new IllegalStateException("focus len:" + this.focus.length + " gt STRICT_NODE_LENGTH:" + 32 + "\n" + this.indentedStr(0));
            }
            int sz = this.root.debugValidate();
            if (sz != this.size - this.focus.length) {
                throw new IllegalStateException("Size incorrect.  Root size: " + this.root.size() + " RrbSize: " + this.size + " focusLen: " + this.focus.length + "\n" + this.indentedStr(0));
            }
            if (this.focusStartIndex < 0 || this.focusStartIndex > this.size) {
                throw new IllegalStateException("focusStartIndex out of bounds!\n" + this.indentedStr(0));
            }
            if (!this.root.equals(RrbTree.eliminateUnnecessaryAncestors(this.root))) {
                throw new IllegalStateException("Unnecessary ancestors!\n" + this.indentedStr(0));
            }
        }

        @Override
        public E get(int i) {
            if (i < 0 || i > this.size) {
                throw new IndexOutOfBoundsException("Index: " + i + " size: " + this.size);
            }
            if (i >= this.focusStartIndex) {
                int focusOffset = i - this.focusStartIndex;
                if (focusOffset < this.focus.length) {
                    return this.focus[focusOffset];
                }
                i -= this.focus.length;
            }
            return this.root.get(i);
        }

        @Override
        public ImRrbt<E> insert(int idx, E element) {
            if (this.focus.length >= 32) {
                Node<E> newRoot = this.root.pushFocus(this.focusStartIndex, this.focus);
                E[] newFocus = Cowry.singleElementArray(element);
                return new ImRrbt<E>(newFocus, idx, newRoot, this.size + 1);
            }
            int diff = idx - this.focusStartIndex;
            if (diff >= 0 && diff <= this.focus.length) {
                E[] newFocus = Cowry.insertIntoArrayAt(element, this.focus, diff, null);
                return new ImRrbt<E>(newFocus, this.focusStartIndex, this.root, this.size + 1);
            }
            Node<E> newRoot = this.focus.length > 0 ? this.root.pushFocus(this.focusStartIndex, this.focus) : this.root;
            E[] newFocus = Cowry.singleElementArray(element);
            return new ImRrbt<E>(newFocus, idx, newRoot, this.size + 1);
        }

        @Override
        public MutableRrbt<E> mutable() {
            return new MutableRrbt<E>(Cowry.arrayCopy(this.focus, this.focus.length, null), this.focusStartIndex, this.focus.length, this.root, this.size);
        }

        @Override
        public UnmodSortedIterator<E> iterator() {
            return new Iter(this.pushFocus());
        }

        @Override
        Node<E> pushFocus() {
            return this.focus.length == 0 ? this.root : this.root.pushFocus(this.focusStartIndex, this.focus);
        }

        @Override
        public RrbTree<E> join(RrbTree<E> that) {
            int i;
            if (that.size() <= 44) {
                return this.concat(that);
            }
            if (this.size <= 44) {
                for (int i2 = 0; i2 < this.size; ++i2) {
                    that = that.insert(i2, this.get(i2));
                }
                return that;
            }
            Relaxed leftRoot = this.pushFocus();
            Relaxed rightRoot = that.pushFocus();
            boolean leftIntoRight = leftRoot.height() < rightRoot.height();
            Relaxed taller = leftIntoRight ? rightRoot : leftRoot;
            Relaxed shorter = leftIntoRight ? leftRoot : rightRoot;
            Relaxed n = taller;
            int descentDepth = taller.height() - shorter.height();
            Node[] ancestors = RrbTree.genericNodeArray(descentDepth);
            for (i = 0; i < ancestors.length; ++i) {
                ancestors[i] = n;
                n = n.endChild(leftIntoRight);
            }
            --i;
            if (n.thisNodeHasRelaxedCapacity(shorter.numChildren())) {
                Node<T>[] kids;
                if (shorter instanceof Strict) {
                    kids = ((Strict)((Object)shorter)).nodes;
                } else if (shorter instanceof Relaxed) {
                    kids = ((Relaxed)shorter).nodes;
                } else {
                    throw new IllegalStateException("Expected a strict or relaxed, but found " + shorter.getClass());
                }
                n = n.addEndChildren(leftIntoRight, kids);
            }
            if (i >= 0) {
                n = ancestors[i];
                --i;
            }
            while (!n.thisNodeHasRelaxedCapacity(1) && i >= 0) {
                n = ancestors[i];
                --i;
                shorter = RrbTree.addAncestor(shorter);
                if (leftIntoRight) {
                    leftRoot = shorter;
                    continue;
                }
                rightRoot = shorter;
            }
            if (shorter.height() == n.height() - 1) {
                n = n.addEndChild(leftIntoRight, shorter);
            } else {
                if (i < 0) {
                    Node[] newRootArray = new Node[]{leftRoot, rightRoot};
                    int leftSize = leftRoot.size();
                    Relaxed newRoot = new Relaxed(new int[]{leftSize, leftSize + rightRoot.size()}, newRootArray);
                    return new ImRrbt(Cowry.emptyArray(), 0, newRoot, newRoot.size());
                }
                throw new IllegalStateException("How did we get here?");
            }
            while (i >= 0) {
                Node anc = ancestors[i];
                Relaxed rel = anc instanceof Strict ? ((Strict)anc).relax() : (Relaxed)anc;
                int repIdx = leftIntoRight ? 0 : rel.numChildren() - 1;
                n = Relaxed.replaceInRelaxedAt(rel.cumulativeSizes, rel.nodes, n, repIdx, n.size() - rel.nodes[repIdx].size());
                --i;
            }
            return new ImRrbt(Cowry.emptyArray(), 0, n, n.size());
        }

        @Override
        public ImRrbt<E> replace(int index, E item) {
            if (index < 0 || index > this.size) {
                throw new IndexOutOfBoundsException("Index: " + index + " size: " + this.size);
            }
            if (index >= this.focusStartIndex) {
                int focusOffset = index - this.focusStartIndex;
                if (focusOffset < this.focus.length) {
                    return new ImRrbt<E>(Cowry.replaceInArrayAt(item, this.focus, focusOffset, null), this.focusStartIndex, this.root, this.size);
                }
                index -= this.focus.length;
            }
            return new ImRrbt<E>(this.focus, this.focusStartIndex, this.root.replace(index, item), this.size);
        }

        @Override
        public ImRrbt<E> without(int index) {
            return (ImRrbt)super.without(index);
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public Tuple2<ImRrbt<E>, ImRrbt<E>> split(int splitIndex) {
            if (splitIndex < 1) {
                if (splitIndex == 0) {
                    return Tuple2.of(ImRrbt.empty(), this);
                }
                throw new IndexOutOfBoundsException("Constraint violation failed: 1 <= splitIndex <= size");
            }
            if (splitIndex >= this.size) {
                if (splitIndex == this.size) {
                    return Tuple2.of(this, ImRrbt.empty());
                }
                throw new IndexOutOfBoundsException("Constraint violation failed: 1 <= splitIndex <= size");
            }
            Node<E> newRoot = this.pushFocus();
            SplitNode<E> split = newRoot.splitAt(splitIndex);
            E[] lFocus = split.leftFocus();
            Node left = RrbTree.eliminateUnnecessaryAncestors(split.left());
            E[] rFocus = split.rightFocus();
            Node right = RrbTree.eliminateUnnecessaryAncestors(split.right());
            return Tuple2.of(new ImRrbt<E>(lFocus, left.size(), left, left.size() + lFocus.length), new ImRrbt<E>(rFocus, 0, right, right.size() + rFocus.length));
        }

        @Override
        public String indentedStr(int indent) {
            return "RrbTree(size=" + this.size + " fsi=" + this.focusStartIndex + " focus=" + IndentUtils.arrayString(this.focus) + "\n" + IndentUtils.indentSpace(indent + 8) + "root=" + (this.root == null ? "null" : this.root.indentedStr(indent + 13)) + ")";
        }

        public String toString() {
            return UnmodIterable.toString("ImRrbt", this);
        }

        private static class SerializationProxy<E>
        implements Serializable {
            private static final long serialVersionUID = 20160904155600L;
            private final int size;
            private transient RrbTree<E> rrbTree;

            SerializationProxy(RrbTree<E> v) {
                this.size = v.size();
                this.rrbTree = v;
            }

            private void writeObject(ObjectOutputStream s) throws IOException {
                s.defaultWriteObject();
                for (Object entry : this.rrbTree) {
                    s.writeObject(entry);
                }
            }

            private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
                s.defaultReadObject();
                MutableRrbt temp = RrbTree.emptyMutable();
                for (int i = 0; i < this.size; ++i) {
                    temp.append(s.readObject());
                }
                this.rrbTree = temp.immutable();
            }

            private Object readResolve() {
                return this.rrbTree;
            }
        }
    }

    public static class MutableRrbt<E>
    extends RrbTree<E>
    implements MutableList<E> {
        private E[] focus;
        private int focusStartIndex;
        private int focusLength;
        private Node<E> root;
        private int size;

        MutableRrbt(E[] f, int fi, int fl, Node<E> r, int s) {
            this.focus = f;
            this.focusStartIndex = fi;
            this.focusLength = fl;
            this.root = r;
            this.size = s;
        }

        @Override
        public MutableRrbt<E> append(E val) {
            if (this.focusLength >= 32 || this.focusLength > 0 && this.focusStartIndex < this.size - this.focusLength) {
                this.root = this.root.pushFocus(this.focusStartIndex, Cowry.arrayCopy(this.focus, this.focusLength, null));
                this.focus = new Object[32];
                this.focus[0] = val;
                this.focusStartIndex = this.size++;
                this.focusLength = 1;
                return this;
            }
            if (this.focus.length <= this.focusLength) {
                this.focus = Cowry.arrayCopy(this.focus, 32, null);
            }
            this.focus[this.focusLength] = val;
            ++this.focusLength;
            ++this.size;
            return this;
        }

        @Override
        public MutableRrbt<E> concat(Iterable<? extends E> es) {
            return (MutableRrbt)MutableList.super.concat((Iterable)es);
        }

        @Override
        void debugValidate() {
            if (this.focusLength > 32) {
                throw new IllegalStateException("focus len:" + this.focusLength + " gt STRICT_NODE_LENGTH:" + 32 + "\n" + this.indentedStr(0));
            }
            int sz = this.root.debugValidate();
            if (sz != this.size - this.focusLength) {
                throw new IllegalStateException("Size incorrect.  Root size: " + this.root.size() + " RrbSize: " + this.size + " focusLen: " + this.focusLength + "\n" + this.indentedStr(0));
            }
            if (this.focusStartIndex < 0 || this.focusStartIndex > this.size) {
                throw new IllegalStateException("focusStartIndex out of bounds!\n" + this.indentedStr(0));
            }
            if (!this.root.equals(RrbTree.eliminateUnnecessaryAncestors(this.root))) {
                throw new IllegalStateException("Unnecessary ancestors!\n" + this.indentedStr(0));
            }
        }

        @Override
        public E get(int i) {
            if (i < 0 || i > this.size) {
                throw new IndexOutOfBoundsException("Index: " + i + " size: " + this.size);
            }
            if (i >= this.focusStartIndex) {
                int focusOffset = i - this.focusStartIndex;
                if (focusOffset < this.focusLength) {
                    return this.focus[focusOffset];
                }
                i -= this.focusLength;
            }
            return this.root.get(i);
        }

        @Override
        public ImRrbt<E> immutable() {
            return new ImRrbt<E>(Cowry.arrayCopy(this.focus, this.focusLength, null), this.focusStartIndex, this.root, this.size);
        }

        @Override
        public String indentedStr(int indent) {
            return "RrbTree(size=" + this.size + " fsi=" + this.focusStartIndex + " focus=" + IndentUtils.arrayString(this.focus) + "\n" + IndentUtils.indentSpace(indent + 8) + "root=" + (this.root == null ? "null" : this.root.indentedStr(indent + 13)) + ")";
        }

        @Override
        public MutableRrbt<E> insert(int idx, E element) {
            if (this.focusLength >= 32) {
                this.root = this.root.pushFocus(this.focusStartIndex, Cowry.arrayCopy(this.focus, this.focusLength, null));
                this.focus = Cowry.singleElementArray(element);
                this.focusStartIndex = idx;
                this.focusLength = 1;
                ++this.size;
                return this;
            }
            if (this.focusLength == 0) {
                this.focus = Cowry.singleElementArray(element);
                this.focusStartIndex = idx;
                this.focusLength = 1;
                ++this.size;
                return this;
            }
            int diff = idx - this.focusStartIndex;
            if (diff >= 0 && diff <= this.focusLength) {
                int numItemsToShift;
                if (this.focus.length <= this.focusLength) {
                    int newLen = this.focusLength >= 16 ? 32 : this.focusLength << 1;
                    this.focus = Cowry.arrayCopy(this.focus, newLen, null);
                }
                if ((numItemsToShift = this.focusLength - diff) > 0) {
                    System.arraycopy(this.focus, diff, this.focus, diff + 1, numItemsToShift);
                }
                this.focus[diff] = element;
                ++this.focusLength;
                ++this.size;
                return this;
            }
            if (this.focusLength > 0) {
                this.root = this.root.pushFocus(this.focusStartIndex, Cowry.arrayCopy(this.focus, this.focusLength, null));
            }
            this.focus = Cowry.singleElementArray(element);
            this.focusStartIndex = idx;
            this.focusLength = 1;
            ++this.size;
            return this;
        }

        @Override
        public UnmodSortedIterator<E> iterator() {
            return new Iter(this.pushFocus());
        }

        @Override
        Node<E> pushFocus() {
            return this.focusLength == 0 ? this.root : this.root.pushFocus(this.focusStartIndex, Cowry.arrayCopy(this.focus, this.focusLength, null));
        }

        public String toString() {
            return UnmodIterable.toString("MutableRrbt", this);
        }

        @Override
        public RrbTree<E> join(RrbTree<E> that) {
            int i;
            if (that.size() <= 44) {
                return this.concat(that);
            }
            if (this.size <= 44) {
                for (int i2 = 0; i2 < this.size; ++i2) {
                    that = that.insert(i2, this.get(i2));
                }
                return that;
            }
            Relaxed leftRoot = this.pushFocus();
            Relaxed rightRoot = that.pushFocus();
            boolean leftIntoRight = leftRoot.height() < rightRoot.height();
            Relaxed taller = leftIntoRight ? rightRoot : leftRoot;
            Relaxed shorter = leftIntoRight ? leftRoot : rightRoot;
            Relaxed n = taller;
            int descentDepth = taller.height() - shorter.height();
            Node[] ancestors = RrbTree.genericNodeArray(descentDepth);
            for (i = 0; i < ancestors.length; ++i) {
                ancestors[i] = n;
                n = n.endChild(leftIntoRight);
            }
            --i;
            if (n.thisNodeHasRelaxedCapacity(shorter.numChildren())) {
                Node<T>[] kids;
                if (shorter instanceof Strict) {
                    kids = ((Strict)((Object)shorter)).nodes;
                } else if (shorter instanceof Relaxed) {
                    kids = ((Relaxed)shorter).nodes;
                } else {
                    throw new IllegalStateException("Expected a strict or relaxed, but found " + shorter.getClass());
                }
                n = n.addEndChildren(leftIntoRight, kids);
            }
            if (i >= 0) {
                n = ancestors[i];
                --i;
            }
            while (!n.thisNodeHasRelaxedCapacity(1) && i >= 0) {
                n = ancestors[i];
                --i;
                shorter = RrbTree.addAncestor(shorter);
                if (leftIntoRight) {
                    leftRoot = shorter;
                    continue;
                }
                rightRoot = shorter;
            }
            if (shorter.height() == n.height() - 1) {
                n = n.addEndChild(leftIntoRight, shorter);
            } else {
                if (i < 0) {
                    Node[] newRootArray = new Node[]{leftRoot, rightRoot};
                    int leftSize = leftRoot.size();
                    Relaxed newRoot = new Relaxed(new int[]{leftSize, leftSize + rightRoot.size()}, newRootArray);
                    return new MutableRrbt(Cowry.emptyArray(), 0, 0, newRoot, newRoot.size());
                }
                throw new IllegalStateException("How did we get here?");
            }
            while (i >= 0) {
                Node anc = ancestors[i];
                Relaxed rel = anc instanceof Strict ? ((Strict)anc).relax() : (Relaxed)anc;
                int repIdx = leftIntoRight ? 0 : rel.numChildren() - 1;
                n = Relaxed.replaceInRelaxedAt(rel.cumulativeSizes, rel.nodes, n, repIdx, n.size() - rel.nodes[repIdx].size());
                --i;
            }
            return new MutableRrbt(Cowry.emptyArray(), 0, 0, n, n.size());
        }

        @Override
        public MutableRrbt<E> replace(int index, E item) {
            if (index < 0 || index > this.size) {
                throw new IndexOutOfBoundsException("Index: " + index + " size: " + this.size);
            }
            if (index >= this.focusStartIndex) {
                int focusOffset = index - this.focusStartIndex;
                if (focusOffset < this.focusLength) {
                    this.focus[focusOffset] = item;
                    return this;
                }
                index -= this.focusLength;
            }
            this.root = this.root.replace(index, item);
            return this;
        }

        @Override
        public MutableRrbt<E> without(int index) {
            return (MutableRrbt)super.without(index);
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public Tuple2<MutableRrbt<E>, MutableRrbt<E>> split(int splitIndex) {
            if (splitIndex < 1) {
                if (splitIndex == 0) {
                    return Tuple2.of(MutableRrbt.emptyMutable(), this);
                }
                throw new IndexOutOfBoundsException("Constraint violation failed: 1 <= splitIndex <= size");
            }
            if (splitIndex >= this.size) {
                if (splitIndex == this.size) {
                    return Tuple2.of(this, MutableRrbt.emptyMutable());
                }
                throw new IndexOutOfBoundsException("Constraint violation failed: 1 <= splitIndex <= size");
            }
            Node<E> newRoot = this.pushFocus();
            SplitNode<E> split = newRoot.splitAt(splitIndex);
            E[] lFocus = split.leftFocus();
            Node left = RrbTree.eliminateUnnecessaryAncestors(split.left());
            E[] rFocus = split.rightFocus();
            Node right = RrbTree.eliminateUnnecessaryAncestors(split.right());
            return Tuple2.of(new MutableRrbt<E>(lFocus, left.size(), lFocus.length, left, left.size() + lFocus.length), new MutableRrbt<E>(rFocus, 0, rFocus.length, right, right.size() + rFocus.length));
        }
    }
}

