/*
 * Decompiled with CFR 0.152.
 */
package org.organicdesign.fp.collections;

import java.util.Iterator;
import org.organicdesign.fp.FunctionUtils;
import org.organicdesign.fp.collections.UnmodIterator;
import org.organicdesign.fp.function.Fn1;
import org.organicdesign.fp.function.Fn2;
import org.organicdesign.fp.oneOf.Option;
import org.organicdesign.fp.oneOf.Or;
import org.organicdesign.fp.xform.Transformable;
import org.organicdesign.fp.xform.Xform;

public interface UnmodIterable<T>
extends Iterable<T>,
Transformable<T> {
    public static int hash(Iterable<?> is) {
        if (is == null) {
            throw new IllegalArgumentException("Can't have a null iteratable.");
        }
        int ret = 0;
        for (Object t : is) {
            if (t == null) continue;
            ret += t.hashCode();
        }
        return ret;
    }

    public static String toString(String name, Iterable<?> iterable) {
        if (name == null) {
            throw new IllegalArgumentException("Can't have a null name.");
        }
        if (iterable == null) {
            throw new IllegalArgumentException("Can't have a null iteratable.");
        }
        StringBuilder sB = new StringBuilder();
        sB.append(name).append("(");
        int i = 0;
        Iterator<?> iter = iterable.iterator();
        while (iter.hasNext()) {
            if (i > 0) {
                sB.append(",");
            }
            Object item = iter.next();
            sB.append(FunctionUtils.stringify(item));
            ++i;
        }
        return sB.append(")").toString();
    }

    @Override
    public UnmodIterator<T> iterator();

    @Override
    default public UnmodIterable<T> concat(Iterable<? extends T> list) {
        return Xform.of(this).concat((Iterable)list);
    }

    @Override
    default public UnmodIterable<T> precat(Iterable<? extends T> list) {
        return Xform.of(this).precat((Iterable)list);
    }

    @Override
    default public UnmodIterable<T> drop(long n) {
        return Xform.of(this).drop(n);
    }

    @Override
    default public UnmodIterable<T> dropWhile(Fn1<? super T, Boolean> predicate) {
        return Xform.of(this).dropWhile((Fn1)predicate);
    }

    @Override
    default public <B> B fold(B ident, Fn2<? super B, ? super T, B> reducer) {
        return Xform.of(this).fold(ident, reducer);
    }

    @Override
    default public <G, B> Or<G, B> foldUntil(G accum, Fn2<? super G, ? super T, B> terminator, Fn2<? super G, ? super T, G> reducer) {
        return Xform.of(this).foldUntil(accum, terminator, reducer);
    }

    @Override
    default public UnmodIterable<T> filter(Fn1<? super T, Boolean> f) {
        return Xform.of(this).filter((Fn1)f);
    }

    @Override
    default public <B> UnmodIterable<B> flatMap(Fn1<? super T, Iterable<B>> f) {
        return Xform.of(this).flatMap((Fn1)f);
    }

    @Override
    default public <B> UnmodIterable<B> map(Fn1<? super T, ? extends B> f) {
        return Xform.of(this).map((Fn1)f);
    }

    @Override
    default public UnmodIterable<T> take(long numItems) {
        return Xform.of(this).take(numItems);
    }

    @Override
    default public UnmodIterable<T> takeWhile(Fn1<? super T, Boolean> f) {
        return Xform.of(this).takeWhile((Fn1)f);
    }

    @Override
    default public Option<T> head() {
        Iterator iter = this.iterator();
        return iter.hasNext() ? Option.some(iter.next()) : Option.none();
    }
}

