/*
 * Decompiled with CFR 0.152.
 */
package org.organicdesign.fp.xform;

import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.organicdesign.fp.collections.ImList;
import org.organicdesign.fp.collections.ImMap;
import org.organicdesign.fp.collections.ImSet;
import org.organicdesign.fp.collections.ImSortedMap;
import org.organicdesign.fp.collections.ImSortedSet;
import org.organicdesign.fp.collections.MutableList;
import org.organicdesign.fp.collections.MutableMap;
import org.organicdesign.fp.collections.MutableSet;
import org.organicdesign.fp.collections.PersistentHashMap;
import org.organicdesign.fp.collections.PersistentHashSet;
import org.organicdesign.fp.collections.PersistentTreeMap;
import org.organicdesign.fp.collections.PersistentTreeSet;
import org.organicdesign.fp.collections.PersistentVector;
import org.organicdesign.fp.collections.RrbTree;
import org.organicdesign.fp.function.Fn1;
import org.organicdesign.fp.function.Fn2;
import org.organicdesign.fp.oneOf.Option;
import org.organicdesign.fp.oneOf.Or;

public interface Transformable<T> {
    public Transformable<T> concat(Iterable<? extends T> var1);

    public Transformable<T> drop(long var1);

    public Transformable<T> dropWhile(Fn1<? super T, Boolean> var1);

    public Transformable<T> filter(Fn1<? super T, Boolean> var1);

    default public Option<T> head() {
        return this.foldUntil(Option.none(), (accum, item) -> Option.someOrNullNoneOf(item), Fn2.first()).match(g -> Option.none(), b -> b);
    }

    public <U> Transformable<U> flatMap(Fn1<? super T, Iterable<U>> var1);

    public <U> U fold(U var1, Fn2<? super U, ? super T, U> var2);

    public <G, B> Or<G, B> foldUntil(G var1, Fn2<? super G, ? super T, B> var2, Fn2<? super G, ? super T, G> var3);

    public <U> Transformable<U> map(Fn1<? super T, ? extends U> var1);

    public Transformable<T> precat(Iterable<? extends T> var1);

    public Transformable<T> take(long var1);

    public Transformable<T> takeWhile(Fn1<? super T, Boolean> var1);

    default public ImList<T> toImList() {
        return this.toMutableList().immutable();
    }

    default public RrbTree.ImRrbt<T> toImRrbt() {
        return this.toMutableRrbt().immutable();
    }

    default public <K, V> ImMap<K, V> toImMap(Fn1<? super T, Map.Entry<K, V>> f1) {
        return this.toMutableMap(f1).immutable();
    }

    default public ImSet<T> toImSet() {
        return this.toMutableSet().immutable();
    }

    default public <K, V> ImSortedMap<K, V> toImSortedMap(Comparator<? super K> comp, Fn1<? super T, Map.Entry<K, V>> f1) {
        return this.fold(PersistentTreeMap.empty(comp), (ts, t) -> ts.assoc((Map.Entry)f1.apply(t)));
    }

    default public ImSortedSet<T> toImSortedSet(Comparator<? super T> comparator) {
        return this.fold(PersistentTreeSet.ofComp(comparator), PersistentTreeSet::put);
    }

    default public MutableList<T> toMutableList() {
        return this.fold(PersistentVector.emptyMutable(), MutableList::append);
    }

    default public RrbTree.MutableRrbt<T> toMutableRrbt() {
        return this.fold(RrbTree.emptyMutable(), RrbTree.MutableRrbt::append);
    }

    default public <K, V> MutableMap<K, V> toMutableMap(Fn1<? super T, Map.Entry<K, V>> f1) {
        return this.fold(PersistentHashMap.emptyMutable(), (ts, t) -> ts.assoc((Map.Entry)f1.apply(t)));
    }

    default public <K, V> SortedMap<K, V> toMutableSortedMap(Comparator<? super K> comp, Fn1<? super T, Map.Entry<K, V>> f1) {
        return this.fold(new TreeMap(comp), (ts, t) -> {
            Map.Entry entry = (Map.Entry)f1.apply(t);
            ts.put(entry.getKey(), entry.getValue());
            return ts;
        });
    }

    default public MutableSet<T> toMutableSet() {
        return this.fold(PersistentHashSet.emptyMutable(), PersistentHashSet.MutableHashSet::put);
    }

    default public SortedSet<T> toMutableSortedSet(Comparator<? super T> comparator) {
        return this.fold(new TreeSet<T>(comparator), (ts, t) -> {
            ts.add(t);
            return ts;
        });
    }
}

