/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.apiman.dt.api.jpa;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.persistence.EntityExistsException;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceException;
import javax.persistence.RollbackException;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.overlord.apiman.dt.api.beans.orgs.OrgBasedCompositeId;
import org.overlord.apiman.dt.api.beans.search.OrderByBean;
import org.overlord.apiman.dt.api.beans.search.PagingBean;
import org.overlord.apiman.dt.api.beans.search.SearchCriteriaBean;
import org.overlord.apiman.dt.api.beans.search.SearchCriteriaFilterBean;
import org.overlord.apiman.dt.api.beans.search.SearchResultsBean;
import org.overlord.apiman.dt.api.core.exceptions.AlreadyExistsException;
import org.overlord.apiman.dt.api.core.exceptions.ConstraintViolationException;
import org.overlord.apiman.dt.api.core.exceptions.DoesNotExistException;
import org.overlord.apiman.dt.api.core.exceptions.StorageException;
import org.overlord.apiman.dt.api.jpa.IEntityManagerFactoryAccessor;
import org.overlord.apiman.dt.api.jpa.JpaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJpaStorage {
    private static Logger logger = LoggerFactory.getLogger(AbstractJpaStorage.class);
    @Inject
    private IEntityManagerFactoryAccessor emfAccessor;
    private static ThreadLocal<EntityManager> activeEM = new ThreadLocal();

    protected void beginTx() throws StorageException {
        if (activeEM.get() != null) {
            throw new StorageException("Transaction already active.");
        }
        EntityManager entityManager = this.emfAccessor.getEntityManagerFactory().createEntityManager();
        activeEM.set(entityManager);
        entityManager.getTransaction().begin();
    }

    protected void commitTx() throws StorageException {
        if (activeEM.get() == null) {
            throw new StorageException("Transaction not active.");
        }
        try {
            activeEM.get().getTransaction().commit();
            activeEM.get().close();
            activeEM.set(null);
        }
        catch (EntityExistsException e) {
            throw new AlreadyExistsException();
        }
        catch (RollbackException e) {
            if (JpaUtil.isConstraintViolation((Exception)((Object)e))) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new ConstraintViolationException((Throwable)e);
            }
            logger.error(e.getMessage(), (Throwable)e);
            throw new StorageException((Throwable)e);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            throw new StorageException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rollbackTx() {
        if (activeEM.get() == null) {
            throw new RuntimeException("Transaction not active.");
        }
        try {
            JpaUtil.rollbackQuietly(activeEM.get());
        }
        finally {
            activeEM.get().close();
            activeEM.set(null);
        }
    }

    protected EntityManager getActiveEntityManager() throws StorageException {
        EntityManager entityManager = activeEM.get();
        if (entityManager == null) {
            throw new StorageException("Transaction not active.");
        }
        return entityManager;
    }

    public <T> void create(T bean) throws StorageException, AlreadyExistsException {
        if (bean == null) {
            return;
        }
        EntityManager entityManager = this.getActiveEntityManager();
        try {
            entityManager.persist(bean);
        }
        catch (EntityExistsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AlreadyExistsException();
        }
        catch (RollbackException e) {
            if (JpaUtil.isConstraintViolation((Exception)((Object)e))) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new ConstraintViolationException((Throwable)e);
            }
            logger.error(e.getMessage(), (Throwable)e);
            throw new StorageException((Throwable)e);
        }
        catch (PersistenceException e) {
            if (JpaUtil.isConstraintViolation((Exception)((Object)e))) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new ConstraintViolationException((Throwable)e);
            }
            logger.error(e.getMessage(), (Throwable)e);
            throw new StorageException((Throwable)e);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            throw new StorageException(t);
        }
    }

    public <T> void update(T bean) throws StorageException, DoesNotExistException {
        EntityManager entityManager = this.getActiveEntityManager();
        try {
            entityManager.merge(bean);
        }
        catch (IllegalArgumentException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new DoesNotExistException();
        }
        catch (RollbackException e) {
            if (JpaUtil.isConstraintViolation((Exception)((Object)e))) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new ConstraintViolationException((Throwable)e);
            }
            logger.error(e.getMessage(), (Throwable)e);
            throw new StorageException((Throwable)e);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            throw new StorageException(t);
        }
    }

    public <T> void delete(T bean) throws StorageException, DoesNotExistException {
        EntityManager entityManager = this.getActiveEntityManager();
        try {
            entityManager.remove(bean);
        }
        catch (IllegalArgumentException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new DoesNotExistException();
        }
        catch (RollbackException e) {
            if (JpaUtil.isConstraintViolation((Exception)((Object)e))) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new ConstraintViolationException((Throwable)e);
            }
            logger.error(e.getMessage(), (Throwable)e);
            throw new StorageException((Throwable)e);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            throw new StorageException(t);
        }
    }

    public <T> T get(Long id, Class<T> type) throws StorageException, DoesNotExistException {
        Object rval = null;
        EntityManager entityManager = this.getActiveEntityManager();
        try {
            rval = entityManager.find(type, (Object)id);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            throw new StorageException(t);
        }
        if (rval == null) {
            throw new DoesNotExistException();
        }
        return (T)rval;
    }

    public <T> T get(String id, Class<T> type) throws StorageException, DoesNotExistException {
        Object rval = null;
        EntityManager entityManager = this.getActiveEntityManager();
        try {
            rval = entityManager.find(type, (Object)id);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            throw new StorageException(t);
        }
        if (rval == null) {
            throw new DoesNotExistException();
        }
        return (T)rval;
    }

    public <T> T get(String organizationId, String id, Class<T> type) throws StorageException, DoesNotExistException {
        Object rval = null;
        EntityManager entityManager = this.getActiveEntityManager();
        try {
            OrgBasedCompositeId key = new OrgBasedCompositeId(organizationId, id);
            rval = entityManager.find(type, (Object)key);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            throw new StorageException(t);
        }
        if (rval == null) {
            throw new DoesNotExistException();
        }
        return (T)rval;
    }

    public <T> SearchResultsBean<T> find(SearchCriteriaBean criteria, Class<T> type) throws StorageException {
        SearchResultsBean results = new SearchResultsBean();
        EntityManager entityManager = this.getActiveEntityManager();
        try {
            PagingBean paging = criteria.getPaging();
            if (paging == null) {
                paging = new PagingBean();
                paging.setPage(1);
                paging.setPageSize(20);
            }
            int page = paging.getPage();
            int pageSize = paging.getPageSize();
            int start = (page - 1) * pageSize;
            CriteriaBuilder builder = entityManager.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = builder.createQuery(type);
            Root from = criteriaQuery.from(type);
            this.applySearchCriteriaToQuery(criteria, builder, criteriaQuery, from, false);
            TypedQuery typedQuery = entityManager.createQuery(criteriaQuery);
            typedQuery.setFirstResult(start);
            typedQuery.setMaxResults(pageSize + 1);
            boolean hasMore = false;
            List resultList = typedQuery.getResultList();
            if (resultList.size() > pageSize) {
                resultList.remove(resultList.size() - 1);
                hasMore = true;
            }
            int totalSize = start + resultList.size();
            if (hasMore) {
                totalSize = this.executeCountQuery(criteria, entityManager, type);
            }
            results.setTotalSize(totalSize);
            results.setBeans(resultList);
            return results;
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            throw new StorageException(t);
        }
    }

    protected <T> int executeCountQuery(SearchCriteriaBean criteria, EntityManager entityManager, Class<T> type) {
        CriteriaBuilder builder = entityManager.getCriteriaBuilder();
        CriteriaQuery countQuery = builder.createQuery(Long.class);
        Root from = countQuery.from(type);
        countQuery.select((Selection)builder.count((Expression)from));
        this.applySearchCriteriaToQuery(criteria, builder, countQuery, from, true);
        TypedQuery query = entityManager.createQuery(countQuery);
        return ((Long)query.getSingleResult()).intValue();
    }

    protected <T> void applySearchCriteriaToQuery(SearchCriteriaBean criteria, CriteriaBuilder builder, CriteriaQuery<?> query, Root<T> from, boolean countOnly) {
        OrderByBean orderBy;
        List filters = criteria.getFilters();
        if (filters != null && !filters.isEmpty()) {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            for (SearchCriteriaFilterBean filter : filters) {
                if (filter.getOperator().intern() == "eq") {
                    Path path = from.get(filter.getName());
                    Class pathc = path.getJavaType();
                    if (pathc.isAssignableFrom(String.class)) {
                        predicates.add(builder.equal((Expression)path, (Object)filter.getValue()));
                        continue;
                    }
                    if (!pathc.isEnum()) continue;
                    predicates.add(builder.equal((Expression)path, Enum.valueOf(pathc, filter.getValue())));
                    continue;
                }
                if (filter.getOperator().intern() == "bool_eq") {
                    predicates.add(builder.equal((Expression)from.get(filter.getName()), (Object)Boolean.valueOf(filter.getValue())));
                    continue;
                }
                if (filter.getOperator().intern() == "gt") {
                    predicates.add(builder.greaterThan((Expression)from.get(filter.getName()), (Comparable)new Long(filter.getValue())));
                    continue;
                }
                if (filter.getOperator().intern() == "gte") {
                    predicates.add(builder.greaterThanOrEqualTo((Expression)from.get(filter.getName()), (Comparable)new Long(filter.getValue())));
                    continue;
                }
                if (filter.getOperator().intern() == "lt") {
                    predicates.add(builder.lessThan((Expression)from.get(filter.getName()), (Comparable)new Long(filter.getValue())));
                    continue;
                }
                if (filter.getOperator().intern() == "lte") {
                    predicates.add(builder.lessThanOrEqualTo((Expression)from.get(filter.getName()), (Comparable)new Long(filter.getValue())));
                    continue;
                }
                if (filter.getOperator().intern() == "neq") {
                    predicates.add(builder.notEqual((Expression)from.get(filter.getName()), (Object)filter.getValue()));
                    continue;
                }
                if (filter.getOperator().intern() != "like") continue;
                predicates.add(builder.like(builder.upper((Expression)from.get(filter.getName())), filter.getValue().toUpperCase().replace('*', '%')));
            }
            query.where(predicates.toArray(new Predicate[predicates.size()]));
        }
        if ((orderBy = criteria.getOrderBy()) != null && !countOnly) {
            if (orderBy.isAscending()) {
                query.orderBy(new Order[]{builder.asc((Expression)from.get(orderBy.getName()))});
            } else {
                query.orderBy(new Order[]{builder.desc((Expression)from.get(orderBy.getName()))});
            }
        }
    }

    public IEntityManagerFactoryAccessor getEmfAccessor() {
        return this.emfAccessor;
    }

    public void setEmfAccessor(IEntityManagerFactoryAccessor emfAccessor) {
        this.emfAccessor = emfAccessor;
    }
}

