/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.apiman.dt.api.security.impl;

import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import org.overlord.apiman.dt.api.beans.idm.PermissionBean;
import org.overlord.apiman.dt.api.beans.idm.PermissionType;
import org.overlord.apiman.dt.api.core.IIdmStorage;
import org.overlord.apiman.dt.api.core.exceptions.StorageException;
import org.overlord.apiman.dt.api.security.ISecurityContext;
import org.overlord.apiman.dt.api.security.i18n.Messages;
import org.overlord.apiman.dt.api.security.impl.IndexedPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSecurityContext
implements ISecurityContext {
    private static Logger logger = LoggerFactory.getLogger(AbstractSecurityContext.class);
    private static final ThreadLocal<IndexedPermissions> permissions = new ThreadLocal();
    @Inject
    private IIdmStorage idmStorage;

    @Override
    public boolean hasPermission(PermissionType permission, String organizationId) {
        if (this.isAdmin()) {
            return true;
        }
        return this.getPermissions().hasQualifiedPermission(permission, organizationId);
    }

    @Override
    public Set<String> getPermittedOrganizations(PermissionType permission) {
        return this.getPermissions().getOrgQualifiers(permission);
    }

    private IndexedPermissions getPermissions() {
        IndexedPermissions rval = permissions.get();
        if (rval == null) {
            rval = this.loadPermissions();
            permissions.set(rval);
        }
        return rval;
    }

    private IndexedPermissions loadPermissions() {
        String userId = this.getCurrentUser();
        try {
            return new IndexedPermissions(this.getIdmStorage().getPermissions(userId));
        }
        catch (StorageException e) {
            logger.error(Messages.getString("AbstractSecurityContext.ErrorLoadingPermissions") + userId, (Throwable)e);
            return new IndexedPermissions(new HashSet<PermissionBean>());
        }
    }

    protected static void clearPermissions() {
        permissions.remove();
    }

    public IIdmStorage getIdmStorage() {
        return this.idmStorage;
    }

    public void setIdmStorage(IIdmStorage idmStorage) {
        this.idmStorage = idmStorage;
    }
}

