/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.apiman.dt.api.security.impl;

import javax.enterprise.context.ApplicationScoped;
import javax.servlet.http.HttpServletRequest;
import org.overlord.apiman.dt.api.security.impl.AbstractSecurityContext;

@ApplicationScoped
public class DefaultSecurityContext
extends AbstractSecurityContext {
    private static final ThreadLocal<HttpServletRequest> servletRequest = new ThreadLocal();

    @Override
    public String getRequestHeader(String headerName) {
        return servletRequest.get().getHeader(headerName);
    }

    @Override
    public String getCurrentUser() {
        return servletRequest.get().getRemoteUser();
    }

    @Override
    public boolean isAdmin() {
        return servletRequest.get().isUserInRole("apiadmin");
    }

    protected static void setServletRequest(HttpServletRequest request) {
        servletRequest.set(request);
    }

    protected static void clearPermissions() {
        AbstractSecurityContext.clearPermissions();
    }

    protected static void clearServletRequest() {
        servletRequest.remove();
    }
}

