/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.apiman.dt.test.server;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.EnumSet;
import java.util.EventListener;
import javax.naming.InitialContext;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingException;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import org.apache.commons.dbcp.BasicDataSource;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.security.Credential;
import org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher;
import org.jboss.resteasy.plugins.server.servlet.ResteasyBootstrap;
import org.jboss.weld.environment.servlet.BeanManagerResourceBindingListener;
import org.jboss.weld.environment.servlet.Listener;
import org.overlord.apiman.dt.api.security.impl.DefaultSecurityContextFilter;
import org.overlord.apiman.dt.api.webapp.jetty8.JettyDtApiApplication;
import org.overlord.apiman.dt.test.server.DatabaseSeedFilter;
import org.overlord.apiman.dt.test.server.DtApiTestAuthFilter;
import org.overlord.apiman.dt.test.server.MockGatewayServlet;
import org.overlord.apiman.dt.test.server.TestUsers;
import org.overlord.commons.gwt.server.filters.SimpleCorsFilter;
import org.overlord.commons.i18n.server.filters.LocaleFilter;

public class DtApiTestServer {
    private BasicDataSource ds = null;
    private Server server;

    public void start() throws Exception {
        long startTime = System.currentTimeMillis();
        System.out.println("**** Starting Server (" + this.getClass().getSimpleName() + ")");
        this.preStart();
        ContextHandlerCollection handlers = new ContextHandlerCollection();
        this.addModulesToJetty(handlers);
        int serverPort = this.serverPort();
        this.server = new Server(serverPort);
        this.server.setHandler((Handler)handlers);
        this.server.start();
        long endTime = System.currentTimeMillis();
        System.out.println("******* Started in " + (endTime - startTime) + "ms");
    }

    public void stop() throws Exception {
        this.server.stop();
        this.ds.close();
        InitialContext ctx = new InitialContext();
        ctx.unbind("java:comp/env/jdbc/ApiManDT");
    }

    public int serverPort() {
        return 7070;
    }

    protected void preStart() {
        System.setProperty("hibernate.hbm2ddl.auto", "create-drop");
        try {
            InitialContext ctx = new InitialContext();
            this.ensureCtx(ctx, "java:/comp/env");
            this.ensureCtx(ctx, "java:/comp/env/jdbc");
            this.ds = DtApiTestServer.createInMemoryDatasource();
            ctx.bind("java:/comp/env/jdbc/ApiManDT", (Object)this.ds);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void ensureCtx(InitialContext ctx, String name) throws NamingException {
        try {
            ctx.bind(name, (Object)new InitialContext());
        }
        catch (NameAlreadyBoundException nameAlreadyBoundException) {
            // empty catch block
        }
    }

    private static BasicDataSource createInMemoryDatasource() throws SQLException {
        System.setProperty("hibernate.dialect", "org.hibernate.dialect.H2Dialect");
        BasicDataSource ds = new BasicDataSource();
        ds.setDriverClassName(Driver.class.getName());
        ds.setUsername("sa");
        ds.setPassword("");
        ds.setUrl("jdbc:h2:mem:test;DB_CLOSE_DELAY=-1");
        Connection connection = ds.getConnection();
        connection.close();
        System.out.println("DataSource created and bound to JNDI.");
        return ds;
    }

    protected void addModulesToJetty(ContextHandlerCollection handlers) throws Exception {
        ServletContextHandler apiManServer = new ServletContextHandler(1);
        apiManServer.setSecurityHandler(this.createSecurityHandler());
        apiManServer.setContextPath("/apiman-dt-api");
        apiManServer.addEventListener((EventListener)new Listener());
        apiManServer.addEventListener((EventListener)new BeanManagerResourceBindingListener());
        apiManServer.addEventListener((EventListener)new ResteasyBootstrap());
        apiManServer.addFilter(DatabaseSeedFilter.class, "/db-seeder", EnumSet.of(DispatcherType.REQUEST));
        apiManServer.addFilter(LocaleFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        apiManServer.addFilter(SimpleCorsFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        apiManServer.addFilter(DtApiTestAuthFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        apiManServer.addFilter(DefaultSecurityContextFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        ServletHolder resteasyServlet = new ServletHolder((Servlet)new HttpServletDispatcher());
        resteasyServlet.setInitParameter("javax.ws.rs.Application", JettyDtApiApplication.class.getName());
        apiManServer.addServlet(resteasyServlet, "/*");
        apiManServer.setInitParameter("resteasy.injector.factory", "org.jboss.resteasy.cdi.CdiInjectorFactory");
        apiManServer.setInitParameter("resteasy.scan", "true");
        apiManServer.setInitParameter("resteasy.servlet.mapping.prefix", "");
        handlers.addHandler((Handler)apiManServer);
        ServletContextHandler mockGatewayServer = new ServletContextHandler(1);
        mockGatewayServer.setSecurityHandler(this.createSecurityHandler());
        mockGatewayServer.setContextPath("/mock-gateway");
        ServletHolder mockGatewayServlet = new ServletHolder((Servlet)new MockGatewayServlet());
        mockGatewayServer.addServlet(mockGatewayServlet, "/*");
        handlers.addHandler((Handler)mockGatewayServer);
    }

    private SecurityHandler createSecurityHandler() {
        HashLoginService l = new HashLoginService();
        for (String[] userInfo : TestUsers.USERS) {
            String user = userInfo[0];
            String pwd = userInfo[1];
            String[] roles = new String[]{"apiuser"};
            if (user.startsWith("admin")) {
                roles = new String[]{"apiuser", "apiadmin"};
            }
            l.putUser(user, Credential.getCredential((String)pwd), roles);
        }
        l.setName("apimanrealm");
        ConstraintSecurityHandler csh = new ConstraintSecurityHandler();
        csh.setAuthenticator((Authenticator)new BasicAuthenticator());
        csh.setRealmName("apimanrealm");
        csh.setLoginService((LoginService)l);
        return csh;
    }
}

