/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.apiman.dt.ui.server;

import org.apache.commons.configuration.Configuration;
import org.overlord.apiman.dt.ui.client.shared.beans.ApiAuthType;
import org.overlord.apiman.dt.ui.server.IUIConfig;
import org.overlord.commons.config.ConfigurationFactory;

public class UIConfig
implements IUIConfig {
    public static final String APIMAN_DT_UI_CONFIG_FILE_NAME = "apiman-dt-ui.config.file.name";
    public static final String APIMAN_DT_UI_CONFIG_FILE_REFRESH = "apiman-dt-ui.config.file.refresh";
    public static final String APIMAN_DT_UI_API_ENDPOINT = "apiman-dt-ui.dt-api.endpoint";
    public static final String APIMAN_DT_UI_API_AUTH_TYPE = "apiman-dt-ui.dt-api.authentication.type";
    public static final String APIMAN_DT_UI_API_BASIC_AUTH_USER = "apiman-dt-ui.dt-api.authentication.basic.user";
    public static final String APIMAN_DT_UI_API_BASIC_AUTH_PASS = "apiman-dt-ui.dt-api.authentication.basic.password";
    public static final String APIMAN_DT_UI_API_AUTH_TOKEN_GENERATOR = "apiman-dt-ui.dt-api.authentication.token.generator";
    public static final String APIMAN_DT_UI_GATEWAY_URL = "apiman-dt-ui.gateway.base-url";
    public static final String APIMAN_DT_UI_LOGOUT_URL = "apiman-dt-ui.logout-url";
    private static Configuration config;

    public String getManagementApiEndpoint() {
        return config.getString(APIMAN_DT_UI_API_ENDPOINT);
    }

    public ApiAuthType getManagementApiAuthType() {
        String at = config.getString(APIMAN_DT_UI_API_AUTH_TYPE);
        try {
            return ApiAuthType.valueOf((String)at);
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid API authentication type: " + at);
        }
    }

    public String getGatewayUrl() {
        return config.getString(APIMAN_DT_UI_GATEWAY_URL, "http://localhost:8080/apiman-rt/gateway");
    }

    public String getLogoutUrl() {
        return config.getString(APIMAN_DT_UI_LOGOUT_URL, "logout");
    }

    public String getManagementApiAuthUsername() {
        return config.getString(APIMAN_DT_UI_API_BASIC_AUTH_USER);
    }

    public String getManagementApiAuthPassword() {
        return config.getString(APIMAN_DT_UI_API_BASIC_AUTH_PASS);
    }

    public String getManagementApiAuthTokenGenerator() {
        return config.getString(APIMAN_DT_UI_API_AUTH_TOKEN_GENERATOR);
    }

    public Configuration getConfig() {
        return config;
    }

    static {
        String configFile = System.getProperty(APIMAN_DT_UI_CONFIG_FILE_NAME);
        String refreshDelayStr = System.getProperty(APIMAN_DT_UI_CONFIG_FILE_REFRESH);
        Long refreshDelay = 5000L;
        if (refreshDelayStr != null) {
            refreshDelay = new Long(refreshDelayStr);
        }
        config = ConfigurationFactory.createConfig((String)configFile, (String)"apiman.properties", (Long)refreshDelay, null, UIConfig.class);
    }
}

