/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.apiman.rt.war;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.overlord.apiman.rt.engine.IComponent;
import org.overlord.apiman.rt.engine.IConnectorFactory;
import org.overlord.apiman.rt.engine.IEngineConfig;
import org.overlord.apiman.rt.engine.IRegistry;
import org.overlord.apiman.rt.engine.i18n.Messages;
import org.overlord.apiman.rt.engine.policy.IPolicyFactory;
import org.overlord.commons.config.ConfigurationFactory;

public class WarEngineConfig
implements IEngineConfig {
    public static final String APIMAN_RT_CONFIG_FILE_NAME = "apiman-rt.config.file.name";
    public static final String APIMAN_RT_CONFIG_FILE_REFRESH = "apiman-rt.config.file.refresh";
    public static final String APIMAN_RT_REGISTRY_CLASS = "apiman-rt.registry";
    public static final String APIMAN_RT_CONNECTOR_FACTORY_CLASS = "apiman-rt.connector-factory";
    public static final String APIMAN_RT_POLICY_FACTORY_CLASS = "apiman-rt.policy-factory";
    public static final String APIMAN_RT_COMPONENT_PREFIX = "apiman-rt.components.";
    public static final String APIMAN_RT_GATEWAY_SERVER_PORT = "apiman-rt.gateway.server.port";
    public static Configuration config;

    public Configuration getConfig() {
        return config;
    }

    public Class<IRegistry> getRegistryClass() {
        return this.loadConfigClass(APIMAN_RT_REGISTRY_CLASS, IRegistry.class);
    }

    public Map<String, String> getRegistryConfig() {
        return this.getConfigMap("apiman-rt.registry.");
    }

    public Class<IConnectorFactory> getConnectorFactoryClass() {
        return this.loadConfigClass(APIMAN_RT_CONNECTOR_FACTORY_CLASS, IConnectorFactory.class);
    }

    public Map<String, String> getConnectorFactoryConfig() {
        return this.getConfigMap("apiman-rt.connector-factory.");
    }

    public Class<IPolicyFactory> getPolicyFactoryClass() {
        return this.loadConfigClass(APIMAN_RT_POLICY_FACTORY_CLASS, IPolicyFactory.class);
    }

    public Map<String, String> getPolicyFactoryConfig() {
        return this.getConfigMap("apiman-rt.policy-factory.");
    }

    public <T extends IComponent> Class<T> getComponentClass(Class<T> componentType) {
        return this.loadConfigClass(APIMAN_RT_COMPONENT_PREFIX + componentType.getSimpleName(), componentType);
    }

    public <T extends IComponent> Map<String, String> getComponentConfig(Class<T> componentType) {
        return this.getConfigMap(APIMAN_RT_COMPONENT_PREFIX + componentType.getSimpleName() + ".");
    }

    public int getServerPort() {
        return config.getInt(APIMAN_RT_GATEWAY_SERVER_PORT, 8080);
    }

    private <T> Class<T> loadConfigClass(String property, Class<T> type) {
        String classname = this.getConfig().getString(property);
        if (classname == null) {
            throw new RuntimeException("No " + type.getSimpleName() + " class configured.");
        }
        try {
            Class<?> c = Thread.currentThread().getContextClassLoader().loadClass(classname);
            return c;
        }
        catch (ClassNotFoundException e) {
            try {
                Class<?> c = Class.forName(classname);
                return c;
            }
            catch (ClassNotFoundException e2) {
                throw new RuntimeException(Messages.i18n.format("EngineConfig.FailedToLoadClass", new Object[]{classname}));
            }
        }
    }

    private Map<String, String> getConfigMap(String prefix) {
        HashMap<String, String> rval = new HashMap<String, String>();
        Iterator keys = config.getKeys(prefix + ".");
        while (keys.hasNext()) {
            String key = String.valueOf(keys.next());
            rval.put(key, config.getString(key));
        }
        return rval;
    }

    static {
        String configFile = System.getProperty(APIMAN_RT_CONFIG_FILE_NAME);
        String refreshDelayStr = System.getProperty(APIMAN_RT_CONFIG_FILE_REFRESH);
        Long refreshDelay = 5000L;
        if (refreshDelayStr != null) {
            refreshDelay = new Long(refreshDelayStr);
        }
        config = ConfigurationFactory.createConfig((String)configFile, (String)"apiman.properties", (Long)refreshDelay, null, WarEngineConfig.class);
    }
}

